/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.validation;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.validation.MarkupValidatorDelegate;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.validation.JSPMarkupValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.ui.internal.validation.MarkupValidator;

public class JSPSourceValidator
implements MarkupValidatorDelegate {
    protected MarkupValidator val = new JSPMarkupValidator();

    public void validate(IResource resource, IReporter reporter) {
        this.validateFile((IFile)resource, reporter);
        this.updateMessages(resource, reporter);
    }

    private void updateMessages(IResource resource, IReporter reporter) {
        List msgList = reporter.getMessages();
        if (msgList == null) {
            return;
        }
        int i = 0;
        while (i < msgList.size()) {
            Object msgObject = msgList.get(i);
            if (msgObject instanceof IMessage) {
                IMessage message = (IMessage)msgObject;
                message.setTargetObject((Object)resource);
            }
            ++i;
        }
    }

    private void validateFile(IFile file, IReporter reporter) {
        LocalizedMessage message = new LocalizedMessage(4, file.getFullPath().toString().substring(1));
        reporter.displaySubtask((IValidator)this.val, (IMessage)message);
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            IStructuredDocument document = null;
            if (model != null) {
                document = model.getStructuredDocument();
                this.val.connect((IDocument)document);
                IStructuredDocumentRegion validationRegion = document.getFirstStructuredDocumentRegion();
                while (validationRegion != null) {
                    this.val.validate(validationRegion, reporter);
                    validationRegion = validationRegion.getNext();
                }
                this.val.disconnect((IDocument)document);
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }
}

