/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.swt;

import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanButtonModelAdapter {
    protected final WritablePropertyValueModel<Boolean> booleanHolder;
    protected final PropertyChangeListener booleanChangeListener;
    protected final Button button;
    protected final SelectionListener buttonSelectionListener;
    protected final DisposeListener buttonDisposeListener;
    protected final boolean defaultValue;

    public static BooleanButtonModelAdapter adapt(WritablePropertyValueModel<Boolean> booleanHolder, Button button) {
        return new BooleanButtonModelAdapter(booleanHolder, button);
    }

    public static BooleanButtonModelAdapter adapt(WritablePropertyValueModel<Boolean> booleanHolder, Button button, boolean defaultValue) {
        return new BooleanButtonModelAdapter(booleanHolder, button, defaultValue);
    }

    protected BooleanButtonModelAdapter(WritablePropertyValueModel<Boolean> booleanHolder, Button button) {
        this(booleanHolder, button, false);
    }

    protected BooleanButtonModelAdapter(WritablePropertyValueModel<Boolean> booleanHolder, Button button, boolean defaultValue) {
        if (booleanHolder == null || button == null) {
            throw new NullPointerException();
        }
        this.booleanHolder = booleanHolder;
        this.button = button;
        this.defaultValue = defaultValue;
        this.booleanChangeListener = this.buildBooleanChangeListener();
        this.booleanHolder.addPropertyChangeListener("value", this.booleanChangeListener);
        this.buttonDisposeListener = this.buildButtonDisposeListener();
        this.button.addDisposeListener(this.buttonDisposeListener);
        this.buttonSelectionListener = this.buildButtonSelectionListener();
        this.button.addSelectionListener(this.buttonSelectionListener);
        this.setButtonSelection((Boolean)this.booleanHolder.getValue());
    }

    protected PropertyChangeListener buildBooleanChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildBooleanChangeListener_());
    }

    protected PropertyChangeListener buildBooleanChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                BooleanButtonModelAdapter.this.booleanChanged(event);
            }

            public String toString() {
                return "boolean listener";
            }
        };
    }

    protected SelectionListener buildButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BooleanButtonModelAdapter.this.buttonSelected(event);
            }

            public String toString() {
                return "button selection listener";
            }
        };
    }

    protected DisposeListener buildButtonDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BooleanButtonModelAdapter.this.buttonDisposed(event);
            }

            public String toString() {
                return "button dispose listener";
            }
        };
    }

    protected void booleanChanged(PropertyChangeEvent event) {
        this.setButtonSelection((Boolean)event.getNewValue());
    }

    protected void setButtonSelection(Boolean b) {
        if (this.button.isDisposed()) {
            return;
        }
        this.button.setSelection(this.booleanValue(b));
    }

    protected boolean booleanValue(Boolean b) {
        return b != null ? b.booleanValue() : this.defaultValue();
    }

    protected boolean defaultValue() {
        return this.defaultValue;
    }

    protected void buttonSelected(SelectionEvent event) {
        if (this.button.isDisposed()) {
            return;
        }
        this.booleanHolder.setValue((Object)this.button.getSelection());
    }

    protected void buttonDisposed(DisposeEvent event) {
        this.button.removeSelectionListener(this.buttonSelectionListener);
        this.button.removeDisposeListener(this.buttonDisposeListener);
        this.booleanHolder.removePropertyChangeListener("value", this.booleanChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.booleanHolder);
    }
}

