/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.CategoryFilterActionGroup;
import org.eclipse.wst.jsdt.internal.ui.actions.LexicalSortingAction;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.actions.MemberFilterActionGroup;

public class MembersView
extends JavaBrowsingPart
implements IPropertyChangeListener {
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private CategoryFilterActionGroup fCategoryFilterActionGroup;
    static /* synthetic */ Class class$0;

    public MembersView() {
        this.setHasWorkingSetFilter(false);
        this.setHasCustomSetFilter(true);
        JavaScriptPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected JavaUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(0x21000020402AL | JavaScriptElementLabels.ALL_CATEGORY, 1);
    }

    protected String getHelpContextId() {
        return "org.eclipse.wst.jsdt.ui.members_view_context";
    }

    protected String getLinkToEditorKey() {
        return "org.eclipse.wst.jsdt.ui.browsing.memberstoeditor";
    }

    protected StructuredViewer createViewer(Composite parent) {
        ProblemTreeViewer viewer = new ProblemTreeViewer(parent, 2);
        ColoredViewersManager.install((StructuredViewer)viewer);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)viewer, JavaScriptUI.ID_MEMBERS_VIEW);
        return viewer;
    }

    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)new LexicalSortingAction(this.getViewer(), JavaScriptUI.ID_MEMBERS_VIEW));
        this.fMemberFilterActionGroup.contributeToToolBar(tbm);
        super.fillToolBar(tbm);
    }

    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.fCategoryFilterActionGroup = new CategoryFilterActionGroup(this.getViewer(), this.getViewSite().getId(), this.getCategoryFilterActionGroupInput());
        this.fCategoryFilterActionGroup.contributeToViewMenu(actionBars.getMenuManager());
    }

    protected void setInput(Object input) {
        super.setInput(input);
        if (this.fCategoryFilterActionGroup != null) {
            this.fCategoryFilterActionGroup.setInput(this.getCategoryFilterActionGroupInput());
        }
    }

    private IJavaScriptElement[] getCategoryFilterActionGroupInput() {
        Object input = this.getInput();
        if (input instanceof IJavaScriptElement) {
            return new IJavaScriptElement[]{(IJavaScriptElement)input};
        }
        return new IJavaScriptElement[0];
    }

    protected boolean isValidInput(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            return type.isBinary() || type.getDeclaringType() == null;
        }
        return false;
    }

    protected boolean isValidElement(Object element) {
        Object input;
        if (element instanceof IMember) {
            return super.isValidElement(((IMember)element).getDeclaringType());
        }
        if (element instanceof IImportDeclaration) {
            return this.isValidElement(((IJavaScriptElement)element).getParent());
        }
        if (element instanceof IImportContainer && (input = this.getViewer().getInput()) instanceof IJavaScriptElement) {
            IJavaScriptUnit cu = (IJavaScriptUnit)((IJavaScriptElement)input).getAncestor(5);
            if (cu != null) {
                IJavaScriptUnit importContainerCu = (IJavaScriptUnit)((IJavaScriptElement)element).getAncestor(5);
                return cu.equals(importContainerCu);
            }
            IClassFile cf = (IClassFile)((IJavaScriptElement)input).getAncestor(6);
            IClassFile importContainerCf = (IClassFile)((IJavaScriptElement)element).getAncestor(6);
            return cf != null && cf.equals(importContainerCf);
        }
        return false;
    }

    protected IJavaScriptElement findElementToSelect(IJavaScriptElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                if (((IType)je).getDeclaringType() == null) {
                    return null;
                }
                return je;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return je;
            }
            case 13: {
                IJavaScriptUnit cu = (IJavaScriptUnit)je.getParent().getParent();
                try {
                    Object selectedElement;
                    if (cu.getImports()[0].equals(je) && (selectedElement = this.getSingleElementFromSelection(this.getViewer().getSelection())) instanceof IImportContainer) {
                        return (IImportContainer)selectedElement;
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
                return je;
            }
        }
        return null;
    }

    protected IJavaScriptElement findInputForJavaElement(IJavaScriptElement je) {
        if (je == null || !je.exists() || je.getJavaScriptProject() != null && !je.getJavaScriptProject().isOnIncludepath(je)) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                IType type = ((IType)je).getDeclaringType();
                if (type == null) {
                    return je;
                }
                return this.findInputForJavaElement((IJavaScriptElement)type);
            }
            case 5: {
                return this.getTypeForCU((IJavaScriptUnit)je);
            }
            case 6: {
                return this.findInputForJavaElement((IJavaScriptElement)((IClassFile)je).getType());
            }
            case 13: {
                return this.findInputForJavaElement(je.getParent());
            }
            case 11: 
            case 12: {
                IJavaScriptElement parent = je.getParent();
                if (parent instanceof IJavaScriptUnit) {
                    return this.getTypeForCU((IJavaScriptUnit)parent);
                }
                if (parent instanceof IClassFile) {
                    return this.findInputForJavaElement(parent);
                }
                return null;
            }
        }
        if (je instanceof IMember) {
            return this.findInputForJavaElement((IJavaScriptElement)((IMember)je).getDeclaringType());
        }
        return null;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.fMemberFilterActionGroup.saveState(memento);
    }

    protected void restoreState(IMemento memento) {
        super.restoreState(memento);
        this.fMemberFilterActionGroup.restoreState(memento);
        this.getViewer().getControl().setRedraw(false);
        this.getViewer().refresh();
        this.getViewer().getControl().setRedraw(true);
    }

    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)MembersView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    boolean isInputAWorkingCopy() {
        IJavaScriptUnit cu;
        Object input = this.getViewer().getInput();
        if (input instanceof IJavaScriptElement && (cu = (IJavaScriptUnit)((IJavaScriptElement)input).getAncestor(5)) != null) {
            return cu.isWorkingCopy();
        }
        return false;
    }

    protected void restoreSelection() {
        IEditorPart editor = this.getViewSite().getPage().getActiveEditor();
        if (editor != null) {
            this.setSelectionFromEditor((IWorkbenchPart)editor);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            this.getViewer().refresh();
        }
    }

    public void dispose() {
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fCategoryFilterActionGroup != null) {
            this.fCategoryFilterActionGroup.dispose();
            this.fCategoryFilterActionGroup = null;
        }
        super.dispose();
        JavaScriptPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

