/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;

public class CreateTypeHierarchyOperation
extends JavaModelOperation {
    protected TypeHierarchy typeHierarchy;

    public CreateTypeHierarchyOperation(IRegion region, IJavaScriptUnit[] workingCopies, IType element, boolean computeSubtypes) {
        super(element);
        this.typeHierarchy = new RegionBasedTypeHierarchy(region, workingCopies, element, computeSubtypes);
    }

    public CreateTypeHierarchyOperation(IType element, IJavaScriptUnit[] workingCopies, IJavaScriptSearchScope scope, boolean computeSubtypes) {
        super(element);
        IJavaScriptUnit[] copies;
        if (workingCopies != null) {
            int length = workingCopies.length;
            copies = new IJavaScriptUnit[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        } else {
            copies = null;
        }
        this.typeHierarchy = new TypeHierarchy(element, copies, scope, computeSubtypes);
    }

    public CreateTypeHierarchyOperation(IType element, IJavaScriptUnit[] workingCopies, IJavaScriptProject project, boolean computeSubtypes) {
        super(element);
        IJavaScriptUnit[] copies;
        if (workingCopies != null) {
            int length = workingCopies.length;
            copies = new IJavaScriptUnit[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        } else {
            copies = null;
        }
        this.typeHierarchy = new TypeHierarchy(element, copies, project, computeSubtypes);
    }

    protected void executeOperation() throws JavaScriptModelException {
        this.typeHierarchy.refresh(this);
    }

    public ITypeHierarchy getResult() {
        return this.typeHierarchy;
    }

    public boolean isReadOnly() {
        return true;
    }

    public IJavaScriptModelStatus verify() {
        IJavaScriptElement elementToProcess = this.getElementToProcess();
        if (elementToProcess == null && !(this.typeHierarchy instanceof RegionBasedTypeHierarchy)) {
            return new JavaModelStatus(968);
        }
        if (elementToProcess != null && !elementToProcess.exists()) {
            return new JavaModelStatus(969, elementToProcess);
        }
        IJavaScriptProject project = this.typeHierarchy.javaProject();
        if (project != null && !project.exists()) {
            return new JavaModelStatus(969, project);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

