/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.util;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletResponse;

public final class HTMLUtils {
    public static final String UTF8_ENCODING = "UTF-8";
    public static final String LINE_BREAK = "<br>";
    public static final String LINE_SEPARATOR = System.getProperties().getProperty("line.separator");
    private static final String LESS_THAN = "<";
    private static final String LESS_THAN_HTML_ENTITY = "&lt;";
    private static final String GREATER_THAN = ">";
    private static final String GREATER_THAN_HTML_ENTITY = "&gt;";
    private static final String SPACE = " ";
    private static final String SPACE_HTML_ENTITY = "&nbsp;";
    private static final String AMPERSAND = "&";
    private static final String AMPERSAND_HTML_ENTITY = "&amp;";
    private static final String QUOTATION = "\"";
    private static final String QUOTATION_HTML_ENTITY = "&quot;";

    public static final String getHTMLImageTag(HttpServletResponse response, String src, String alt, String width, String height, Hashtable additionalAttributes) {
        StringBuffer tag = new StringBuffer("<img src=\"");
        tag.append(response.encodeURL(src)).append('\"');
        if (alt == null) {
            alt = "";
        }
        tag.append(" alt=\"").append(alt).append('\"');
        tag.append(" title=\"").append(alt).append('\"');
        if (width != null) {
            tag.append(" width=").append(width);
        }
        if (height != null) {
            tag.append(" height=").append(height);
        }
        tag.append(" border=0");
        if (additionalAttributes != null) {
            Enumeration keys = additionalAttributes.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                tag.append(' ').append(key).append("=\"").append((String)additionalAttributes.get(key)).append('\"');
            }
        }
        tag.append('>');
        return tag.toString();
    }

    public static final String getHTMLLinkTag(HttpServletResponse response, String href, String target, String name, String label, Hashtable additionalAttributes) {
        StringBuffer tag = new StringBuffer("<a href=\"");
        tag.append(response.encodeURL(href)).append('\"');
        if (target != null) {
            tag.append(" target=\"").append(target).append('\"');
        }
        if (name != null) {
            tag.append(" name=\"").append(name).append('\"');
        }
        if (additionalAttributes != null) {
            Enumeration keys = additionalAttributes.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                tag.append(' ').append(key).append("=\"").append((String)additionalAttributes.get(key)).append('\"');
            }
        }
        tag.append('>');
        tag.append(label);
        tag.append("</a>");
        return tag.toString();
    }

    public static final String redAsterisk() {
        return "<font color=\"#ff0000\">*</font>";
    }

    public static final String JSMangle(String input) {
        if (input == null) {
            return "";
        }
        StringBuffer mangledOutput = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            switch (c) {
                case '\n': {
                    mangledOutput.append("\\n");
                    break;
                }
                case '\r': {
                    mangledOutput.append("\\r");
                    break;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    mangledOutput.append('\\');
                }
                default: {
                    mangledOutput.append(c);
                }
            }
            ++i;
        }
        return mangledOutput.toString();
    }

    public static final String charactersToHTMLEntities(String s) {
        s = HTMLUtils.stringReplace(s, AMPERSAND, AMPERSAND_HTML_ENTITY);
        s = HTMLUtils.stringReplace(s, LESS_THAN, LESS_THAN_HTML_ENTITY);
        s = HTMLUtils.stringReplace(s, GREATER_THAN, GREATER_THAN_HTML_ENTITY);
        s = HTMLUtils.stringReplace(s, SPACE, SPACE_HTML_ENTITY);
        s = HTMLUtils.stringReplace(s, QUOTATION, QUOTATION_HTML_ENTITY);
        return s;
    }

    public static final String charactersToHTMLEntitiesStrict(String s) {
        s = HTMLUtils.stringReplace(s, AMPERSAND, AMPERSAND_HTML_ENTITY);
        s = HTMLUtils.stringReplace(s, LESS_THAN, LESS_THAN_HTML_ENTITY);
        s = HTMLUtils.stringReplace(s, GREATER_THAN, GREATER_THAN_HTML_ENTITY);
        s = HTMLUtils.stringReplace(s, QUOTATION, QUOTATION_HTML_ENTITY);
        return s;
    }

    public static final String htmlEntitiesToCharacters(String s) {
        s = HTMLUtils.stringReplace(s, LESS_THAN_HTML_ENTITY, LESS_THAN);
        s = HTMLUtils.stringReplace(s, GREATER_THAN_HTML_ENTITY, GREATER_THAN);
        s = HTMLUtils.stringReplace(s, SPACE_HTML_ENTITY, SPACE);
        s = HTMLUtils.stringReplace(s, AMPERSAND_HTML_ENTITY, AMPERSAND);
        s = HTMLUtils.stringReplace(s, QUOTATION_HTML_ENTITY, QUOTATION);
        return s;
    }

    private static final String stringReplace(String s, String oldString, String newString) {
        String sCopy = s;
        int fromIndex = 0;
        int oldStringIndex = sCopy.indexOf(oldString, fromIndex);
        StringBuffer sb = new StringBuffer();
        while (oldStringIndex != -1) {
            sb.setLength(0);
            sb.append(sCopy.substring(0, oldStringIndex));
            sb.append(newString);
            sb.append(sCopy.substring(oldStringIndex + oldString.length(), sCopy.length()));
            sCopy = sb.toString();
            fromIndex = oldStringIndex + newString.length();
            oldStringIndex = sCopy.indexOf(oldString, fromIndex);
        }
        return sCopy;
    }
}

