/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IStructuredDocumentContextResolverFactory2;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.IViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.IViewDefnAdapterFactory;
import org.eclipse.jst.jsf.designtime.internal.view.IViewRootHandle;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;

public class DTAppManagerUtil {
    public static XMLViewDefnAdapter getXMLViewDefnAdapter(IStructuredDocumentContext context) {
        IWorkspaceContextResolver wkResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        IProject project = wkResolver.getProject();
        IResource res = wkResolver.getResource();
        if (project != null && res instanceof IFile) {
            return DTAppManagerUtil.getXMLViewDefnAdapter(project, (IFile)res);
        }
        return null;
    }

    public static XMLViewDefnAdapter getXMLViewDefnAdapter(IFile file) {
        return DTAppManagerUtil.getXMLViewDefnAdapter(file.getProject(), file);
    }

    public static XMLViewDefnAdapter getXMLViewDefnAdapter(IProject project, IFile file) {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(project);
        if (manager == null) {
            return null;
        }
        IDTViewHandler viewHandler = DesignTimeApplicationManager.getInstance(project).getViewHandler();
        try {
            IViewDefnAdapterFactory factory;
            IViewDefnAdapter<?, ?> adapter;
            DTFacesContext facesContext = manager.getFacesContext(file);
            if (facesContext != null && (adapter = (factory = viewHandler.getViewMetadataAdapterFactory(facesContext)).createAdapter(facesContext, viewHandler.getViewId(facesContext, (IResource)file))) instanceof XMLViewDefnAdapter) {
                return (XMLViewDefnAdapter)adapter;
            }
        }
        catch (IDTViewHandler.ViewHandlerException e) {
            JSFCorePlugin.log(e, "");
        }
        return null;
    }

    public static IDTViewHandler getViewHandler(IProject project) {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(project);
        if (manager == null) {
            return null;
        }
        return DesignTimeApplicationManager.getInstance(project).getViewHandler();
    }

    public static IViewRootHandle getViewRootHandle(IStructuredDocumentContext context) {
        IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory2.INSTANCE.getWorkspaceContextResolver(context);
        if (resolver == null) {
            return null;
        }
        IProject project = null;
        project = resolver.getProject();
        if (project == null) {
            return null;
        }
        IResource resource = resolver.getResource();
        if (resource != null) {
            return DTAppManagerUtil.getViewRootHandle(resource);
        }
        return null;
    }

    public static IViewRootHandle getViewRootHandle(IResource res) {
        DTFacesContext facesContext;
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(res.getProject());
        if (manager != null && res instanceof IFile && (facesContext = manager.getFacesContext((IFile)res)) != null) {
            return facesContext.getViewRootHandle();
        }
        return null;
    }
}

