/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript.search;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.web.core.internal.JsCoreMessages;
import org.eclipse.wst.jsdt.web.core.internal.JsCorePlugin;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.internal.project.JsWebNature;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;
import org.eclipse.wst.jsdt.web.core.javascript.search.IndexWorkspaceJob;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsSearchSupport;

public class JsIndexManager {
    static final boolean DEBUG;
    private static final String PKEY_INDEX_STATE = "jspIndexState";
    private IndexWorkspaceJob indexingJob = new IndexWorkspaceJob();
    public static final int S_STABLE = 1;
    public static final int S_UPDATING = 2;
    public static final int S_REBUILDING = 3;
    public static final int S_CANCELED = 4;
    private final String OSGI_FRAMEWORK_ID = "org.eclipse.osgi";
    private static JsIndexManager fSingleton;
    private boolean initialized;
    private boolean initializing = true;
    private IndexJobCoordinator indexJobCoordinator;
    private IResourceChangeListener jspResourceChangeListener;
    private JSPResourceVisitor fVisitor = null;
    static long fTotalTime;
    private ProcessFilesJob processFilesJob = new ProcessFilesJob(JsCoreMessages.JSPIndexManager_0);

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jsindexmanager");
        DEBUG = value != null && value.equalsIgnoreCase("true");
        fSingleton = null;
        fTotalTime = 0L;
    }

    private JsIndexManager() {
        this.processFilesJob.setSystem(true);
        this.processFilesJob.setPriority(30);
        this.processFilesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                JsIndexManager.this.setStableState();
            }
        });
    }

    public static synchronized JsIndexManager getInstance() {
        if (fSingleton == null) {
            fSingleton = new JsIndexManager();
        }
        return fSingleton;
    }

    public void initialize() {
        JsIndexManager singleInstance = JsIndexManager.getInstance();
        if (!singleInstance.initialized) {
            singleInstance.initialized = true;
            singleInstance.indexJobCoordinator = new IndexJobCoordinator();
            singleInstance.jspResourceChangeListener = new JSPResourceChangeListener();
            Platform.getJobManager().addJobChangeListener((IJobChangeListener)singleInstance.indexJobCoordinator);
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.jspResourceChangeListener, 1);
            this.saveIndexes();
            singleInstance.initializing = false;
        }
    }

    synchronized void setIndexState(int state) {
        if (DEBUG) {
            System.out.println("JSPIndexManager setting index state to: " + this.state2String(state));
        }
        JsCorePlugin jspModelPlugin = JsCorePlugin.getDefault();
        jspModelPlugin.getPluginPreferences().setValue(PKEY_INDEX_STATE, state);
        jspModelPlugin.savePluginPreferences();
    }

    private String state2String(int state) {
        String s = "UNKNOWN";
        switch (state) {
            case 1: {
                s = "S_STABLE";
                break;
            }
            case 2: {
                s = "S_UPDATING";
                break;
            }
            case 4: {
                s = "S_CANCELED";
                break;
            }
            case 3: {
                s = "S_REBUILDING";
            }
        }
        return s;
    }

    int getIndexState() {
        return JsCorePlugin.getDefault().getPluginPreferences().getInt(PKEY_INDEX_STATE);
    }

    void setUpdatingState() {
        this.setIndexState(2);
    }

    void setCanceledState() {
        this.setIndexState(4);
    }

    void setStableState() {
        this.setIndexState(1);
    }

    void setRebuildingState() {
        this.setIndexState(3);
    }

    synchronized void rebuildIndexIfNeeded() {
        if (this.getIndexState() != 1) {
            this.rebuildIndex();
        }
    }

    void rebuildIndex() {
        if (DEBUG) {
            System.out.println("*** JSP Index unstable, requesting re-indexing");
        }
        this.getIndexingJob().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                super.aboutToRun(event);
                JsIndexManager.this.setRebuildingState();
            }

            public void done(IJobChangeEvent event) {
                super.done(event);
                JsIndexManager.this.setStableState();
                JsIndexManager.this.getIndexingJob().removeJobChangeListener((IJobChangeListener)this);
            }
        });
        this.getProcessFilesJob().clearFiles();
        this.getIndexingJob().schedule();
    }

    final void indexFiles(IFile[] files) {
        this.processFilesJob.process(files);
    }

    JSPResourceVisitor getVisitor() {
        if (this.fVisitor == null) {
            this.fVisitor = new JSPResourceVisitor();
        }
        return this.fVisitor;
    }

    void saveIndexes() {
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int j = 0;
        while (j < allProjects.length) {
            block6: {
                if (JsWebNature.hasNature(allProjects[j]) && allProjects[j].isOpen()) {
                    IPath jspModelWorkingLocation = JsSearchSupport.getInstance().getModelJspPluginWorkingLocation(allProjects[j]);
                    File folder = new File(jspModelWorkingLocation.toOSString());
                    String[] files = folder.list();
                    String locay = "";
                    try {
                        int i = 0;
                        while (i < files.length) {
                            if (files[i].toLowerCase().endsWith(".index")) {
                                locay = String.valueOf(jspModelWorkingLocation.toString()) + "/" + files[i];
                                indexManager.getIndex(allProjects[j].getFullPath(), (IPath)new Path(locay), true, false);
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block6;
                        e.printStackTrace();
                    }
                }
            }
            ++j;
        }
    }

    void saveIndexesORIGINAL() {
        block4: {
            IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
            IPath jspModelWorkingLocation = JsSearchSupport.getInstance().getModelJspPluginWorkingLocation();
            File folder = new File(jspModelWorkingLocation.toOSString());
            String[] files = folder.list();
            String locay = "";
            Index index = null;
            try {
                int i = 0;
                while (i < files.length) {
                    if (files[i].toLowerCase().endsWith(".index")) {
                        locay = String.valueOf(jspModelWorkingLocation.toString()) + "/" + files[i];
                        index = new Index(locay, "Index for " + locay, true);
                        indexManager.saveIndex(index);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block4;
                e.printStackTrace();
            }
        }
    }

    boolean frameworkIsShuttingDown() {
        boolean shuttingDown;
        boolean bl = shuttingDown = Platform.getBundle((String)"org.eclipse.osgi").getState() == 16;
        if (DEBUG && shuttingDown) {
            System.out.println("JSPIndexManager: system is shutting down!");
        }
        return shuttingDown;
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.jspResourceChangeListener);
        JsSearchSupport.getInstance().setCanceled(true);
        Platform.getJobManager().removeJobChangeListener((IJobChangeListener)this.indexJobCoordinator);
        int maxwait = 5000;
        if (this.processFilesJob != null) {
            this.processFilesJob.cancel();
        }
        this.waitTillNotRunning(maxwait, this.processFilesJob);
        if (this.indexingJob != null) {
            this.indexingJob.cancel();
        }
        this.waitTillNotRunning(maxwait, this.processFilesJob);
    }

    private void waitTillNotRunning(int maxSeconds, Job job) {
        int pauseTime = 10;
        int maxtries = maxSeconds / pauseTime;
        int count = 0;
        while (count++ < maxtries && job.getState() == 4) {
            try {
                Thread.sleep(pauseTime);
            }
            catch (InterruptedException e) {
                Logger.logException(e);
            }
        }
    }

    IndexWorkspaceJob getIndexingJob() {
        return this.indexingJob;
    }

    ProcessFilesJob getProcessFilesJob() {
        return this.processFilesJob;
    }

    boolean isInitializing() {
        return this.initializing;
    }

    private class IndexJobCoordinator
    extends JobChangeAdapter {
        private IndexJobCoordinator() {
        }

        public void aboutToRun(IJobChangeEvent event) {
            Job jobToCoordinate = event.getJob();
            if (this.isJobToAvoid(jobToCoordinate)) {
                JsIndexManager.this.getProcessFilesJob().cancel();
            }
        }

        public void done(IJobChangeEvent event) {
            Job jobToCoordinate = event.getJob();
            if (this.isJobToAvoid(jobToCoordinate) && JsIndexManager.this.getProcessFilesJob().getFiles().length > 0) {
                JsIndexManager.this.getProcessFilesJob().schedule(500L);
            }
        }

        private boolean isJobToAvoid(Job jobToCoordinate) {
            boolean result = false;
            if (jobToCoordinate.belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD) || jobToCoordinate.belongsTo(ResourcesPlugin.FAMILY_MANUAL_BUILD) || jobToCoordinate.belongsTo(ResourcesPlugin.FAMILY_AUTO_REFRESH)) {
                result = true;
            }
            return result;
        }
    }

    private class JSPResourceChangeListener
    implements IResourceChangeListener {
        private JSPResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            block10: {
                if (JsIndexManager.this.isInitializing()) {
                    return;
                }
                if (JsIndexManager.this.getIndexState() == 3) {
                    return;
                }
                if (JsIndexManager.this.getIndexState() == 4) {
                    JsIndexManager.this.getProcessFilesJob().schedule(500L);
                    return;
                }
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    boolean changed;
                    int kind = delta.getKind();
                    boolean added = (kind & 1) == 1;
                    boolean bl = changed = (kind & 4) == 4;
                    if ((added || changed) && delta.getFullPath().toString().equals("/")) {
                        try {
                            JSPResourceVisitor v = JsIndexManager.this.getVisitor();
                            v.reset();
                            delta.accept((IResourceDeltaVisitor)v, false);
                            IFile[] files = v.getFiles();
                            if (files.length > 0) {
                                JsIndexManager.this.setUpdatingState();
                                JsIndexManager.this.indexFiles(files);
                            }
                        }
                        catch (CoreException e) {
                            if (DEBUG) {
                                Logger.logException(e);
                            }
                        }
                        catch (Exception e) {
                            if (!DEBUG) break block10;
                            Logger.logException(e);
                        }
                    }
                }
            }
        }
    }

    private class JSPResourceVisitor
    implements IResourceDeltaVisitor {
        private HashMap jspFiles = new HashMap();

        public boolean visit(IResourceDelta delta) throws CoreException {
            block8: {
                if (JsSearchSupport.getInstance().isCanceled() || JsIndexManager.this.frameworkIsShuttingDown()) {
                    JsIndexManager.this.setCanceledState();
                    return false;
                }
                try {
                    if (!this.isHiddenResource(delta.getFullPath())) {
                        boolean removed;
                        int kind = delta.getKind();
                        boolean added = (kind & 1) == 1;
                        boolean isInterestingChange = false;
                        if ((kind & 4) == 4) {
                            int flags = delta.getFlags();
                            isInterestingChange = (flags & 0x100) == 256 || (flags & 0x40000) == 262144;
                        }
                        boolean bl = removed = (kind & 2) == 2;
                        if (added || isInterestingChange) {
                            this.visitAdded(delta);
                        } else if (removed) {
                            this.visitRemoved(delta);
                        }
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block8;
                    Logger.logException("Delta analysis may not be complete", e);
                }
            }
            return true;
        }

        private void visitRemoved(IResourceDelta delta) {
            IResource r;
            if (delta.getResource() != null && (r = delta.getResource()).getType() == 2 && r.exists()) {
                this.deleteIndex((IFile)r);
            }
        }

        private void visitAdded(IResourceDelta delta) {
            IResource r;
            String filename = delta.getFullPath().lastSegment();
            if (filename != null && Util.isJsType(filename) && (r = delta.getResource()) != null && r.exists() && r.getType() == 1) {
                this.jspFiles.put(r.getFullPath(), r);
            }
        }

        private boolean isHiddenResource(IPath p) {
            String[] segments = p.segments();
            int i = 0;
            while (i < segments.length) {
                if (segments[i].startsWith(".")) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private void deleteIndex(IFile folder) {
            IndexManager im = JavaModelManager.getJavaModelManager().getIndexManager();
            IPath folderPath = folder.getFullPath();
            IPath indexLocation = JsSearchSupport.getInstance().computeIndexLocation(folderPath);
            im.removeIndex(indexLocation);
            File f = indexLocation.toFile();
            f.delete();
        }

        public IFile[] getFiles() {
            return this.jspFiles.values().toArray(new IFile[this.jspFiles.size()]);
        }

        public void reset() {
            this.jspFiles.clear();
        }
    }

    private class ProcessFilesJob
    extends Job {
        List fileList = new ArrayList();
        int lastFileCursor = 0;

        ProcessFilesJob(String taskName) {
            super(taskName);
        }

        synchronized void process(IFile[] files) {
            int i = 0;
            while (i < files.length) {
                this.fileList.add(files[i]);
                ++i;
            }
            if (DEBUG) {
                System.out.println("JSPIndexManager queuing " + files.length + " files");
            }
        }

        synchronized IFile[] getFiles() {
            return this.fileList.toArray(new IFile[this.fileList.size()]);
        }

        synchronized void clearFiles() {
            this.fileList.clear();
            this.lastFileCursor = 0;
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 381->384)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean isCanceled(IProgressMonitor runMonitor) {
            boolean canceled = false;
            if (runMonitor != null && runMonitor.isCanceled()) {
                canceled = true;
            } else if (JsSearchSupport.getInstance().isCanceled()) {
                canceled = true;
                if (runMonitor != null) {
                    runMonitor.setCanceled(true);
                }
            }
            return canceled;
        }
    }
}

