/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.image;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.css.ui.internal.image.CSSImageType;

public class CSSImageHelper {
    private static CSSImageHelper fInstance = null;
    private HashMap fImageDescRegistry = null;
    private Map fTypeMap = null;

    public static synchronized CSSImageHelper getInstance() {
        if (fInstance == null) {
            fInstance = new CSSImageHelper();
        }
        return fInstance;
    }

    private CSSImageHelper() {
    }

    private Image createImage(String resource) {
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.css.ui", (String)resource);
        Image image = null;
        if (desc == null) {
            desc = ImageDescriptor.getMissingImageDescriptor();
            image = desc.createImage();
        } else {
            image = desc.createImage();
            this.getImageRegistry().put(resource, image);
        }
        return image;
    }

    private ImageDescriptor createImageDescriptor(String imageFilePath) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.css.ui", (String)imageFilePath);
        if (imageDescriptor != null) {
            this.getImageDescriptorRegistry().put(imageFilePath, imageDescriptor);
        } else {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }

    public Image getImage(CSSImageType type) {
        if (this.fTypeMap == null) {
            this.fTypeMap = new HashMap();
            this.fTypeMap.put(CSSImageType.STYLESHEET, "icons/full/obj16/stylesheet.gif");
            this.fTypeMap.put(CSSImageType.RULE_CHARSET, "icons/full/obj16/charset_rule.gif");
            this.fTypeMap.put(CSSImageType.RULE_FONTFACE, "icons/full/obj16/fontface_rule.gif");
            this.fTypeMap.put(CSSImageType.RULE_IMPORT, "icons/full/obj16/link_rule.gif");
            this.fTypeMap.put(CSSImageType.RULE_MEDIA, "icons/full/obj16/media_rule.gif");
            this.fTypeMap.put(CSSImageType.RULE_PAGE, "icons/full/obj16/page_rule.gif");
            this.fTypeMap.put(CSSImageType.RULE_STYLE, "icons/full/obj16/style_rule.gif");
            this.fTypeMap.put(CSSImageType.RULE_UNKNOWN, "icons/full/obj16/unknown_rule.gif");
            this.fTypeMap.put(CSSImageType.SELECTOR_CLASS, "icons/full/obj16/class_selector.gif");
            this.fTypeMap.put(CSSImageType.SELECTOR_ID, "icons/full/obj16/id_selector.gif");
            this.fTypeMap.put(CSSImageType.SELECTOR_PSEUDO, "icons/full/obj16/pseudo.gif");
            this.fTypeMap.put(CSSImageType.SELECTOR_TAG, "icons/full/obj16/tag_selector.gif");
            this.fTypeMap.put(CSSImageType.SELECTOR_LINK, "icons/full/obj16/link_selector.gif");
            this.fTypeMap.put(CSSImageType.SELECTOR_DEFAULT, "icons/full/obj16/tag_selector.gif");
            this.fTypeMap.put(CSSImageType.VALUE_FUNCTION, "icons/full/obj16/css_propertyvalue_function.gif");
            this.fTypeMap.put(CSSImageType.VALUE_NUMBER, "icons/full/obj16/css_propertyvalue_unit.gif");
            this.fTypeMap.put(CSSImageType.VALUE_STRING, "icons/full/obj16/css_propertyvalue_identifier.gif");
            this.fTypeMap.put(CSSImageType.CATEGORY_AURAL, "icons/full/obj16/aural_props.gif");
            this.fTypeMap.put(CSSImageType.CATEGORY_BOX, "icons/full/obj16/boxmodel_props.gif");
            this.fTypeMap.put(CSSImageType.CATEGORY_COLORANDBACKGROUND, "icons/full/obj16/colback_props.gif");
            this.fTypeMap.put(CSSImageType.CATEGORY_CONTENT, "icons/full/obj16/content_props.gif");
            this.fTypeMap.put(CSSImageType.CATEGORY_FONT, "icons/full/obj16/font_props.gif");
            this.fTypeMap.put(CSSImageType.CATEGORY_PAGE, "icons/full/obj16/pagedmedia_props.gif");
            this.fTypeMap.put(CSSImageType.CATEGORY_TABLES, "icons/full/obj16/table_props.gif");
            this.fTypeMap.put(CSSImageType.CATEGORY_TEXT, "icons/full/obj16/text_props.gif");
            this.fTypeMap.put(CSSImageType.CATEGORY_UI, "icons/full/obj16/ui_props.gif");
            this.fTypeMap.put(CSSImageType.CATEGORY_VISUAL, "icons/full/obj16/visual_props.gif");
            this.fTypeMap.put(CSSImageType.CATEGORY_DEFAULT, "icons/full/obj16/other_props.gif");
        }
        return this.getImage((String)this.fTypeMap.get(type));
    }

    public Image getImage(String resource) {
        if (resource == null) {
            return null;
        }
        Image image = this.getImageRegistry().get(resource);
        if (image == null) {
            image = this.createImage(resource);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String resource) {
        ImageDescriptor imageDescriptor = null;
        Object o = this.getImageDescriptorRegistry().get(resource);
        imageDescriptor = o == null ? this.createImageDescriptor(resource) : (ImageDescriptor)o;
        return imageDescriptor;
    }

    private HashMap getImageDescriptorRegistry() {
        if (this.fImageDescRegistry == null) {
            this.fImageDescRegistry = new HashMap();
        }
        return this.fImageDescRegistry;
    }

    private ImageRegistry getImageRegistry() {
        return JFaceResources.getImageRegistry();
    }
}

