/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jdt.core.IClasspathEntry;

public class ClasspathUtilities {
    public static IClasspathEntry[] addClasspathEntries(IClasspathEntry[] entries1, IClasspathEntry[] entries2) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>(entries1.length + entries2.length);
        list.addAll((Collection)Arrays.asList(entries1));
        int i = 0;
        while (i < entries2.length) {
            IClasspathEntry iClasspathEntry = entries2[i];
            if (!list.contains(iClasspathEntry)) {
                list.add(iClasspathEntry);
            }
            ++i;
        }
        IClasspathEntry[] ret = new IClasspathEntry[list.size()];
        return list.toArray(ret);
    }

    protected static boolean entryExists(IClasspathEntry entry, IClasspathEntry[] col) {
        int i = 0;
        while (i < col.length) {
            IClasspathEntry otherEntry = col[i];
            if (entry.getContentKind() == otherEntry.getContentKind() && entry.getEntryKind() == otherEntry.getEntryKind() && entry.isExported() == otherEntry.isExported() && entry.getPath().equals((Object)otherEntry.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IClasspathEntry[] removeClasspathEntries(IClasspathEntry[] removeFromCol, IClasspathEntry[] removeCol) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>(removeFromCol.length);
        int i = 0;
        while (i < removeFromCol.length) {
            IClasspathEntry iClasspathEntry = removeFromCol[i];
            if (!ClasspathUtilities.entryExists(iClasspathEntry, removeCol)) {
                list.add(iClasspathEntry);
            }
            ++i;
        }
        IClasspathEntry[] ret = new IClasspathEntry[list.size()];
        return list.toArray(ret);
    }
}

