/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.project;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.plugin.JavaProjectInfo;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.wst.server.core.IRuntime;

public class J2EEJavaProjectInfo
extends JavaProjectInfo {
    protected static final String SRCROOT_VAR = "JRE_SRCROOT";
    protected IProject project;
    protected String jdkRTJarPath;
    protected String projectName;
    protected IPath projectLocation;
    protected String javaOutputPath;
    protected IClasspathEntry[] classpathEntries;
    protected boolean shouldInitializeDefaultClasspath = true;
    protected String natureId;
    protected IRuntime serverTarget;
    protected int moduleVersion;

    public J2EEJavaProjectInfo() {
    }

    public J2EEJavaProjectInfo(IProject project) {
        this.setProject(project);
    }

    public IClasspathEntry[] calculateServerClasspathEntries() throws JavaModelException {
        IClasspathEntry[] ces;
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        if (this.getProject().exists() && (ces = javaProject.getRawClasspath()).length > 0) {
            this.addToClasspathEntries(ces);
        }
        this.addServerJdkRuntimeToClasspathEntries();
        this.addServerJarsToClasspathEntries();
        return this.classpathEntries;
    }

    protected void addDefaultToClasspathEntries() {
        this.addToClasspathEntries(this.computeDefaultJavaClasspath());
    }

    public void setJ2EEVersion(int newVersion) {
    }

    public void addJavaSourceToClasspathEntries() {
        Path sourceClassPath = new Path(this.getFullSourcePath());
        this.addToClasspathEntries(new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)sourceClassPath)});
    }

    public boolean addJdkJarToClasspathEntries(String jdkJarFullPathName) {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        IClasspathEntry[] entry = new IClasspathEntry[1];
        Path path = new Path(jdkJarFullPathName);
        if (!path.toFile().exists()) {
            Logger.getLogger().logError(J2EECreationResourceHandler.getString(J2EECreationResourceHandler.JdkJarFileDoesNotExist_UI, new Object[]{jdkJarFullPathName}));
            return false;
        }
        entry[0] = JavaCore.newLibraryEntry((IPath)path, null, null);
        this.addToClasspathEntries(entry);
        return true;
    }

    public void addServerJdkRuntimeToClasspathEntries() {
        this.addToClasspathEntries(this.getServerJDKClasspathEntries());
    }

    public IClasspathEntry[] getServerJDKClasspathEntries() {
        ArrayList list = new ArrayList(4);
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    public void addToClasspathEntries(IClasspathEntry[] entries) {
        ArrayList list = new ArrayList(10);
        if (this.classpathEntries != null) {
            list.addAll(Arrays.asList(this.classpathEntries));
        }
        list.addAll(Arrays.asList(entries));
        this.classpathEntries = new IClasspathEntry[list.size()];
        this.classpathEntries = list.toArray(this.classpathEntries);
    }

    public boolean addVariableJarToClasspathEntries(String fullPath) {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        IClasspathEntry[] entry = new IClasspathEntry[]{JavaCore.newVariableEntry((IPath)new Path(fullPath), null, null)};
        this.addToClasspathEntries(entry);
        return true;
    }

    public boolean addVariableJarToClasspathEntriesWithAttachments(String fullPath, String srcPath, String srcRoot) {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        IClasspathEntry[] entry = new IClasspathEntry[]{JavaCore.newVariableEntry((IPath)new Path(fullPath), (IPath)new Path(srcPath), (IPath)new Path(srcRoot))};
        this.addToClasspathEntries(entry);
        return true;
    }

    protected IClasspathEntry[] computeDefaultJavaClasspath() {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        this.addJavaSourceToClasspathEntries();
        if (this.serverTarget == null) {
            this.addServerJdkRuntimeToClasspathEntries();
            this.addServerJarsToClasspathEntries();
        }
        return this.classpathEntries;
    }

    public void addServerJarsToClasspathEntries() {
    }

    public IProject createProjectHandle(IPath projectPath) {
        return this.getWorkspace().getRoot().getProject(projectPath.segment(0));
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.classpathEntries == null) {
            this.initializeClasspathEntries();
        }
        return this.classpathEntries;
    }

    public String getDefaultContextRoot() {
        return null;
    }

    protected String getDefaultJavaOutputPath() {
        return "bin";
    }

    public String getDefaultUri() {
        return String.valueOf(this.projectName.replace(' ', '_')) + ".jar";
    }

    public String getFullJavaOutputPath() {
        return Path.ROOT.append(this.getProjectPath()).append(this.getJavaOutputPath()).toString();
    }

    protected String getFullSourcePath() {
        return Path.ROOT.append(this.getProjectPath()).append(this.getSourcePath()).toString();
    }

    public String getJavaOutputPath() {
        if (this.javaOutputPath == null) {
            this.javaOutputPath = this.getDefaultJavaOutputPath();
        }
        return this.javaOutputPath;
    }

    public void setModuleVersion(int version) {
        this.moduleVersion = version;
    }

    public IJavaProject getJavaProject() {
        IProject aProject = this.getProject();
        if (aProject == null) {
            aProject = this.getWorkspace().getRoot().getProject(this.getProjectName());
        }
        return JavaCore.create((IProject)aProject);
    }

    public String getJdkRTJarPath() {
        return this.jdkRTJarPath;
    }

    public IProject getProject() {
        IProject aProject;
        if (this.project == null && (aProject = this.getWorkspace().getRoot().getProject(this.getProjectName())).exists()) {
            this.project = aProject;
        }
        return this.project;
    }

    public IPath getProjectLocation() {
        return this.projectLocation;
    }

    public String getProjectName() {
        if (this.projectName == null && this.project != null) {
            this.projectName = this.project.getName();
        }
        return this.projectName;
    }

    public IPath getProjectPath() {
        return new Path(this.getProjectName());
    }

    public IWorkspace getWorkspace() {
        return J2EEPlugin.getWorkspace();
    }

    protected void initializeClasspathEntries() {
        if (this.shouldInitializeDefaultClasspath()) {
            this.computeDefaultJavaClasspath();
        } else {
            this.classpathEntries = new IClasspathEntry[0];
        }
    }

    protected boolean isJ2EE13() {
        return false;
    }

    public IProject primGetProject() {
        return this.project;
    }

    public void removeClasspathEntry(IClasspathEntry entry) {
        if (entry == null) {
            return;
        }
        ArrayList list = new ArrayList(Arrays.asList(this.getClasspathEntries()));
        list.remove(entry);
        this.classpathEntries = list.toArray(new IClasspathEntry[list.size()]);
    }

    public void setClasspathEntries(IClasspathEntry[] newClasspathEntries) {
        this.classpathEntries = newClasspathEntries;
    }

    public void setJavaOutputPath(String path) {
        this.javaOutputPath = path;
    }

    public void setJdkRTJarPath(String path) {
        this.jdkRTJarPath = path;
    }

    public void setProject(IProject aProject) {
        this.project = aProject;
    }

    public void setProjectLocation(IPath newProjectLocation) {
        this.projectLocation = newProjectLocation;
    }

    public void setProjectName(String newProjectName) {
        if (this.projectName != newProjectName) {
            this.setClasspathEntries(null);
        }
        this.projectName = newProjectName;
    }

    public void setShouldInitializeDefaultClasspath(boolean value) {
        this.shouldInitializeDefaultClasspath = value;
    }

    public boolean shouldInitializeDefaultClasspath() {
        return this.shouldInitializeDefaultClasspath;
    }

    public String getNatureId() {
        if (this.natureId == null) {
            return this.getDefaultNatureId();
        }
        return this.natureId;
    }

    public String getDefaultNatureId() {
        return null;
    }

    public void setNatureId(String natureId) {
        this.natureId = natureId;
    }

    protected String getWASPluginVariable() {
        return "";
    }

    public int getModuleVersion() {
        return this.moduleVersion;
    }

    public IRuntime getServerTarget() {
        return this.serverTarget;
    }

    public void setServerTarget(IRuntime target) {
        this.serverTarget = target;
    }
}

