/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslator;
import org.eclipse.wst.jsdt.web.core.javascript.JsDataTypes;
import org.eclipse.wst.jsdt.web.core.javascript.NodeHelper;
import org.eclipse.wst.jsdt.web.core.javascript.Util;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class JsTranslator
extends Job
implements IJsTranslator,
IDocumentListener {
    protected static final boolean DEBUG;
    private static final boolean DEBUG_SAVE_OUTPUT = false;
    private static final String XML_COMMENT_START = "<!--";
    private static final int XML_COMMENT_START_LENGTH;
    private static final boolean REPLACE_INNER_BLOCK_SECTIONS_WITH_SPACE = false;
    private static final Pattern fClientSideTagPattern;
    private IStructuredDocumentRegion fCurrentNode;
    protected StringBuffer fScriptText = new StringBuffer();
    protected IStructuredDocument fStructuredDocument = null;
    protected ArrayList importLocationsInHtml = new ArrayList();
    protected boolean fIsGlobalJs = true;
    protected ArrayList rawImports = new ArrayList();
    protected ArrayList scriptLocationInHtml = new ArrayList();
    protected int scriptOffset = 0;
    protected byte[] fLock = new byte[0];
    protected byte[] finished = new byte[0];
    protected IBuffer fCompUnitBuff;
    protected boolean cancelParse = false;
    protected int missingEndTagRegionStart = -1;
    protected static final boolean ADD_SEMICOLON_AT_INLINE = true;
    protected List fGeneratedRanges = new ArrayList();

    static {
        XML_COMMENT_START_LENGTH = XML_COMMENT_START.length();
        fClientSideTagPattern = Pattern.compile("<[^<)>%]+/?>");
        String value = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jsjavamapping");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    protected boolean isGlobalJs() {
        return this.fIsGlobalJs;
    }

    protected IBuffer getCompUnitBuffer() {
        return this.fCompUnitBuff;
    }

    protected StringBuffer getScriptTextBuffer() {
        return this.fScriptText;
    }

    protected void setIsGlobalJs(boolean value) {
        this.fIsGlobalJs = value;
    }

    protected void advanceNextNode() {
        this.setCurrentNode(this.getCurrentNode().getNext());
    }

    public JsTranslator(IStructuredDocument document, String fileName) {
        super("JavaScript translation for : " + fileName);
        this.fStructuredDocument = document;
        this.fStructuredDocument.addDocumentListener((IDocumentListener)this);
        this.setPriority(30);
        this.setSystem(true);
        this.schedule();
        this.reset();
    }

    public JsTranslator() {
        super("JavaScript Translation");
    }

    public JsTranslator(IStructuredDocument document, String fileName, boolean listenForChanges) {
        super("JavaScript translation for : " + fileName);
        this.fStructuredDocument = document;
        if (listenForChanges) {
            this.fStructuredDocument.addDocumentListener((IDocumentListener)this);
            this.setPriority(30);
            this.setSystem(true);
            this.schedule();
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsText() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fScriptText.toString();
        }
    }

    protected final IStructuredDocumentRegion getCurrentNode() {
        return this.fCurrentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(IBuffer buffer) {
        this.fCompUnitBuff = buffer;
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            this.fCompUnitBuff.setContents(this.fScriptText.toString());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position[] getHtmlLocations() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.scriptLocationInHtml.toArray(new Position[this.scriptLocationInHtml.size()]);
        }
    }

    public int getMissingEndTagRegionStart() {
        return this.missingEndTagRegionStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position[] getImportHtmlRanges() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.importLocationsInHtml.toArray(new Position[this.importLocationsInHtml.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRawImports() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.rawImports.toArray(new String[this.rawImports.size()]);
        }
    }

    protected boolean isCanceled() {
        return this.cancelParse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            this.scriptOffset = 0;
            this.fScriptText = new StringBuffer();
            this.fCurrentNode = this.fStructuredDocument.getFirstStructuredDocumentRegion();
            this.rawImports.clear();
            this.importLocationsInHtml.clear();
            this.scriptLocationInHtml.clear();
            this.missingEndTagRegionStart = -1;
            this.cancelParse = false;
            this.fGeneratedRanges.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.translate();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStructuredDocumentRegion setCurrentNode(IStructuredDocumentRegion currentNode) {
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            this.fCurrentNode = currentNode;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.fCurrentNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            if (this.getCurrentNode() != null) {
                NodeHelper nh = new NodeHelper(this.getCurrentNode());
                while (this.getCurrentNode() != null && !this.isCanceled()) {
                    nh.setDocumentRegion(this.getCurrentNode());
                    if (this.getCurrentNode().getType() == "XML_TAG_NAME") {
                        if ((!nh.isEndTag() || nh.isSelfClosingTag()) && nh.nameEquals("script")) {
                            if (NodeHelper.isInArray(JsDataTypes.JSVALIDDATATYPES, nh.getAttributeValue("type")) || NodeHelper.isInArray(JsDataTypes.JSVALIDDATATYPES, nh.getAttributeValue("language")) || this.isGlobalJs()) {
                                if (nh.containsAttribute(new String[]{"src"})) {
                                    this.translateScriptImportNode(this.getCurrentNode());
                                }
                                if (this.getCurrentNode().getNext() != null) {
                                    this.translateJSNode(this.getCurrentNode().getNext());
                                }
                            }
                        } else if (nh.containsAttribute(JsDataTypes.HTMLATREVENTS)) {
                            this.translateInlineJSNode(this.getCurrentNode());
                        } else if (nh.nameEquals("META") && nh.attrEquals("http-equiv", "Content-Script-Type") && nh.containsAttribute(new String[]{"content"})) {
                            this.setIsGlobalJs(NodeHelper.isInArray(JsDataTypes.JSVALIDDATATYPES, nh.getAttributeValue("content")));
                        }
                    }
                    if (this.getCurrentNode() == null) continue;
                    this.advanceNextNode();
                }
                if (this.getCompUnitBuffer() != null) {
                    this.getCompUnitBuffer().setContents(this.fScriptText.toString());
                }
            }
            this.finishedTranslation();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void finishedTranslation() {
    }

    public void translateInlineJSNode(IStructuredDocumentRegion container) {
        ITextRegionList t = container.getRegions();
        Iterator regionIterator = t.iterator();
        while (regionIterator.hasNext() && !this.isCanceled()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
            int start = r.getStart();
            int offset = r.getTextEnd();
            String tagAttrname = container.getText().substring(start, offset).trim();
            if (!NodeHelper.isInArray(JsDataTypes.HTMLATREVENTS, tagAttrname)) continue;
            if (regionIterator.hasNext()) {
                regionIterator.next();
            }
            if (regionIterator.hasNext()) {
                r = (ITextRegion)regionIterator.next();
            }
            if (r.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
            int valStartOffset = container.getStartOffset(r);
            String rawText = container.getText().substring(r.getStart(), r.getTextEnd());
            if (rawText == null || rawText.length() == 0) {
                return;
            }
            switch (rawText.charAt(0)) {
                case '\"': 
                case '\'': {
                    rawText = rawText.substring(1);
                    ++valStartOffset;
                }
            }
            if (rawText == null || rawText.length() == 0) {
                return;
            }
            switch (rawText.charAt(rawText.length() - 1)) {
                case '\"': 
                case '\'': {
                    rawText = rawText.substring(0, rawText.length() - 1);
                }
            }
            rawText = String.valueOf(rawText) + ";";
            Position inHtml = new Position(valStartOffset, rawText.length());
            this.scriptLocationInHtml.add(inHtml);
            char[] spaces = Util.getPad(valStartOffset - this.scriptOffset);
            this.fScriptText.append(spaces);
            this.fScriptText.append(rawText);
            this.scriptOffset = this.fScriptText.length();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void translateJSNode(IStructuredDocumentRegion container) {
        containerRegion = container;
        regions = containerRegion.getRegions().iterator();
        region = null;
        if (container == null) {
            return;
        }
        spaces = Util.getPad(container.getStartOffset() - this.scriptOffset);
        this.fScriptText.append(spaces);
        this.scriptOffset = container.getStartOffset();
        if (container.getType() == "BLOCK_TEXT" || container.getType() == "XML_CDATA_TEXT") ** GOTO lbl147
        return;
lbl-1000:
        // 1 sources

        {
            region = (ITextRegion)regions.next();
            type = region.getType();
            isContainerRegion = region instanceof ITextRegionContainer;
            if (type != "BLOCK_TEXT") continue;
            scriptStartOffset = container.getStartOffset();
            scriptTextLength = container.getLength();
            regionText = container.getFullText(region);
            regionLength = region.getLength();
            spaces = Util.getPad(scriptStartOffset - this.scriptOffset);
            this.fScriptText.append(spaces);
            if (isContainerRegion) {
                // empty if block
            }
            if (regionText.indexOf("<!--") >= 0) {
                commentStartIndex = regionText.indexOf("<!--");
                replaceCommentStart = true;
                i = 0;
                while (i < commentStartIndex) {
                    replaceCommentStart = replaceCommentStart != false && Character.isWhitespace(regionText.charAt(i)) != false;
                    ++i;
                }
                if (replaceCommentStart) {
                    try {
                        line = container.getParentDocument().getLineInformationOfOffset(commentStartIndex + scriptStartOffset);
                        endOfLeadingCommentLine = line.getOffset() + line.getLength() - scriptStartOffset;
                        if (endOfLeadingCommentLine > regionLength) {
                            endOfLeadingCommentLine = regionLength - 1;
                        }
                        length = endOfLeadingCommentLine - commentStartIndex;
                    }
                    catch (BadLocationException e) {
                        Logger.logException("Could not get HTML-style comment line information", e);
                        endOfLeadingCommentLine = commentStartIndex + JsTranslator.XML_COMMENT_START_LENGTH;
                        length = JsTranslator.XML_COMMENT_START_LENGTH;
                    }
                    newRegionText = new StringBuffer(regionText.substring(0, commentStartIndex));
                    spaces = Util.getPad(length);
                    newRegionText.append(spaces);
                    newRegionText.append(regionText.substring(endOfLeadingCommentLine));
                    regionText = newRegionText.toString();
                }
            } else {
                validEnd = 0;
                validStart = 0;
                matcher = JsTranslator.fClientSideTagPattern.matcher(regionText);
                contents = new StringBuffer();
                serverSideStart = regionText.indexOf("<%");
                clientMatchStart = matcher.find() != false ? matcher.start() : -1;
                while (serverSideStart > -1 || clientMatchStart > -1) {
                    validEnd = validStart;
                    biasClient = false;
                    biasServer = false;
                    if (clientMatchStart > -1 && serverSideStart > -1) {
                        validEnd = Math.min(clientMatchStart, serverSideStart);
                        biasClient = validEnd == clientMatchStart;
                        biasServer = validEnd == serverSideStart;
                    } else if (clientMatchStart > -1 && serverSideStart < 0) {
                        validEnd = clientMatchStart;
                        biasClient = true;
                    } else if (clientMatchStart < 0 && serverSideStart > -1) {
                        validEnd = serverSideStart;
                        biasServer = true;
                    }
                    if (-1 < validStart && -1 < validEnd) {
                        contents.append(regionText.substring(validStart, validEnd));
                        startOffset = container.getStartOffset(region) + validEnd;
                        v0 = serverSideEnd = regionLength > validEnd + 2 ? regionText.indexOf("%>", validEnd + 2) : -1;
                        if (serverSideEnd > -1) {
                            serverSideEnd += 2;
                        }
                        clientMatchEnd = matcher.find(validEnd) != false ? matcher.end() : -1;
                        validStart = -1;
                        if (clientMatchEnd > validEnd && serverSideEnd > validEnd) {
                            validStart = biasClient != false ? clientMatchEnd : (biasServer != false ? serverSideEnd : Math.min(clientMatchEnd, serverSideEnd));
                        }
                        if (clientMatchEnd >= validEnd && serverSideEnd < 0) {
                            validStart = matcher.end();
                        }
                        if (clientMatchEnd < 0 && serverSideEnd >= validEnd) {
                            validStart = serverSideEnd;
                        }
                        line = container.getParentDocument().getLineOfOffset(startOffset);
                        try {
                            startOffset - container.getParentDocument().getLineOffset(line);
                        }
                        catch (BadLocationException v1) {}
                        start = validEnd + container.getStartOffset(region);
                        contents.append('_');
                        i = validEnd + 1;
                        while (i < validStart) {
                            switch (i - validEnd) {
                                case 1: {
                                    contents.append('$');
                                    break;
                                }
                                case 2: {
                                    contents.append('t');
                                    break;
                                }
                                case 3: {
                                    contents.append('a');
                                    break;
                                }
                                case 4: {
                                    contents.append('g');
                                    break;
                                }
                                default: {
                                    contents.append('_');
                                }
                            }
                            ++i;
                        }
                        end = validStart + container.getStartOffset(region);
                        this.fGeneratedRanges.add(new Region(start, end - start));
                    }
                    if (validStart > 0) {
                        v2 = serverSideStart = validStart < regionLength - 2 ? regionText.indexOf("<%", validStart) : -1;
                        clientMatchStart = validStart < regionLength ? (matcher.find(validStart + 1) ? matcher.start() : -1) : -1;
                        continue;
                    }
                    clientMatchStart = -1;
                    serverSideStart = -1;
                }
                if (validStart >= 0) {
                    contents.append(regionText.substring(validStart));
                }
                if (contents.length() != 0) {
                    this.fScriptText.append(contents.toString());
                } else {
                    this.fScriptText.append(regionText);
                }
                inHtml = new Position(scriptStartOffset, scriptTextLength);
                this.scriptLocationInHtml.add(inHtml);
            }
            this.scriptOffset = this.fScriptText.length();
lbl147:
            // 3 sources

            ** while (regions.hasNext() && !this.isCanceled())
        }
lbl148:
        // 1 sources

        endTag = container.getNext();
        if (endTag == null) {
            this.missingEndTagRegionStart = container.getStartOffset();
        } else if (!(endTag == null || (name = (nh = new NodeHelper(endTag)).getTagName()) != null && name.trim().equalsIgnoreCase("script") && nh.isEndTag())) {
            this.missingEndTagRegionStart = container.getStartOffset();
        }
    }

    public void translateScriptImportNode(IStructuredDocumentRegion region) {
        NodeHelper nh = new NodeHelper(region);
        String importName = nh.getAttributeValue("src");
        if (importName != null && !importName.equals("")) {
            this.rawImports.add(importName);
            Position inHtml = new Position(region.getStartOffset(), region.getEndOffset());
            this.importLocationsInHtml.add(inHtml);
        }
    }

    protected void cleanupXmlQuotes() {
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.cancelParse = true;
    }

    public void documentChanged(DocumentEvent event) {
        this.reset();
    }

    protected IStatus run(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public void release() {
        this.fStructuredDocument.removeDocumentListener((IDocumentListener)this);
    }

    public Region[] getGeneratedRanges() {
        return this.fGeneratedRanges.toArray(new Region[this.fGeneratedRanges.size()]);
    }
}

