/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.types;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.Messages;
import org.eclipse.jst.jsf.common.internal.types.TypeComparatorPreferences;
import org.eclipse.osgi.util.NLS;

public final class TypeComparatorDiagnosticFactory {
    public static final String SOURCE_IDENTIFIER = "org.eclipse.jst.jsf.common.types.TypeComparator";
    public static final int METHOD_EXPRESSION_EXPECTED_ID = 0;
    public static final int INCOMPATIBLE_TYPES_ID = 1;
    public static final int VALUE_EXPRESSION_EXPECTED_ID = 2;
    public static final int INCOMPATIBLE_METHOD_TYPES_ID = 3;
    public static final int PROPERTY_NOT_READABLE_ID = 4;
    public static final int PROPERTY_NOT_WRITABLE_ID = 5;
    public static final int NUM_IDS = 6;
    private final TypeComparatorPreferences _prefs;

    public TypeComparatorDiagnosticFactory(TypeComparatorPreferences prefs) {
        this._prefs = prefs;
    }

    public Diagnostic create_METHOD_EXPRESSION_EXPECTED() {
        return this.create(0, Messages.getString("TypeComparator.Expression.No_Method"));
    }

    public Diagnostic create_INCOMPATIBLE_TYPES(Object[] params) {
        return this.create(1, NLS.bind((String)Messages.getString("TypeComparator.Expression.Incompatible_Value"), (Object[])params));
    }

    public Diagnostic create_VALUE_EXPRESSION_EXPECTED() {
        return this.create(2, Messages.getString("TypeComparator.Expression.No_Value"));
    }

    public Diagnostic create_INCOMPATIBLE_METHOD_TYPES(Object[] params) {
        return this.create(3, NLS.bind((String)Messages.getString("TypeComparator.Expression.Incompatible_Method"), (Object[])params));
    }

    public Diagnostic create_PROPERTY_NOT_READABLE() {
        return this.create(4, Messages.getString("TypeComparator.Expression.Not.Gettable"));
    }

    public Diagnostic create_PROPERTY_NOT_WRITABLE() {
        return this.create(5, Messages.getString("TypeComparator.Expression.Expected.Settable"));
    }

    private BasicDiagnostic create(int diagnosticId, String message) {
        int severity = this._prefs.getDefaultSeverity(diagnosticId);
        return new BasicDiagnostic(severity, SOURCE_IDENTIFIER, diagnosticId, message, null);
    }
}

