/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.search;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;

public abstract class SearchParticipant {
    protected SearchParticipant() {
    }

    public void beginSearching() {
    }

    public void doneSearching() {
    }

    public String getDescription() {
        return "Search participant";
    }

    public abstract SearchDocument getDocument(String var1);

    public abstract void indexDocument(SearchDocument var1, IPath var2);

    public abstract void locateMatches(SearchDocument[] var1, SearchPattern var2, IJavaScriptSearchScope var3, SearchRequestor var4, IProgressMonitor var5) throws CoreException;

    public void removeIndex(IPath indexLocation) {
        IndexManager manager = JavaModelManager.getJavaModelManager().getIndexManager();
        manager.removeIndexPath(indexLocation);
    }

    public final void scheduleDocumentIndexing(SearchDocument document, IPath indexLocation) {
        Path documentPath = new Path(document.getPath());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Object file = JavaModel.getTarget((IContainer)root, (IPath)documentPath, true);
        Path containerPath = documentPath;
        if (file instanceof IResource) {
            containerPath = ((IResource)file).getProject().getFullPath();
        } else if (file == null) {
            containerPath = documentPath.removeLastSegments(documentPath.segmentCount() - 1);
        }
        IndexManager manager = JavaModelManager.getJavaModelManager().getIndexManager();
        manager.ensureIndexExists(indexLocation, (IPath)containerPath);
        manager.scheduleDocumentIndexing(document, (IPath)containerPath, indexLocation, this);
    }

    public abstract IPath[] selectIndexes(SearchPattern var1, IJavaScriptSearchScope var2);
}

