/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.AddToFavoritesAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilWsdlServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WSILPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.transformer.WSILViewSelectionTransformer;

public class AddWSDLServiceToFavoritesAction
extends AddToFavoritesAction {
    public AddWSDLServiceToFavoritesAction(Controller controller) {
        super(controller);
    }

    public boolean favoriteExists() {
        String wsdlURL = this.getWsdlUrl();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("wsdlURL", wsdlURL);
        return this.favoriteExists(table, "relWSDLServiceFolderNode");
    }

    public ITransformer[] getTransformers() {
        ITransformer[] parentTransformers = super.getTransformers();
        ITransformer[] transformers = new ITransformer[parentTransformers.length + 1];
        System.arraycopy(parentTransformers, 0, transformers, 0, parentTransformers.length);
        transformers[transformers.length - 1] = new WSILViewSelectionTransformer(this.controller_, "wsdlServices", "viewId", 1);
        return transformers;
    }

    public boolean executeSingleLinkAction() {
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        String wsdlURL = this.getWsdlUrl();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("wsdlURL", wsdlURL);
        if (this.isMultipleLinkAction() && this.favoriteExists(table, "relWSDLServiceFolderNode")) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_FAVORITES_ALREADY_EXISTS", wsdlURL));
            return false;
        }
        if (this.addToFavorites(table, "relWSDLServiceFolderNode")) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_INFO_ADD_TO_FAVORITES_SUCCESSFUL", wsdlURL));
            return true;
        }
        wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_ADD_TO_FAVORITES", wsdlURL));
        return false;
    }

    private String getWsdlUrl() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        int viewID = Integer.parseInt((String)this.propertyTable_.get("viewId"));
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        WsilElement selectedElement = (WsilElement)selectedNode.getTreeElement();
        Object obj = selectedElement.getAllWSDLServices().getElementWithViewId(viewID).getObject();
        WsilWsdlServiceElement wsilWsdlServiceElement = (WsilWsdlServiceElement)((Object)obj);
        return wsilWsdlServiceElement.getWSDLServiceURL();
    }
}

