/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.compiler.libraries;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.osgi.framework.Bundle;

public class SystemLibraryLocation
implements LibraryLocation {
    public static final char[] SYSTEM_LIBARAY_NAME = new char[]{'s', 'y', 's', 't', 'e', 'm', '.', 'j', 's'};
    public static final char[] LIBRARY_RUNTIME_DIRECTORY = new char[]{'l', 'i', 'b', 'r', 'a', 'r', 'i', 'e', 's'};
    public static final char[] LIBRARY_PLUGIN_DIRECTORY = new char[]{'l', 'i', 'b', 'r', 'a', 'r', 'i', 'e', 's'};
    private static final boolean AUTO_UPDATE_LIBS = true;
    private static SystemLibraryLocation fInstance;

    public static LibraryLocation getInstance() {
        if (fInstance == null) {
            fInstance = new SystemLibraryLocation();
        }
        return fInstance;
    }

    public IPath getLibraryPathInPlugin() {
        return new Path("libraries");
    }

    public char[][] getLibraryFileNames() {
        return new char[][]{SYSTEM_LIBARAY_NAME};
    }

    protected String getPluginId() {
        return "org.eclipse.wst.jsdt.core";
    }

    public char[][] getAllFilesInPluginDirectory(String directory) {
        Enumeration entries = Platform.getBundle((String)this.getPluginId()).getEntryPaths(directory);
        ArrayList<char[]> allEntries = new ArrayList<char[]>();
        while (entries.hasMoreElements()) {
            Path value = new Path((String)entries.nextElement());
            char[] filename = value.lastSegment().toCharArray();
            if (!Util.isJavaLikeFileName(filename)) continue;
            allEntries.add(filename);
        }
        char[][] fileNames = new char[allEntries.size()][];
        int i = 0;
        while (i < allEntries.size()) {
            fileNames[i] = (char[])allEntries.get(i);
            ++i;
        }
        return fileNames;
    }

    public SystemLibraryLocation() {
        try {
            IPath libraryRuntimePath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.wst.jsdt.core")).append(new String(LIBRARY_RUNTIME_DIRECTORY));
            if (!libraryRuntimePath.toFile().exists()) {
                libraryRuntimePath.toFile().mkdir();
            }
            char[][] libFiles = this.getLibraryFileNames();
            int i = 0;
            while (i < libFiles.length) {
                IPath workingLibLocation = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.wst.jsdt.core")).append(new String(LIBRARY_RUNTIME_DIRECTORY)).append(new String(libFiles[i]));
                File library = workingLibLocation.toFile();
                if (!library.exists()) {
                    InputStream is = null;
                    is = FileLocator.openStream((Bundle)Platform.getBundle((String)this.getPluginId()), (IPath)this.getLibraryPathInPlugin().append(new String(libFiles[i])), (boolean)false);
                    SystemLibraryLocation.copyFile(is, library);
                } else {
                    long lastModold = library.lastModified();
                    URL path = FileLocator.toFileURL((URL)Platform.getBundle((String)this.getPluginId()).getEntry(this.getLibraryPathInPlugin().append(new String(libFiles[i])).toString()));
                    File inPlugin = new File(path.getFile());
                    long lastModNew = inPlugin.lastModified();
                    if (lastModNew > lastModold) {
                        library.delete();
                        InputStream is = null;
                        is = FileLocator.openStream((Bundle)Platform.getBundle((String)this.getPluginId()), (IPath)this.getLibraryPathInPlugin().append(new String(libFiles[i])), (boolean)false);
                        SystemLibraryLocation.copyFile(is, library);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public IPath getWorkingLibPath() {
        return new Path(this.getLibraryPath(""));
    }

    public String getLibraryPath(String name) {
        try {
            return Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.wst.jsdt.core")).append(new String(LIBRARY_RUNTIME_DIRECTORY)).append(name).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLibraryPath(char[] name) {
        return this.getLibraryPath(new String(name));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void copyFile(InputStream src, File dst) throws IOException {
        OutputStream out;
        block12: {
            BufferedInputStream in = null;
            out = null;
            try {
                int len;
                in = new BufferedInputStream(src);
                out = new BufferedOutputStream(new FileOutputStream(dst));
                byte[] buffer = new byte[4096];
                while ((len = ((InputStream)in).read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (in == null) break block12;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)in).close();
        }
        if (out == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        out.close();
    }
}

