/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.projection;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.wst.html.ui.internal.projection.ProjectionModelNodeAdapterFactoryHTML;
import org.eclipse.wst.html.ui.internal.projection.ProjectionModelNodeAdapterHTML;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class StructuredTextFoldingProviderHTML
implements IStructuredTextFoldingProvider,
IProjectionListener,
ITextInputListener {
    private static final boolean debugProjectionPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.html.ui/projectionperf"));
    private IDocument fDocument;
    private ProjectionViewer fViewer;
    private boolean fProjectionNeedsToBeEnabled = false;
    private final int MAX_CHILDREN = 10;
    private final int MAX_SIBLINGS = 1000;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private void addAdapterToNodeAndChildren(Node node, int childLevel) {
        if (node instanceof INodeNotifier && childLevel < 10) {
            ProjectionModelNodeAdapterHTML adapter;
            INodeNotifier notifier = (INodeNotifier)node;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.html.ui.internal.projection.ProjectionModelNodeAdapterHTML");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ProjectionModelNodeAdapterHTML)notifier.getExistingAdapter((Object)clazz)) != null) {
                adapter.updateAdapter(node, this.fViewer);
            } else {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.wst.html.ui.internal.projection.ProjectionModelNodeAdapterHTML");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                notifier.getAdapterFor((Object)clazz2);
            }
            int siblingLevel = 0;
            Node nextChild = node.getFirstChild();
            while (nextChild != null && siblingLevel < 1000) {
                Node childNode = nextChild;
                nextChild = childNode.getNextSibling();
                this.addAdapterToNodeAndChildren(childNode, childLevel + 1);
                ++siblingLevel;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAllAdapters() {
        long start;
        block8: {
            start = System.currentTimeMillis();
            if (this.fDocument != null) {
                IStructuredModel sModel = null;
                try {
                    int startOffset;
                    IndexedRegion startNode;
                    sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                    if (sModel != null && (startNode = sModel.getIndexedRegion(startOffset = 0)) instanceof Node) {
                        int siblingLevel = 0;
                        Node nextSibling = (Node)startNode;
                        while (nextSibling != null && siblingLevel < 1000) {
                            Node currentNode = nextSibling;
                            nextSibling = currentNode.getNextSibling();
                            this.addAdapterToNodeAndChildren(currentNode, 0);
                            ++siblingLevel;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (sModel != null) {
                        sModel.releaseFromRead();
                    }
                    throw throwable;
                }
                {
                    Object var9_11 = null;
                    if (sModel == null) break block8;
                }
                sModel.releaseFromRead();
            }
        }
        if (debugProjectionPerf) {
            long end = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderHTML.addAllAdapters: " + (end - start));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProjectionModelNodeAdapterFactoryHTML getAdapterFactory(boolean createIfNeeded) {
        ProjectionModelNodeAdapterFactoryHTML factory;
        long start;
        block17: {
            start = System.currentTimeMillis();
            factory = null;
            if (this.fDocument == null) break block17;
            IStructuredModel sModel = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (sModel != null) {
                    Class<?> clazz;
                    FactoryRegistry factoryRegistry = sModel.getFactoryRegistry();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.wst.html.ui.internal.projection.ProjectionModelNodeAdapterHTML");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz2 = class$0 = clazz3;
                    }
                    if (!factoryRegistry.contains((Object)clazz2) && createIfNeeded) {
                        PropagatingAdapter propagatingAdapter;
                        ProjectionModelNodeAdapterFactoryHTML newFactory = new ProjectionModelNodeAdapterFactoryHTML();
                        factoryRegistry.addFactory((INodeAdapterFactory)newFactory);
                        IDOMModel domModel = (IDOMModel)sModel;
                        IDOMDocument document = domModel.getDocument();
                        INodeNotifier iNodeNotifier = (INodeNotifier)document;
                        Class<?> clazz4 = class$1;
                        if (clazz4 == null) {
                            Class<?> clazz5;
                            try {
                                clazz5 = Class.forName("org.eclipse.wst.sse.core.internal.PropagatingAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz4 = class$1 = clazz5;
                        }
                        if ((propagatingAdapter = (PropagatingAdapter)iNodeNotifier.getAdapterFor((Object)clazz4)) != null) {
                            propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)newFactory);
                        }
                    }
                    if ((clazz = class$0) == null) {
                        Class<?> clazz6;
                        try {
                            clazz6 = Class.forName("org.eclipse.wst.html.ui.internal.projection.ProjectionModelNodeAdapterHTML");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz6;
                    }
                    factory = (ProjectionModelNodeAdapterFactoryHTML)factoryRegistry.getFactoryFor((Object)clazz);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
                throw throwable;
            }
            {
                Object var11_13 = null;
                if (sModel == null) break block17;
            }
            sModel.releaseFromRead();
        }
        if (debugProjectionPerf) {
            long end = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderHTML.getAdapterFactory: " + (end - start));
        }
        return factory;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        long start = System.currentTimeMillis();
        this.projectionDisabled();
        this.fDocument = this.fViewer.getDocument();
        if (this.fViewer.getProjectionAnnotationModel() != null) {
            ProjectionModelNodeAdapterFactoryHTML factory = this.getAdapterFactory(true);
            if (factory != null) {
                factory.addProjectionViewer(this.fViewer);
            }
            try {
                this.fViewer.setRedraw(false);
                this.addAllAdapters();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.fViewer.setRedraw(true);
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            this.fViewer.setRedraw(true);
        }
        this.fProjectionNeedsToBeEnabled = false;
        if (debugProjectionPerf) {
            long end = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderHTML.initialize: " + (end - start));
        }
    }

    public void install(ProjectionViewer viewer) {
        if (this.isInstalled()) {
            this.uninstall();
        }
        this.fViewer = viewer;
        this.fViewer.addProjectionListener((IProjectionListener)this);
        this.fViewer.addTextInputListener((ITextInputListener)this);
    }

    private boolean isInstalled() {
        return this.fViewer != null;
    }

    public void projectionDisabled() {
        ProjectionModelNodeAdapterFactoryHTML factory = this.getAdapterFactory(false);
        if (factory != null) {
            factory.removeProjectionViewer(this.fViewer);
        }
        if (this.fViewer.getProjectionAnnotationModel() != null) {
            this.fViewer.getProjectionAnnotationModel().removeAllAnnotations();
        }
        this.removeAllAdapters();
        this.fDocument = null;
        this.fProjectionNeedsToBeEnabled = false;
    }

    public void projectionEnabled() {
        this.initialize();
    }

    private void removeAdapterFromNodeAndChildren(Node node, int level) {
        if (node instanceof INodeNotifier) {
            INodeAdapter adapter;
            INodeNotifier notifier = (INodeNotifier)node;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.html.ui.internal.projection.ProjectionModelNodeAdapterHTML");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = notifier.getExistingAdapter((Object)clazz)) != null) {
                notifier.removeAdapter(adapter);
            }
            Node nextChild = node.getFirstChild();
            while (nextChild != null) {
                Node childNode = nextChild;
                nextChild = childNode.getNextSibling();
                this.removeAdapterFromNodeAndChildren(childNode, level + 1);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeAllAdapters() {
        long start;
        block8: {
            start = System.currentTimeMillis();
            if (this.fDocument != null) {
                IStructuredModel sModel = null;
                try {
                    int startOffset;
                    IndexedRegion startNode;
                    sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                    if (sModel != null && (startNode = sModel.getIndexedRegion(startOffset = 0)) instanceof Node) {
                        Node nextSibling = (Node)startNode;
                        while (nextSibling != null) {
                            Node currentNode = nextSibling;
                            nextSibling = currentNode.getNextSibling();
                            this.removeAdapterFromNodeAndChildren(currentNode, 0);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (sModel != null) {
                        sModel.releaseFromRead();
                    }
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                    if (sModel == null) break block8;
                }
                sModel.releaseFromRead();
            }
        }
        if (debugProjectionPerf) {
            long end = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderHTML.removeAllAdapters: " + (end - start));
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (this.fDocument != null && this.fDocument != newInput) {
            this.projectionDisabled();
            this.fProjectionNeedsToBeEnabled = true;
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (this.fProjectionNeedsToBeEnabled && this.fDocument == null && newInput != null) {
            this.projectionEnabled();
            this.fProjectionNeedsToBeEnabled = false;
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer.removeTextInputListener((ITextInputListener)this);
            this.fViewer = null;
        }
    }
}

