/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.dialogs.SelectFileOrXMLCatalogIdDialog;
import org.eclipse.wst.xml.ui.internal.dialogs.SelectXMLCatalogIdDialog;

public class EditEntityHelper {
    public void performBrowseForPublicId(Shell parentShell, Text publicIdField) {
        this.performBrowseForPublicId(parentShell, publicIdField, null);
    }

    public void performBrowseForPublicId(Shell parentShell, Text publicIdField, Text systemIdField) {
        String id;
        String[] extensions = new String[]{"dtd", "txt"};
        SelectXMLCatalogIdDialog dialog = new SelectXMLCatalogIdDialog(parentShell, extensions);
        dialog.create();
        dialog.getShell().setText(XMLUIMessages._UI_LABEL_SELECT_XML_CATALOG_ENTRY);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (id = dialog.getId()) != null) {
            publicIdField.setText(id);
            if (systemIdField != null && dialog.getSystemId() != null) {
                systemIdField.setText(dialog.getSystemId());
            }
        }
    }

    public void performBrowseForSystemId(Shell parentShell, Text systemIdField, IPath resourceLocation) {
        String[] extensions = new String[]{"dtd"};
        SelectFileOrXMLCatalogIdDialog dialog = new SelectFileOrXMLCatalogIdDialog(parentShell, extensions, 3);
        dialog.create();
        dialog.getShell().setText(XMLUIMessages._UI_LABEL_SPECIFY_SYSTEM_ID);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String id = dialog.getId();
            IFile file = dialog.getFile();
            if (id != null) {
                systemIdField.setText(id);
            } else if (file != null) {
                String uri = null;
                uri = resourceLocation != null ? URIHelper.getRelativeURI((IPath)file.getLocation(), (IPath)resourceLocation) : file.getLocation().toOSString();
                systemIdField.setText(uri);
            }
        }
    }
}

