/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class IntroduceIndirectionRefactoring
extends ScriptableRefactoring {
    private IJavaScriptUnit fSelectionCompilationUnit;
    private IClassFile fSelectionClassFile;
    private int fSelectionStart;
    private int fSelectionLength;
    private FunctionInvocation fSelectionMethodInvocation;
    private IType fIntermediaryClass;
    private ITypeBinding fIntermediaryClassBinding;
    private String fIntermediaryMethodName;
    private ITypeBinding fIntermediaryFirstParameterType;
    private IFunction fTargetMethod;
    private IFunctionBinding fTargetMethodBinding;
    private boolean fUpdateReferences;
    private Map fRewrites;
    private TextChangeManager fTextChangeManager;
    private MemberVisibilityAdjustor fAdjustor;
    private Map fIntermediaryAdjustments;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IntroduceIndirectionRefactoring(IJavaScriptUnit unit, int offset, int length) {
        this.fSelectionCompilationUnit = unit;
        this.initialize(offset, length);
    }

    public IntroduceIndirectionRefactoring(IClassFile file, int offset, int length) {
        this.fSelectionClassFile = file;
        this.initialize(offset, length);
    }

    public IntroduceIndirectionRefactoring(IFunction method) {
        this.fTargetMethod = method;
        this.initialize(0, 0);
    }

    private void initialize(int offset, int length) {
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        this.fUpdateReferences = true;
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceIndirectionRefactoring_introduce_indirection_name;
    }

    public IJavaScriptProject getProject() {
        if (this.fSelectionCompilationUnit != null) {
            return this.fSelectionCompilationUnit.getJavaScriptProject();
        }
        if (this.fSelectionClassFile != null) {
            return this.fSelectionClassFile.getJavaScriptProject();
        }
        if (this.fTargetMethod != null) {
            return this.fTargetMethod.getJavaScriptProject();
        }
        return null;
    }

    public IPackageFragment getInvocationPackage() {
        return this.fSelectionCompilationUnit != null ? (IPackageFragment)this.fSelectionCompilationUnit.getAncestor(4) : null;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setEnableUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public RefactoringStatus setIntermediaryMethodName(String newMethodName) {
        Assert.isNotNull((Object)newMethodName);
        this.fIntermediaryMethodName = newMethodName;
        RefactoringStatus stat = Checks.checkMethodName(newMethodName);
        stat.merge(this.checkOverloading());
        return stat;
    }

    private RefactoringStatus checkOverloading() {
        try {
            if (this.fIntermediaryClass != null) {
                IFunction[] toCheck = this.fIntermediaryClass.getFunctions();
                int i = 0;
                while (i < toCheck.length) {
                    IFunction method = toCheck[i];
                    if (method.getElementName().equals(this.fIntermediaryMethodName)) {
                        return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_duplicate_method_name_in_declaring_class_error, this.fIntermediaryMethodName));
                    }
                    ++i;
                }
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_could_not_parse_declaring_class_error);
        }
        return new RefactoringStatus();
    }

    public String getIntermediaryMethodName() {
        return this.fIntermediaryMethodName;
    }

    public RefactoringStatus setIntermediaryClassName(String fullyQualifiedTypeName) {
        IType target = null;
        try {
            if (fullyQualifiedTypeName.length() == 0) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_class_not_selected_error);
            }
            target = this.getProject().findType(fullyQualifiedTypeName, (IProgressMonitor)new NullProgressMonitor());
            if (target == null || !target.exists()) {
                return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_class_does_not_exist_error, fullyQualifiedTypeName));
            }
            if (target.isAnnotation()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_annotation);
            }
            if (target.isInterface()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_on_interface);
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_unable_determine_declaring_type);
        }
        if (target.isReadOnly()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_readonly);
        }
        if (target.isBinary()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_binary);
        }
        this.fIntermediaryClass = target;
        return new RefactoringStatus();
    }

    public String getIntermediaryClassName() {
        return this.fIntermediaryClass != null ? JavaModelUtil.getFullyQualifiedName(this.fIntermediaryClass) : "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        block28: {
            RefactoringStatus refactoringStatus2;
            block27: {
                RefactoringStatus refactoringStatus3;
                block26: {
                    RefactoringStatus refactoringStatus4;
                    block25: {
                        RefactoringStatus refactoringStatus5;
                        block24: {
                            RefactoringStatus refactoringStatus6;
                            block23: {
                                try {
                                    pm.beginTask(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_activation, 1);
                                    this.fRewrites = new HashMap();
                                    if (this.fTargetMethod == null) {
                                        ASTNode selectionNode;
                                        if (this.fSelectionStart == 0) {
                                            refactoringStatus6 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                                            Object var5_8 = null;
                                            break block23;
                                        }
                                        if (this.fSelectionCompilationUnit != null) {
                                            JavaScriptUnit selectionCURoot = this.getCachedCURewrite(this.fSelectionCompilationUnit).getRoot();
                                            selectionNode = IntroduceIndirectionRefactoring.getSelectedNode(this.fSelectionCompilationUnit, selectionCURoot, this.fSelectionStart, this.fSelectionLength);
                                        } else {
                                            ASTParser parser = ASTParser.newParser((int)3);
                                            parser.setResolveBindings(true);
                                            parser.setSource(this.fSelectionClassFile);
                                            JavaScriptUnit selectionCURoot = (JavaScriptUnit)parser.createAST(null);
                                            selectionNode = IntroduceIndirectionRefactoring.getSelectedNode(null, selectionCURoot, this.fSelectionStart, this.fSelectionLength);
                                        }
                                        if (selectionNode == null) {
                                            refactoringStatus5 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                                            break block24;
                                        }
                                        IFunctionBinding targetMethodBinding = null;
                                        if (selectionNode.getNodeType() == 32) {
                                            targetMethodBinding = ((FunctionInvocation)selectionNode).resolveMethodBinding();
                                        } else if (selectionNode.getNodeType() == 31) {
                                            targetMethodBinding = ((FunctionDeclaration)selectionNode).resolveBinding();
                                        } else {
                                            if (selectionNode.getNodeType() != 48) {
                                                refactoringStatus4 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                                                break block25;
                                            }
                                            targetMethodBinding = ((SuperMethodInvocation)selectionNode).resolveMethodBinding();
                                        }
                                        this.fTargetMethodBinding = targetMethodBinding.getMethodDeclaration();
                                        this.fTargetMethod = (IFunction)this.fTargetMethodBinding.getJavaElement();
                                        if (selectionNode instanceof FunctionInvocation && this.fSelectionCompilationUnit != null) {
                                            this.fSelectionMethodInvocation = (FunctionInvocation)selectionNode;
                                        }
                                    } else if (this.fTargetMethod.getJavaScriptUnit() != null) {
                                        JavaScriptUnit selectionCURoot = this.getCachedCURewrite(this.fTargetMethod.getJavaScriptUnit()).getRoot();
                                        FunctionDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fTargetMethod, selectionCURoot);
                                        this.fTargetMethodBinding = declaration.resolveBinding().getMethodDeclaration();
                                    } else {
                                        ASTParser parser = ASTParser.newParser((int)3);
                                        parser.setProject(this.fTargetMethod.getJavaScriptProject());
                                        IBinding[] bindings = parser.createBindings(new IJavaScriptElement[]{this.fTargetMethod}, null);
                                        this.fTargetMethodBinding = ((IFunctionBinding)bindings[0]).getMethodDeclaration();
                                    }
                                    if (this.fTargetMethod == null || this.fTargetMethodBinding == null || !RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(this.fTargetMethod)) {
                                        refactoringStatus3 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                                        break block26;
                                    }
                                    if (this.fTargetMethod.isConstructor()) {
                                        refactoringStatus2 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_for_constructors);
                                        break block27;
                                    }
                                    if (this.fIntermediaryMethodName == null) {
                                        this.fIntermediaryMethodName = this.fTargetMethod.getElementName();
                                    }
                                    if (this.fIntermediaryClass == null) {
                                        if (this.fSelectionCompilationUnit != null && !this.fSelectionCompilationUnit.isReadOnly()) {
                                            this.fIntermediaryClass = this.getEnclosingInitialSelectionMember().getDeclaringType();
                                        } else if (!this.fTargetMethod.isBinary() && !this.fTargetMethod.isReadOnly()) {
                                            this.fIntermediaryClass = this.fTargetMethod.getDeclaringType();
                                        }
                                    }
                                    refactoringStatus = new RefactoringStatus();
                                    break block28;
                                }
                                catch (Throwable throwable) {
                                    Object var5_14 = null;
                                    pm.done();
                                    throw throwable;
                                }
                            }
                            pm.done();
                            return refactoringStatus6;
                        }
                        Object var5_9 = null;
                        pm.done();
                        return refactoringStatus5;
                    }
                    Object var5_10 = null;
                    pm.done();
                    return refactoringStatus4;
                }
                Object var5_11 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var5_12 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var5_13 = null;
        pm.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        this.fTextChangeManager = new TextChangeManager();
        this.fIntermediaryFirstParameterType = null;
        this.fIntermediaryClassBinding = null;
        Iterator iter = this.fRewrites.values().iterator();
        while (iter.hasNext()) {
            ((CompilationUnitRewrite)iter.next()).clearASTAndImportRewrites();
        }
        int startupTicks = 5;
        int hierarchyTicks = 5;
        int visibilityTicks = 5;
        int referenceTicks = this.fUpdateReferences ? 30 : 5;
        int creationTicks = 5;
        pm.beginTask("", startupTicks + hierarchyTicks + visibilityTicks + referenceTicks + creationTicks);
        pm.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        result.merge(Checks.checkMethodName(this.fIntermediaryMethodName));
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fIntermediaryClass == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_run_without_intermediary_type);
        }
        CompilationUnitRewrite imRewrite = this.getCachedCURewrite(this.fIntermediaryClass.getJavaScriptUnit());
        this.fIntermediaryClassBinding = this.typeToBinding(this.fIntermediaryClass, imRewrite.getRoot());
        this.fAdjustor = new MemberVisibilityAdjustor((IJavaScriptElement)this.fIntermediaryClass, (IMember)this.fIntermediaryClass);
        this.fIntermediaryAdjustments = new HashMap();
        if (this.fIntermediaryClassBinding.isNested() && !Modifier.isStatic(this.fIntermediaryClassBinding.getModifiers())) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_nested_nonstatic, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fIntermediaryClass));
        }
        pm.worked(startupTicks);
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.fUpdateReferences) {
            pm.setTaskName(String.valueOf(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions) + " " + RefactoringCoreMessages.IntroduceIndirectionRefactoring_looking_for_references);
            result.merge(this.updateReferences((IProgressMonitor)new NoOverrideProgressMonitor(pm, referenceTicks)));
            pm.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        } else {
            if (this.fSelectionMethodInvocation != null) {
                this.fIntermediaryFirstParameterType = this.getExpressionType(this.fSelectionMethodInvocation);
                IMember enclosing = this.getEnclosingInitialSelectionMember();
                result.merge(this.updateMethodInvocation(this.fSelectionMethodInvocation, enclosing, this.getCachedCURewrite(this.fSelectionCompilationUnit)));
                if (!this.isRewriteKept(this.fSelectionCompilationUnit)) {
                    this.createChangeAndDiscardRewrite(this.fSelectionCompilationUnit);
                }
                result.merge(this.adjustVisibility((IMember)this.fIntermediaryClass, (IMember)enclosing.getDeclaringType(), (IProgressMonitor)new NoOverrideProgressMonitor(pm, 0)));
            }
            pm.worked(referenceTicks);
        }
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.fIntermediaryFirstParameterType == null) {
            this.fIntermediaryFirstParameterType = this.fTargetMethodBinding.getDeclaringClass();
        }
        IType actualTargetType = (IType)this.fIntermediaryFirstParameterType.getJavaElement();
        if (this.fTargetMethod.getDeclaringType() == null || !this.fTargetMethod.getDeclaringType().equals(actualTargetType)) {
            IFunction actualTargetMethod;
            this.fTargetMethod = actualTargetMethod = new MethodOverrideTester(actualTargetType, actualTargetType.newSupertypeHierarchy(null)).findOverriddenMethodInHierarchy(actualTargetType, this.fTargetMethod);
            this.fTargetMethodBinding = this.findMethodBindingInHierarchy(this.fIntermediaryFirstParameterType, actualTargetMethod);
            Assert.isNotNull((Object)this.fTargetMethodBinding);
        }
        result.merge(this.checkCanCreateIntermediaryMethod());
        this.createIntermediaryMethod();
        pm.worked(creationTicks);
        pm.setTaskName(String.valueOf(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions) + " " + RefactoringCoreMessages.IntroduceIndirectionRefactoring_adjusting_visibility);
        result.merge(this.updateTargetVisibility((IProgressMonitor)new NoOverrideProgressMonitor(pm, 0)));
        result.merge(this.updateIntermediaryVisibility(new NoOverrideProgressMonitor(pm, 0)));
        pm.worked(visibilityTicks);
        pm.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        this.createChangeAndDiscardRewrite(this.fIntermediaryClass.getJavaScriptUnit());
        result.merge(Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext()));
        pm.done();
        return result;
    }

    private RefactoringStatus updateTargetVisibility(IProgressMonitor monitor) throws JavaScriptModelException, CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.adjustVisibility((IMember)((IType)this.fIntermediaryFirstParameterType.getJavaElement()), (IMember)this.fIntermediaryClass, monitor));
        if (result.hasError()) {
            return result;
        }
        Modifier.ModifierKeyword neededVisibility = this.getNeededVisibility((IMember)this.fTargetMethod, (IMember)this.fIntermediaryClass);
        if (neededVisibility != null) {
            result.merge(this.adjustVisibility((IMember)this.fTargetMethod, neededVisibility, monitor));
            if (result.hasError()) {
                return result;
            }
            if (this.fTargetMethod.getDeclaringType() != null) {
                ITypeHierarchy hierarchy = this.fTargetMethod.getDeclaringType().newTypeHierarchy(null);
                MethodOverrideTester tester = new MethodOverrideTester(this.fTargetMethod.getDeclaringType(), hierarchy);
                IType[] subtypes = hierarchy.getAllSubtypes(this.fTargetMethod.getDeclaringType());
                int i = 0;
                while (i < subtypes.length) {
                    IFunction method = tester.findOverridingMethodInType(subtypes[i], this.fTargetMethod);
                    if (method != null && method.exists()) {
                        result.merge(this.adjustVisibility((IMember)method, neededVisibility, monitor));
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (result.hasError()) {
                            return result;
                        }
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private RefactoringStatus updateIntermediaryVisibility(NoOverrideProgressMonitor monitor) throws JavaScriptModelException {
        return this.rewriteVisibility(this.fIntermediaryAdjustments, this.fRewrites, (IProgressMonitor)monitor);
    }

    private RefactoringStatus updateReferences(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        monitor.beginTask("", 90);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IFunction[] ripple = RippleMethodFinder2.getRelatedMethods(this.fTargetMethod, false, (IProgressMonitor)new NoOverrideProgressMonitor(monitor, 10), null);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        SearchResultGroup[] references = Checks.excludeCompilationUnits(this.getReferences(ripple, (IProgressMonitor)new NoOverrideProgressMonitor(monitor, 10), result), result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(references));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        int ticksPerCU = references.length == 0 ? 0 : 70 / references.length;
        int i = 0;
        while (i < references.length) {
            SearchResultGroup group = references[i];
            SearchMatch[] searchResults = group.getSearchResults();
            CompilationUnitRewrite currentCURewrite = this.getCachedCURewrite(group.getCompilationUnit());
            int j = 0;
            while (j < searchResults.length) {
                SearchMatch match = searchResults[j];
                if (!match.isInsideDocComment()) {
                    IMember enclosingMember = (IMember)match.getElement();
                    ASTNode target = IntroduceIndirectionRefactoring.getSelectedNode(group.getCompilationUnit(), currentCURewrite.getRoot(), match.getOffset(), match.getLength());
                    if (target instanceof SuperMethodInvocation) {
                        result.merge(this.createWarningAboutCall(enclosingMember, target, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_super_keyword));
                    } else {
                        Assert.isTrue((boolean)(target instanceof FunctionInvocation), (String)"Element of call should be a FunctionInvocation.");
                        FunctionInvocation invocation = (FunctionInvocation)target;
                        ITypeBinding typeBinding = this.getExpressionType(invocation);
                        if (this.fIntermediaryFirstParameterType == null) {
                            this.fIntermediaryFirstParameterType = typeBinding.getTypeDeclaration();
                        } else {
                            result.merge(this.findCommonParent(typeBinding.getTypeDeclaration()));
                        }
                        if (result.hasFatalError()) {
                            return result;
                        }
                        result.merge(this.updateMethodInvocation(invocation, enclosingMember, currentCURewrite));
                        result.merge(this.adjustVisibility((IMember)this.fIntermediaryClass, (IMember)enclosingMember.getDeclaringType(), (IProgressMonitor)new NoOverrideProgressMonitor(monitor, 0)));
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                ++j;
            }
            if (!this.isRewriteKept(group.getCompilationUnit())) {
                this.createChangeAndDiscardRewrite(group.getCompilationUnit());
            }
            monitor.worked(ticksPerCU);
            ++i;
        }
        monitor.done();
        return result;
    }

    private RefactoringStatus findCommonParent(ITypeBinding typeBinding) throws JavaScriptModelException {
        RefactoringStatus status = new RefactoringStatus();
        ITypeBinding current = typeBinding;
        ITypeBinding highest = this.fIntermediaryFirstParameterType;
        if (current.equals((Object)highest) || Bindings.isSuperType(highest, current)) {
            return status;
        }
        ITypeBinding[] currentAndSupers = this.getTypeAndAllSuperTypes(current);
        ITypeBinding[] highestAndSupers = this.getTypeAndAllSuperTypes(highest);
        ITypeBinding foundBinding = null;
        int i1 = 0;
        while (i1 < currentAndSupers.length) {
            int i2 = 0;
            while (i2 < highestAndSupers.length) {
                if (highestAndSupers[i2].isEqualTo((IBinding)currentAndSupers[i1]) && Bindings.findMethodInHierarchy(highestAndSupers[i2], this.fTargetMethodBinding.getName(), this.fTargetMethodBinding.getParameterTypes()) != null) {
                    foundBinding = highestAndSupers[i2];
                    break;
                }
                ++i2;
            }
            if (foundBinding != null) break;
            ++i1;
        }
        if (foundBinding != null) {
            this.fIntermediaryFirstParameterType = foundBinding;
        } else {
            String type1 = this.fIntermediaryFirstParameterType.getQualifiedName();
            String type2 = current.getQualifiedName();
            status.addFatalError(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_open_hierarchy_error, new String[]{type1, type2}));
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaScriptProject javaProject = this.fTargetMethod.getJavaScriptProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 589830;
        IType declaring = this.fTargetMethod.getDeclaringType();
        try {
            if (declaring.isLocal() || declaring.isAnonymous()) {
                flags |= 0x40000;
            }
        }
        catch (JavaScriptModelException exception) {
            JavaScriptPlugin.log(exception);
        }
        String description = Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_descriptor_description_short, this.fTargetMethod.getElementName());
        String header = Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_descriptor_description, new String[]{JavaScriptElementLabels.getTextLabel(this.fTargetMethod, JavaScriptElementLabels.ALL_FULLY_QUALIFIED), JavaScriptElementLabels.getTextLabel(declaring, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_original_pattern, JavaScriptElementLabels.getTextLabel(this.fTargetMethod, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_method_pattern, this.fIntermediaryMethodName));
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_declaring_pattern, JavaScriptElementLabels.getTextLabel(this.fIntermediaryClass, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)));
        if (this.fUpdateReferences) {
            comment.addSetting(RefactoringCoreMessages.JavaRefactoringDescriptor_update_references);
        }
        JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.introduce.indirection", project, description, comment.asString(), arguments, flags);
        arguments.put("input", descriptor.elementToHandle((IJavaScriptElement)this.fTargetMethod));
        arguments.put("name", this.fIntermediaryMethodName);
        arguments.put("element1", descriptor.elementToHandle((IJavaScriptElement)this.fIntermediaryClass));
        arguments.put("references", Boolean.valueOf(this.fUpdateReferences).toString());
        return new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.IntroduceIndirectionRefactoring_introduce_indirection, (Change[])this.fTextChangeManager.getAllChanges());
    }

    private RefactoringStatus checkCanCreateIntermediaryMethod() throws JavaScriptModelException {
        ArrayList<ITypeBinding> parameterBindings = new ArrayList<ITypeBinding>();
        if (!this.isStaticTarget()) {
            parameterBindings.add(this.fIntermediaryFirstParameterType);
        }
        parameterBindings.addAll(Arrays.asList(this.fTargetMethodBinding.getParameterTypes()));
        return Checks.checkMethodInType(this.fIntermediaryClassBinding, this.fIntermediaryMethodName, parameterBindings.toArray(new ITypeBinding[parameterBindings.size()]));
    }

    private void createIntermediaryMethod() throws CoreException {
        String comment;
        CompilationUnitRewrite imRewrite = this.getCachedCURewrite(this.fIntermediaryClass.getJavaScriptUnit());
        AST ast = imRewrite.getAST();
        FunctionDeclaration intermediary = ast.newFunctionDeclaration();
        intermediary.setName(ast.newSimpleName(this.fIntermediaryMethodName));
        List modifiers = intermediary.modifiers();
        modifiers.add(imRewrite.getAST().newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        modifiers.add(imRewrite.getAST().newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        String targetParameterName = StubUtility.suggestArgumentName(this.getProject(), this.fIntermediaryFirstParameterType.getName(), this.fTargetMethod.getParameterNames());
        if (!this.isStaticTarget()) {
            SingleVariableDeclaration parameter = imRewrite.getAST().newSingleVariableDeclaration();
            Type t = imRewrite.getImportRewrite().addImport(this.fIntermediaryFirstParameterType, imRewrite.getAST());
            if (this.fIntermediaryFirstParameterType.isGenericType()) {
                ParameterizedType parameterized = imRewrite.getAST().newParameterizedType(t);
                ITypeBinding[] typeParameters = this.fIntermediaryFirstParameterType.getTypeParameters();
                int i = 0;
                while (i < typeParameters.length) {
                    parameterized.typeArguments().add(imRewrite.getImportRewrite().addImport(typeParameters[i], imRewrite.getAST()));
                    ++i;
                }
                t = parameterized;
            }
            parameter.setType(t);
            parameter.setName(imRewrite.getAST().newSimpleName(targetParameterName));
            intermediary.parameters().add(parameter);
        }
        this.copyArguments(intermediary, imRewrite);
        if (!this.isStaticTarget() && this.fIntermediaryFirstParameterType.isGenericType()) {
            this.addTypeParameters(imRewrite, intermediary.typeParameters(), this.fIntermediaryFirstParameterType);
        }
        this.copyTypeParameters(intermediary, imRewrite);
        intermediary.setReturnType2(imRewrite.getImportRewrite().addImport(this.fTargetMethodBinding.getReturnType(), ast));
        this.copyExceptions(intermediary, imRewrite);
        FunctionInvocation invocation = imRewrite.getAST().newFunctionInvocation();
        invocation.setName(imRewrite.getAST().newSimpleName(this.fTargetMethod.getElementName()));
        if (this.isStaticTarget()) {
            Type type = imRewrite.getImportRewrite().addImport(this.fTargetMethodBinding.getDeclaringClass(), ast);
            invocation.setExpression((Expression)ASTNodeFactory.newName(ast, ASTNodes.asString((ASTNode)type)));
        } else {
            invocation.setExpression((Expression)imRewrite.getAST().newSimpleName(targetParameterName));
        }
        this.copyInvocationParameters(invocation, ast);
        Statement call = this.encapsulateInvocation(intermediary, invocation);
        Block body = imRewrite.getAST().newBlock();
        body.statements().add(call);
        intermediary.setBody(body);
        IJavaScriptUnit targetCU = imRewrite.getCu();
        if (StubUtility.doAddComments(targetCU.getJavaScriptProject()) && (comment = CodeGeneration.getMethodComment(targetCU, this.getIntermediaryClassName(), intermediary, null, StubUtility.getLineDelimiterUsed((IJavaScriptElement)targetCU))) != null) {
            JSdoc javadoc = (JSdoc)imRewrite.getASTRewrite().createStringPlaceholder(comment, 29);
            intermediary.setJavadoc(javadoc);
        }
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)this.typeToDeclaration(this.fIntermediaryClass, imRewrite.getRoot());
        ChildListPropertyDescriptor typeBodyDeclarationsProperty = this.typeToBodyDeclarationProperty(this.fIntermediaryClass, imRewrite.getRoot());
        ListRewrite bodyDeclarationsListRewrite = imRewrite.getASTRewrite().getListRewrite((ASTNode)type, typeBodyDeclarationsProperty);
        bodyDeclarationsListRewrite.insertAt((ASTNode)intermediary, ASTNodes.getInsertionIndex((BodyDeclaration)intermediary, type.bodyDeclarations()), imRewrite.createGroupDescription(RefactoringCoreMessages.IntroduceIndirectionRefactoring_group_description_create_new_method));
    }

    private void addTypeParameters(CompilationUnitRewrite imRewrite, List newTypeParameters, ITypeBinding parent) {
        ITypeBinding enclosing = parent.getDeclaringClass();
        if (enclosing != null) {
            this.addTypeParameters(imRewrite, newTypeParameters, enclosing);
        }
        ITypeBinding[] typeParameters = parent.getTypeParameters();
        int i = 0;
        while (i < typeParameters.length) {
            TypeParameter ntp = imRewrite.getAST().newTypeParameter();
            ntp.setName(imRewrite.getAST().newSimpleName(typeParameters[i].getName()));
            ITypeBinding[] bounds = typeParameters[i].getTypeBounds();
            int j = 0;
            while (j < bounds.length) {
                if (!"java.lang.Object".equals(bounds[j].getQualifiedName())) {
                    ntp.typeBounds().add(imRewrite.getImportRewrite().addImport(bounds[j], imRewrite.getAST()));
                }
                ++j;
            }
            newTypeParameters.add(ntp);
            ++i;
        }
    }

    private Statement encapsulateInvocation(FunctionDeclaration declaration, FunctionInvocation invocation) {
        Type type = declaration.getReturnType2();
        if (type == null || type instanceof PrimitiveType && PrimitiveType.VOID.equals(((PrimitiveType)type).getPrimitiveTypeCode())) {
            return invocation.getAST().newExpressionStatement((Expression)invocation);
        }
        ReturnStatement statement = invocation.getAST().newReturnStatement();
        statement.setExpression((Expression)invocation);
        return statement;
    }

    private void copyInvocationParameters(FunctionInvocation invocation, AST ast) throws JavaScriptModelException {
        String[] names = this.fTargetMethod.getParameterNames();
        int i = 0;
        while (i < names.length) {
            invocation.arguments().add(ast.newSimpleName(names[i]));
            ++i;
        }
    }

    private void copyArguments(FunctionDeclaration intermediary, CompilationUnitRewrite rew) throws JavaScriptModelException {
        String[] names = this.fTargetMethod.getParameterNames();
        ITypeBinding[] types = this.fTargetMethodBinding.getParameterTypes();
        int i = 0;
        while (i < names.length) {
            ITypeBinding typeBinding = types[i];
            SingleVariableDeclaration newElement = rew.getAST().newSingleVariableDeclaration();
            newElement.setName(rew.getAST().newSimpleName(names[i]));
            if (i == names.length - 1 && this.fTargetMethodBinding.isVarargs()) {
                newElement.setVarargs(true);
                if (typeBinding.isArray()) {
                    typeBinding = typeBinding.getComponentType();
                }
            }
            newElement.setType(rew.getImportRewrite().addImport(typeBinding, rew.getAST()));
            intermediary.parameters().add(newElement);
            ++i;
        }
    }

    private void copyTypeParameters(FunctionDeclaration intermediary, CompilationUnitRewrite rew) {
        ITypeBinding[] typeParameters = this.fTargetMethodBinding.getTypeParameters();
        int i = 0;
        while (i < typeParameters.length) {
            ITypeBinding current = typeParameters[i];
            TypeParameter parameter = rew.getAST().newTypeParameter();
            parameter.setName(rew.getAST().newSimpleName(current.getName()));
            ITypeBinding[] bounds = current.getTypeBounds();
            int j = 0;
            while (j < bounds.length) {
                if (!"java.lang.Object".equals(bounds[j].getQualifiedName())) {
                    parameter.typeBounds().add(rew.getImportRewrite().addImport(bounds[j], rew.getAST()));
                }
                ++j;
            }
            intermediary.typeParameters().add(parameter);
            ++i;
        }
    }

    private void copyExceptions(FunctionDeclaration intermediary, CompilationUnitRewrite imRewrite) {
        ITypeBinding[] exceptionTypes = this.fTargetMethodBinding.getExceptionTypes();
        int i = 0;
        while (i < exceptionTypes.length) {
            String qualifiedName = imRewrite.getImportRewrite().addImport(exceptionTypes[i]);
            intermediary.thrownExceptions().add(ASTNodeFactory.newName(imRewrite.getAST(), qualifiedName));
            ++i;
        }
    }

    private RefactoringStatus updateMethodInvocation(FunctionInvocation originalInvocation, IMember enclosing, CompilationUnitRewrite unitRewriter) throws JavaScriptModelException {
        RefactoringStatus status = new RefactoringStatus();
        if (originalInvocation.typeArguments().size() > 0) {
            return this.createWarningAboutCall(enclosing, (ASTNode)originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_type_arguments);
        }
        FunctionInvocation newInvocation = unitRewriter.getAST().newFunctionInvocation();
        List newInvocationArgs = newInvocation.arguments();
        List originalInvocationArgs = originalInvocation.arguments();
        String qualifier = unitRewriter.getImportRewrite().addImport(this.fIntermediaryClassBinding);
        newInvocation.setExpression((Expression)ASTNodeFactory.newName(unitRewriter.getAST(), qualifier));
        newInvocation.setName(unitRewriter.getAST().newSimpleName(this.getIntermediaryMethodName()));
        Expression expression = originalInvocation.getExpression();
        if (!this.isStaticTarget()) {
            if (expression == null) {
                ThisExpression expr = unitRewriter.getAST().newThisExpression();
                RefactoringStatus qualifierStatus = this.qualifyThisExpression(expr, originalInvocation, enclosing, unitRewriter);
                status.merge(qualifierStatus);
                if (qualifierStatus.hasEntries()) {
                    return status;
                }
                newInvocationArgs.add(expr);
            } else {
                ASTNode expressionAsParam = unitRewriter.getASTRewrite().createMoveTarget((ASTNode)expression);
                newInvocationArgs.add(expressionAsParam);
            }
        } else if (!(expression == null || expression instanceof Name && ASTNodes.getTypeBinding((Name)expression) != null)) {
            return this.createWarningAboutCall(enclosing, (ASTNode)originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_static_expression_access);
        }
        int i = 0;
        while (i < originalInvocationArgs.size()) {
            Expression originalInvocationArg = (Expression)originalInvocationArgs.get(i);
            ASTNode movedArg = unitRewriter.getASTRewrite().createMoveTarget((ASTNode)originalInvocationArg);
            newInvocationArgs.add(movedArg);
            ++i;
        }
        unitRewriter.getASTRewrite().replace((ASTNode)originalInvocation, (ASTNode)newInvocation, unitRewriter.createGroupDescription(RefactoringCoreMessages.IntroduceIndirectionRefactoring_group_description_replace_call));
        return status;
    }

    private RefactoringStatus qualifyThisExpression(ThisExpression expr, FunctionInvocation originalInvocation, IMember enclosing, CompilationUnitRewrite unitRewriter) {
        RefactoringStatus status = new RefactoringStatus();
        IFunctionBinding methodBinding = originalInvocation.resolveMethodBinding();
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)ASTNodes.findDeclaration((IBinding)methodBinding, originalInvocation.getRoot());
        ITypeBinding currentTypeBinding = null;
        if (methodDeclaration != null) {
            currentTypeBinding = ASTNodes.isParent((ASTNode)originalInvocation, methodDeclaration.getParent()) ? methodBinding.getDeclaringClass() : ASTNodes.getEnclosingType((ASTNode)originalInvocation);
        } else {
            ASTNode currentTypeDeclaration = this.getEnclosingTypeDeclaration((ASTNode)originalInvocation);
            currentTypeBinding = ASTNodes.getEnclosingType(currentTypeDeclaration);
            while (currentTypeDeclaration != null && Bindings.findMethodInHierarchy(currentTypeBinding, methodBinding.getName(), methodBinding.getParameterTypes()) == null) {
                currentTypeDeclaration = this.getEnclosingTypeDeclaration(currentTypeDeclaration.getParent());
                currentTypeBinding = ASTNodes.getEnclosingType(currentTypeDeclaration);
            }
        }
        if (currentTypeBinding == null) {
            status.merge(this.createWarningAboutCall(enclosing, (ASTNode)originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_declaring_type_not_found));
            return status;
        }
        ITypeBinding typeOfCall = ASTNodes.getEnclosingType((ASTNode)originalInvocation);
        if (!typeOfCall.equals((Object)currentTypeBinding)) {
            if (currentTypeBinding.isAnonymous()) {
                status.merge(this.createWarningAboutCall(enclosing, (ASTNode)originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_anonymous_cannot_qualify));
            } else {
                expr.setQualifier((Name)unitRewriter.getAST().newSimpleName(currentTypeBinding.getName()));
            }
        }
        return status;
    }

    private IFunctionBinding findMethodBindingInHierarchy(ITypeBinding currentTypeBinding, IFunction methodDeclaration) {
        IFunctionBinding b;
        IFunctionBinding[] bindings = currentTypeBinding.getDeclaredMethods();
        int i = 0;
        while (i < bindings.length) {
            if (methodDeclaration.equals(bindings[i].getJavaElement())) {
                return bindings[i];
            }
            ++i;
        }
        ITypeBinding superClass = currentTypeBinding.getSuperclass();
        if (superClass != null && (b = this.findMethodBindingInHierarchy(superClass, methodDeclaration)) != null) {
            return b;
        }
        ITypeBinding[] interfaces = currentTypeBinding.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.length) {
            IFunctionBinding b2 = this.findMethodBindingInHierarchy(interfaces[i2], methodDeclaration);
            if (b2 != null) {
                return b2;
            }
            ++i2;
        }
        return null;
    }

    private ITypeBinding[] getTypeAndAllSuperTypes(ITypeBinding type) {
        ArrayList result = new ArrayList();
        this.collectSuperTypes(type, result);
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private void collectSuperTypes(ITypeBinding curr, List list) {
        if (list.add(curr.getTypeDeclaration())) {
            ITypeBinding[] interfaces = curr.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                this.collectSuperTypes(interfaces[i], list);
                ++i;
            }
            ITypeBinding superClass = curr.getSuperclass();
            if (superClass != null) {
                this.collectSuperTypes(superClass, list);
            }
        }
    }

    private CompilationUnitRewrite getCachedCURewrite(IJavaScriptUnit unit) {
        CompilationUnitRewrite rewrite = (CompilationUnitRewrite)this.fRewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit);
            this.fRewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    private boolean isRewriteKept(IJavaScriptUnit compilationUnit) {
        return this.fIntermediaryClass.getJavaScriptUnit().equals(compilationUnit);
    }

    private void createChangeAndDiscardRewrite(IJavaScriptUnit compilationUnit) throws CoreException {
        CompilationUnitRewrite rewrite = (CompilationUnitRewrite)this.fRewrites.get(compilationUnit);
        if (rewrite != null) {
            this.fTextChangeManager.manage(compilationUnit, (TextChange)rewrite.createChange());
            this.fRewrites.remove(compilationUnit);
        }
    }

    private SearchResultGroup[] getReferences(IFunction[] methods, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaScriptElement[])methods, 2);
        IJavaScriptSearchScope scope = RefactoringScopeFactory.create((IJavaScriptElement)this.fIntermediaryClass, false);
        return RefactoringSearchEngine.search(pattern, scope, pm, status);
    }

    private ITypeBinding typeToBinding(IType type, JavaScriptUnit root) throws JavaScriptModelException {
        ASTNode typeNode = this.typeToDeclaration(type, root);
        if (type.isAnonymous()) {
            return ((AnonymousClassDeclaration)typeNode).resolveBinding();
        }
        return ((AbstractTypeDeclaration)typeNode).resolveBinding();
    }

    private ASTNode typeToDeclaration(IType type, JavaScriptUnit root) throws JavaScriptModelException {
        Name intermediateName = (Name)NodeFinder.perform((ASTNode)root, type.getNameRange());
        if (type.isAnonymous()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ASTNodes.getParent((ASTNode)intermediateName, clazz);
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTNodes.getParent((ASTNode)intermediateName, clazz);
    }

    private ASTNode getEnclosingTypeDeclaration(ASTNode node) {
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                return node;
            }
            if (node instanceof AnonymousClassDeclaration) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private ChildListPropertyDescriptor typeToBodyDeclarationProperty(IType type, JavaScriptUnit root) throws JavaScriptModelException {
        ASTNode typeDeclaration = this.typeToDeclaration(type, root);
        if (typeDeclaration instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)typeDeclaration).getBodyDeclarationsProperty();
        }
        if (typeDeclaration instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private RefactoringStatus createWarningAboutCall(IMember enclosing, ASTNode concreteNode, String message) {
        String name = JavaScriptElementLabels.getElementLabel((IJavaScriptElement)enclosing, JavaScriptElementLabels.ALL_DEFAULT);
        String container = JavaScriptElementLabels.getElementLabel((IJavaScriptElement)enclosing.getDeclaringType(), JavaScriptElementLabels.ALL_FULLY_QUALIFIED);
        return RefactoringStatus.createWarningStatus((String)Messages.format(message, new String[]{name, container}), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)enclosing.getJavaScriptUnit(), concreteNode));
    }

    private ITypeBinding getExpressionType(FunctionInvocation invocation) {
        Expression expression = invocation.getExpression();
        ITypeBinding typeBinding = null;
        typeBinding = expression == null ? invocation.resolveMethodBinding().getDeclaringClass() : expression.resolveTypeBinding();
        Assert.isNotNull((Object)typeBinding, (String)"Type binding of target expression may not be null");
        return typeBinding;
    }

    private IFile[] getAllFilesToModify() {
        ArrayList<IJavaScriptUnit> cus = new ArrayList<IJavaScriptUnit>();
        cus.addAll(Arrays.asList(this.fTextChangeManager.getAllCompilationUnits()));
        return ResourceUtil.getFiles(cus.toArray(new IJavaScriptUnit[cus.size()]));
    }

    private boolean isStaticTarget() throws JavaScriptModelException {
        return Flags.isStatic((int)this.fTargetMethod.getFlags());
    }

    private IMember getEnclosingInitialSelectionMember() throws JavaScriptModelException {
        return (IMember)this.fSelectionCompilationUnit.getElementAt(this.fSelectionStart);
    }

    private static ASTNode getSelectedNode(IJavaScriptUnit unit, JavaScriptUnit root, int offset, int length) {
        ASTNode node = null;
        try {
            node = unit != null ? IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform((ASTNode)root, offset, length, (ITypeRoot)unit)) : IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform((ASTNode)root, offset, length));
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        if (node != null) {
            return node;
        }
        return IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform((ASTNode)root, offset, length));
    }

    private static ASTNode checkNode(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 42) {
            node = node.getParent();
        } else if (node.getNodeType() == 21) {
            node = ((ExpressionStatement)node).getExpression();
        }
        switch (node.getNodeType()) {
            case 31: 
            case 32: 
            case 48: {
                return node;
            }
        }
        return null;
    }

    private Modifier.ModifierKeyword getNeededVisibility(IMember whoToAdjust, IMember fromWhereToLook) throws JavaScriptModelException {
        return this.fAdjustor.getVisibilityThreshold((IJavaScriptElement)fromWhereToLook, whoToAdjust, (IProgressMonitor)new NullProgressMonitor());
    }

    private RefactoringStatus adjustVisibility(IMember whoToAdjust, IMember fromWhereToLook, IProgressMonitor monitor) throws CoreException {
        return this.adjustVisibility(whoToAdjust, this.getNeededVisibility(whoToAdjust, fromWhereToLook), true, monitor);
    }

    private RefactoringStatus adjustVisibility(IMember whoToAdjust, Modifier.ModifierKeyword neededVisibility, IProgressMonitor monitor) throws CoreException {
        return this.adjustVisibility(whoToAdjust, neededVisibility, false, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus adjustVisibility(IMember whoToAdjust, Modifier.ModifierKeyword neededVisibility, boolean alsoIncreaseEnclosing, IProgressMonitor monitor) throws CoreException {
        boolean hasNewAdjustments;
        HashMap adjustments = this.isRewriteKept(whoToAdjust.getJavaScriptUnit()) ? this.fIntermediaryAdjustments : new HashMap();
        int existingAdjustments = adjustments.size();
        this.addAdjustment(whoToAdjust, neededVisibility, adjustments);
        if (alsoIncreaseEnclosing) {
            while (whoToAdjust.getDeclaringType() != null) {
                whoToAdjust = whoToAdjust.getDeclaringType();
                this.addAdjustment(whoToAdjust, neededVisibility, adjustments);
            }
        }
        boolean bl = hasNewAdjustments = adjustments.size() - existingAdjustments > 0;
        if (hasNewAdjustments && (whoToAdjust.isReadOnly() || whoToAdjust.isBinary())) {
            return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_update_binary_target_visibility, new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)whoToAdjust, JavaScriptElementLabels.ALL_DEFAULT)}), (RefactoringStatusContext)JavaStatusContext.create(whoToAdjust));
        }
        RefactoringStatus status = new RefactoringStatus();
        if (!hasNewAdjustments) {
            return status;
        }
        try {
            monitor.beginTask(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting, 2);
            if (!this.isRewriteKept(whoToAdjust.getJavaScriptUnit())) {
                CompilationUnitRewrite rewrite = new CompilationUnitRewrite(whoToAdjust.getJavaScriptUnit());
                rewrite.setResolveBindings(false);
                HashMap<IJavaScriptUnit, CompilationUnitRewrite> rewrites = new HashMap<IJavaScriptUnit, CompilationUnitRewrite>();
                rewrites.put(whoToAdjust.getJavaScriptUnit(), rewrite);
                status.merge(this.rewriteVisibility(adjustments, rewrites, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                rewrite.attachChange((CompilationUnitChange)this.fTextChangeManager.get(whoToAdjust.getJavaScriptUnit()), true, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        monitor.done();
        return status;
    }

    private RefactoringStatus rewriteVisibility(Map adjustments, Map rewrites, IProgressMonitor monitor) throws JavaScriptModelException {
        RefactoringStatus status = new RefactoringStatus();
        this.fAdjustor.setRewrites(rewrites);
        this.fAdjustor.setAdjustments(adjustments);
        this.fAdjustor.setStatus(status);
        this.fAdjustor.rewriteVisibility(monitor);
        return status;
    }

    private void addAdjustment(IMember whoToAdjust, Modifier.ModifierKeyword neededVisibility, Map adjustments) throws JavaScriptModelException {
        Modifier.ModifierKeyword currentVisibility = Modifier.ModifierKeyword.fromFlagValue((int)JdtFlags.getVisibilityCode(whoToAdjust));
        if (MemberVisibilityAdjustor.hasLowerVisibility(currentVisibility, neededVisibility) && MemberVisibilityAdjustor.needsVisibilityAdjustments(whoToAdjust, neededVisibility, adjustments)) {
            adjustments.put(whoToAdjust, new MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment(whoToAdjust, neededVisibility, RefactoringStatus.createWarningStatus((String)Messages.format(MemberVisibilityAdjustor.getMessage(whoToAdjust), new String[]{MemberVisibilityAdjustor.getLabel((IJavaScriptElement)whoToAdjust), MemberVisibilityAdjustor.getLabel(neededVisibility)}), (RefactoringStatusContext)JavaStatusContext.create(whoToAdjust))));
        }
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaScriptElement element;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 9) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.introduce.indirection");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fTargetMethod = (IFunction)element;
            handle = extended.getAttribute("element1");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 7) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.introduce.indirection");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "element1"));
            }
            this.fIntermediaryClass = (IType)element;
            String references = extended.getAttribute("references");
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
            this.fUpdateReferences = Boolean.valueOf(references);
            String name = extended.getAttribute("name");
            if (name != null && !"".equals(name)) {
                return this.setIntermediaryMethodName(name);
            }
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
    }

    private class NoOverrideProgressMonitor
    extends SubProgressMonitor {
        public NoOverrideProgressMonitor(IProgressMonitor monitor, int ticks) {
            super(monitor, ticks, 2);
        }

        public void setTaskName(String name) {
        }
    }
}

