/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.AddToFavoritesAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WSILPerspective;

public class AddWSILToFavoritesAction
extends AddToFavoritesAction {
    public AddWSILToFavoritesAction(Controller controller) {
        super(controller);
    }

    public boolean favoriteExists() {
        String wsilURL = this.getWsilUrl();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("wsilURL", wsilURL);
        return this.favoriteExists(table, "relWSILFolderNode");
    }

    public boolean executeSingleLinkAction() {
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        String wsilURL = this.getWsilUrl();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("wsilURL", wsilURL);
        if (this.isMultipleLinkAction() && this.favoriteExists(table, "relWSILFolderNode")) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_FAVORITES_ALREADY_EXISTS", wsilURL));
            return false;
        }
        if (this.addToFavorites(table, "relWSILFolderNode")) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_INFO_ADD_TO_FAVORITES_SUCCESSFUL", wsilURL));
            return true;
        }
        wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_ADD_TO_FAVORITES", wsilURL));
        return false;
    }

    private String getWsilUrl() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        WsilElement selectedElement = (WsilElement)selectedNode.getTreeElement();
        return selectedElement.getWsilUrl();
    }
}

