/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.javalite;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.frameworks.CommonFrameworksPlugin;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;

public final class JavaProjectLite
implements IJavaProjectLite {
    private final IJavaProject _javaProject;
    private Object lock = new Object();
    private boolean _javaProjectInitialized = false;
    private boolean _rawClasspathRead = false;
    private IClasspathEntry[] _rawClasspath;
    private boolean _rawOutputLocationRead = false;
    private IPath _rawOutputLocation;
    private long _dotClasspathModificationStamp = -1L;

    JavaProjectLite(IJavaProject javaProject, boolean javaProjectInitialized) {
        this._javaProject = javaProject;
        this._javaProjectInitialized = javaProjectInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markJavaProjectInitialized() {
        Object object = this.lock;
        synchronized (object) {
            if (!this._javaProjectInitialized) {
                this._javaProjectInitialized = true;
                this.flushClasspath();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJavaProjectInitialized() {
        Object object = this.lock;
        synchronized (object) {
            return this._javaProjectInitialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushClasspath() {
        Object object = this.lock;
        synchronized (object) {
            this._rawClasspathRead = false;
            this._rawClasspath = null;
            this._rawOutputLocationRead = false;
            this._rawOutputLocation = null;
            this._dotClasspathModificationStamp = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyDotClasspathModificationStamp() {
        long modificationStamp = -1L;
        Object object = this.lock;
        synchronized (object) {
            modificationStamp = this._dotClasspathModificationStamp;
        }
        if (modificationStamp == -1L) {
            this.flushClasspath();
            return;
        }
        IFile dotClasspath = this._javaProject.getProject().getFile(".classpath");
        if (!dotClasspath.exists()) {
            this.flushClasspath();
            return;
        }
        if (modificationStamp != dotClasspath.getModificationStamp()) {
            this.flushClasspath();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDotClasspathModificationStamp() {
        IFile dotClasspath = this._javaProject.getProject().getFile(".classpath");
        long modificationStamp = dotClasspath.getModificationStamp();
        Object object = this.lock;
        synchronized (object) {
            this._dotClasspathModificationStamp = modificationStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IClasspathEntry[] readRawClasspath() {
        if (!this.isJavaProjectInitialized() && JavaCoreLite.isInitialized(this._javaProject)) {
            this.markJavaProjectInitialized();
        }
        if (this.isJavaProjectInitialized()) {
            try {
                return this._javaProject.getRawClasspath();
            }
            catch (JavaModelException e) {
                CommonFrameworksPlugin.log((Exception)((Object)e));
            }
        }
        this.verifyDotClasspathModificationStamp();
        boolean dataRead = false;
        Object object = this.lock;
        synchronized (object) {
            dataRead = this._rawClasspathRead;
        }
        if (!dataRead) {
            this.updateDotClasspathModificationStamp();
            IClasspathEntry[] rawClasspath = this._javaProject.readRawClasspath();
            Object object2 = this.lock;
            synchronized (object2) {
                this._rawClasspathRead = true;
                this._rawClasspath = rawClasspath;
            }
        }
        return this._rawClasspath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IPath readOutputLocation() {
        if (!this.isJavaProjectInitialized() && JavaCoreLite.isInitialized(this._javaProject)) {
            this.markJavaProjectInitialized();
        }
        if (this.isJavaProjectInitialized()) {
            try {
                return this._javaProject.getOutputLocation();
            }
            catch (JavaModelException e) {
                CommonFrameworksPlugin.log((Exception)((Object)e));
            }
        }
        this.verifyDotClasspathModificationStamp();
        boolean dataRead = false;
        Object object = this.lock;
        synchronized (object) {
            dataRead = this._rawOutputLocationRead;
        }
        if (!dataRead) {
            this.updateDotClasspathModificationStamp();
            IPath rawOutputLocation = this._javaProject.readOutputLocation();
            Object object2 = this.lock;
            synchronized (object2) {
                this._rawOutputLocationRead = true;
                this._rawOutputLocation = rawOutputLocation;
            }
        }
        return this._rawOutputLocation;
    }

    public final IProject getProject() {
        return this._javaProject.getProject();
    }

    public final boolean exists() {
        return this._javaProject.exists();
    }

    public final boolean isOpen() {
        return this._javaProject.isOpen();
    }

    public final boolean hasBuildState() {
        return this._javaProject.hasBuildState();
    }
}

