/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.fragment;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.page.ModifyModulesComposite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class ModifyModulesWizardFragment
extends WizardFragment {
    protected ModifyModulesComposite comp;
    protected IModule module;
    protected boolean showPublishOption;

    public ModifyModulesWizardFragment() {
    }

    public ModifyModulesWizardFragment(boolean showPublishOption) {
        this.showPublishOption = showPublishOption;
    }

    public ModifyModulesWizardFragment(IModule module) {
        this.module = module;
    }

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.comp = new ModifyModulesComposite(parent, handle, this.module, this.showPublishOption);
        return this.comp;
    }

    public void setTaskModel(TaskModel taskModel) {
        super.setTaskModel(taskModel);
        if (this.comp != null) {
            this.comp.setTaskModel(taskModel);
        }
    }

    public List getChildFragments() {
        this.updateModules();
        return super.getChildFragments();
    }

    public void enter() {
        this.updateModules();
    }

    protected void updateModules() {
        if (this.comp != null) {
            IServerAttributes server = (IServerAttributes)this.getTaskModel().getObject("server");
            this.comp.setTaskModel(this.getTaskModel());
            this.comp.setServer(server);
        } else if (this.module != null) {
            TaskModel taskModel = this.getTaskModel();
            if (taskModel == null) {
                return;
            }
            IServerWorkingCopy server = (IServerWorkingCopy)taskModel.getObject("server");
            if (server == null) {
                taskModel.putObject("modules", null);
                return;
            }
            final ArrayList<IModule[]> moduleList = new ArrayList<IModule[]>();
            ((Server)server).visit(new IModuleVisitor(){

                public boolean visit(IModule[] module2) {
                    moduleList.add(module2);
                    return true;
                }
            }, null);
            IModule parent = null;
            try {
                IModule[] parents = server.getRootModules(this.module, null);
                ArrayList<IModule> list = new ArrayList<IModule>();
                if (parents != null && parents.length > 0) {
                    parent = parents[0];
                    list.add(parent);
                }
                if (!moduleList.contains(this.module)) {
                    moduleList.add(new IModule[]{this.module});
                }
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Could not find parent module", e);
            }
            taskModel.putObject("modules", moduleList);
        }
    }

    public boolean isComplete() {
        if (this.comp != null) {
            return this.comp.isComplete();
        }
        return true;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        if (this.comp != null) {
            WizardTaskUtil.modifyModules(this.comp.getModulesToAdd(), this.comp.getModulesToRemove(), this.getTaskModel(), monitor);
            if (this.showPublishOption) {
                ServerUIPlugin.getPreferences().setPublishOnAddRemoveModule(this.comp.shouldPublishImmediately());
            }
        }
    }
}

