/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SecondaryTableDialog
extends Dialog {
    private SecondaryTable secondaryTable;
    private JpaProject jpaProject;
    private String defaultSchema;
    private String defaultCatalog;
    protected Combo nameCombo;
    protected Combo catalogCombo;
    protected Combo schemaCombo;
    private String selectedName;
    private String selectedSchema;
    private String selectedCatalog;
    private boolean defaultSchemaSelected;
    private boolean defaultCatalogSelected;

    public SecondaryTableDialog(Shell parent, JpaProject jpaProject, String defaultSchema, String defaultCatalog) {
        super(parent);
        this.jpaProject = jpaProject;
        this.defaultSchema = defaultSchema;
        this.defaultCatalog = defaultCatalog;
    }

    public SecondaryTableDialog(Shell parent, SecondaryTable secondaryTable, JpaProject jpaProject) {
        super(parent);
        this.secondaryTable = secondaryTable;
        this.jpaProject = jpaProject;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x = this.convertWidthInCharsToPixels(50);
        return size;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    protected String getTitle() {
        if (this.secondaryTable != null) {
            return JptUiMappingsMessages.SecondaryTableDialog_editSecondaryTable;
        }
        return JptUiMappingsMessages.SecondaryTableDialog_addSecondaryTable;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 2;
        Label nameLabel = new Label(composite, 16384);
        nameLabel.setText(JptUiMappingsMessages.SecondaryTableDialog_name);
        GridData gridData = new GridData();
        nameLabel.setLayoutData((Object)gridData);
        this.nameCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameCombo.setLayoutData((Object)gridData);
        this.populateNameCombo();
        Label catalogLabel = new Label(composite, 16384);
        catalogLabel.setText(JptUiMappingsMessages.SecondaryTableDialog_catalog);
        gridData = new GridData();
        catalogLabel.setLayoutData((Object)gridData);
        this.catalogCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.catalogCombo.setLayoutData((Object)gridData);
        this.populateCatalogCombo();
        Label schemaLabel = new Label(composite, 16384);
        schemaLabel.setText(JptUiMappingsMessages.SecondaryTableDialog_schema);
        gridData = new GridData();
        schemaLabel.setLayoutData((Object)gridData);
        this.schemaCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.schemaCombo.setLayoutData((Object)gridData);
        this.populateSchemaCombo();
        this.schemaCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SecondaryTableDialog.this.repopulateNameCombo();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SecondaryTableDialog.this.repopulateNameCombo();
            }
        });
        return composite;
    }

    protected Database getDatabase() {
        return this.getConnectionProfile().getDatabase();
    }

    private ConnectionProfile getConnectionProfile() {
        return this.jpaProject.getConnectionProfile();
    }

    protected Schema getDefaultTableSchema() {
        if (this.secondaryTable != null) {
            return this.getTableSchema(this.secondaryTable.getDefaultSchema());
        }
        return this.getTableSchema(this.defaultSchema);
    }

    protected Schema getTableSchema() {
        if (this.secondaryTable != null) {
            return this.getTableSchema(this.secondaryTable.getSchema());
        }
        return this.getTableSchema(this.defaultSchema);
    }

    protected Schema getTableSchema(String schemaName) {
        Database database = this.getDatabase();
        if (database != null) {
            return database.schemaNamed(schemaName);
        }
        return null;
    }

    protected void populateNameCombo() {
        Schema schema = this.getTableSchema();
        if (schema != null) {
            Iterator tables = schema.tableNames();
            Iterator stream = CollectionTools.sort((Iterator)tables);
            while (stream.hasNext()) {
                this.nameCombo.add((String)stream.next());
            }
        }
        if (this.getSecondaryTable() != null && this.getSecondaryTable().getSpecifiedName() != null) {
            this.nameCombo.setText(this.getSecondaryTable().getSpecifiedName());
        }
    }

    protected void repopulateNameCombo() {
        String nameText = this.nameCombo.getText();
        this.nameCombo.removeAll();
        Schema schema = null;
        schema = this.schemaCombo.getSelectionIndex() == 0 ? this.getDefaultTableSchema() : (this.schemaCombo.getText() != null ? this.getTableSchema(this.schemaCombo.getText()) : this.getTableSchema());
        if (schema != null) {
            Iterator tables = schema.tableNames();
            Iterator stream = CollectionTools.sort((Iterator)tables);
            while (stream.hasNext()) {
                this.nameCombo.add((String)stream.next());
            }
        }
        this.nameCombo.setText(nameText);
    }

    protected void populateSchemaCombo() {
        Database database;
        String defaultSchema = this.getSecondaryTable() != null ? this.getSecondaryTable().getDefaultSchema() : this.defaultSchema;
        if (defaultSchema != null) {
            this.schemaCombo.add(NLS.bind((String)JptUiMappingsMessages.SecondaryTableDialog_defaultSchema, (Object)defaultSchema));
        }
        if ((database = this.getDatabase()) != null) {
            Iterator schemata = database.schemaNames();
            Iterator stream = CollectionTools.sort((Iterator)schemata);
            while (stream.hasNext()) {
                this.schemaCombo.add((String)stream.next());
            }
        }
        if (this.getSecondaryTable() != null) {
            if (this.getSecondaryTable().getSpecifiedSchema() != null) {
                this.schemaCombo.setText(this.getSecondaryTable().getSpecifiedSchema());
            } else {
                this.schemaCombo.select(0);
            }
        } else {
            this.schemaCombo.select(0);
        }
    }

    protected void populateCatalogCombo() {
        Database database;
        String defaultCatalog = this.getSecondaryTable() != null ? this.getSecondaryTable().getDefaultCatalog() : this.defaultCatalog;
        if (defaultCatalog != null) {
            this.catalogCombo.add(NLS.bind((String)JptUiMappingsMessages.SecondaryTableDialog_defaultCatalog, (Object)defaultCatalog));
        }
        if ((database = this.getDatabase()) != null) {
            Iterator catalogs = database.catalogNames();
            Iterator stream = CollectionTools.sort((Iterator)catalogs);
            while (stream.hasNext()) {
                this.catalogCombo.add((String)stream.next());
            }
        }
        if (this.getSecondaryTable() != null) {
            if (this.getSecondaryTable().getSpecifiedCatalog() != null) {
                this.catalogCombo.setText(this.getSecondaryTable().getSpecifiedCatalog());
            } else {
                this.catalogCombo.select(0);
            }
        } else {
            this.catalogCombo.select(0);
        }
    }

    protected Combo getNameCombo() {
        return this.nameCombo;
    }

    protected Combo getSchemaCombo() {
        return this.schemaCombo;
    }

    protected Combo getCatalogCombo() {
        return this.catalogCombo;
    }

    protected SecondaryTable getSecondaryTable() {
        return this.secondaryTable;
    }

    public String getSelectedName() {
        return this.selectedName;
    }

    public String getSelectedCatalog() {
        return this.selectedCatalog;
    }

    public String getSelectedSchema() {
        return this.selectedSchema;
    }

    public boolean isDefaultSchemaSelected() {
        return this.defaultSchemaSelected;
    }

    public boolean isDefaultCatalogSelected() {
        return this.defaultCatalogSelected;
    }

    public boolean close() {
        this.selectedName = this.nameCombo.getText();
        this.selectedSchema = this.schemaCombo.getText();
        if (this.selectedSchema.equals("")) {
            this.selectedSchema = null;
        }
        this.selectedCatalog = this.catalogCombo.getText();
        if (this.selectedCatalog.equals("")) {
            this.selectedCatalog = null;
        }
        this.defaultSchemaSelected = this.schemaCombo.getSelectionIndex() == 0;
        this.defaultCatalogSelected = this.catalogCombo.getSelectionIndex() == 0;
        return super.close();
    }
}

