/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.IJsGlobalScopeContainerInitializerExtension;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.JSDScopeUiUtil;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AccessRulesLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ClasspathAttributeConfigurationDescriptors;
import org.eclipse.wst.jsdt.ui.ISharedImages;
import org.eclipse.wst.jsdt.ui.JavaScriptElementImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.wizards.ClasspathAttributeConfiguration;

public class CPListLabelProvider
extends LabelProvider {
    private String fNewLabel = NewWizardMessages.CPListLabelProvider_new;
    private String fClassLabel = NewWizardMessages.CPListLabelProvider_classcontainer;
    private String fCreateLabel = NewWizardMessages.CPListLabelProvider_willbecreated;
    private ImageDescriptorRegistry fRegistry = JavaScriptPlugin.getImageDescriptorRegistry();
    private ISharedImages fSharedImages = JavaScriptUI.getSharedImages();
    private ImageDescriptor fProjectImage;
    private ClasspathAttributeConfigurationDescriptors fAttributeDescriptors;

    public CPListLabelProvider() {
        IWorkbench workbench = JavaScriptPlugin.getDefault().getWorkbench();
        this.fProjectImage = workbench.getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        this.fAttributeDescriptors = JavaScriptPlugin.getDefault().getClasspathAttributeConfigurationDescriptors();
    }

    public String getText(Object element) {
        if (element instanceof CPListElement) {
            return this.getCPListElementText((CPListElement)element);
        }
        if (element instanceof CPListElementAttribute) {
            CPListElementAttribute attribute = (CPListElementAttribute)element;
            String text = this.getCPListElementAttributeText(attribute);
            return text;
        }
        if (element instanceof CPUserLibraryElement) {
            return this.getCPUserLibraryText((CPUserLibraryElement)element);
        }
        if (element instanceof IAccessRule) {
            IAccessRule rule = (IAccessRule)element;
            return Messages.format(NewWizardMessages.CPListLabelProvider_access_rules_label, new String[]{AccessRulesLabelProvider.getResolutionLabel(rule.getKind()), rule.getPattern().toString()});
        }
        return super.getText(element);
    }

    public String getCPUserLibraryText(CPUserLibraryElement element) {
        String name = element.getName();
        if (element.isSystemLibrary()) {
            name = Messages.format(NewWizardMessages.CPListLabelProvider_systemlibrary, name);
        }
        return name;
    }

    public String getCPListElementAttributeText(CPListElementAttribute attrib) {
        String notAvailable = NewWizardMessages.CPListLabelProvider_none;
        String key = attrib.getKey();
        if (key.equals("sourcepath")) {
            IPath path = (IPath)attrib.getValue();
            String arg = path != null && !path.isEmpty() ? (attrib.getParent().getEntryKind() == 4 ? this.getVariableString(path) : this.getPathString(path, path.getDevice() != null)) : notAvailable;
            return Messages.format(NewWizardMessages.CPListLabelProvider_source_attachment_label, new String[]{arg});
        }
        if (key.equals("output")) {
            String arg = null;
            IPath path = (IPath)attrib.getValue();
            arg = path != null ? path.makeRelative().toString() : NewWizardMessages.CPListLabelProvider_default_output_folder_label;
            return Messages.format(NewWizardMessages.CPListLabelProvider_output_folder_label, new String[]{arg});
        }
        if (key.equals("exclusion")) {
            String arg = null;
            IPath[] patterns = (IPath[])attrib.getValue();
            if (patterns != null && patterns.length > 0) {
                int patternsCount = 0;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < patterns.length) {
                    String pattern = patterns[i].toString();
                    if (pattern.length() > 0) {
                        if (patternsCount > 0) {
                            buf.append(NewWizardMessages.CPListLabelProvider_exclusion_filter_separator);
                        }
                        buf.append(pattern);
                        ++patternsCount;
                    }
                    ++i;
                }
                arg = patternsCount > 0 ? buf.toString() : notAvailable;
            } else {
                arg = notAvailable;
            }
            return Messages.format(NewWizardMessages.CPListLabelProvider_exclusion_filter_label, new String[]{arg});
        }
        if (key.equals("inclusion")) {
            String arg = null;
            IPath[] patterns = (IPath[])attrib.getValue();
            if (patterns != null && patterns.length > 0) {
                int patternsCount = 0;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < patterns.length) {
                    String pattern = patterns[i].toString();
                    if (pattern.length() > 0) {
                        if (patternsCount > 0) {
                            buf.append(NewWizardMessages.CPListLabelProvider_inclusion_filter_separator);
                        }
                        buf.append(pattern);
                        ++patternsCount;
                    }
                    ++i;
                }
                arg = patternsCount > 0 ? buf.toString() : notAvailable;
            } else {
                arg = NewWizardMessages.CPListLabelProvider_all;
            }
            return Messages.format(NewWizardMessages.CPListLabelProvider_inclusion_filter_label, new String[]{arg});
        }
        if (key.equals("accessrules")) {
            IAccessRule[] rules = (IAccessRule[])attrib.getValue();
            int nRules = rules != null ? rules.length : 0;
            int parentKind = attrib.getParent().getEntryKind();
            if (parentKind == 2) {
                Boolean combined = (Boolean)attrib.getParent().getAttribute("combineaccessrules");
                if (nRules > 0) {
                    if (combined.booleanValue()) {
                        return Messages.format(NewWizardMessages.CPListLabelProvider_project_access_rules_combined, String.valueOf(nRules));
                    }
                    return Messages.format(NewWizardMessages.CPListLabelProvider_project_access_rules_not_combined, String.valueOf(nRules));
                }
                return NewWizardMessages.CPListLabelProvider_project_access_rules_no_rules;
            }
            if (parentKind == 5) {
                if (nRules > 0) {
                    return Messages.format(NewWizardMessages.CPListLabelProvider_container_access_rules, String.valueOf(nRules));
                }
                return NewWizardMessages.CPListLabelProvider_container_no_access_rules;
            }
            if (nRules > 0) {
                return Messages.format(NewWizardMessages.CPListLabelProvider_access_rules_enabled, String.valueOf(nRules));
            }
            return NewWizardMessages.CPListLabelProvider_access_rules_disabled;
        }
        ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(key);
        if (config != null) {
            ClasspathAttributeConfiguration.ClasspathAttributeAccess access = attrib.getClasspathAttributeAccess();
            String nameLabel = config.getNameLabel(access);
            String valueLabel = config.getValueLabel(access);
            return Messages.format(NewWizardMessages.CPListLabelProvider_attribute_label, new String[]{nameLabel, valueLabel});
        }
        String arg = (String)attrib.getValue();
        if (arg == null) {
            arg = notAvailable;
        }
        return Messages.format(NewWizardMessages.CPListLabelProvider_attribute_label, new String[]{key, arg});
    }

    public String getCPListElementText(CPListElement cpentry) {
        IPath path = cpentry.getPath();
        switch (cpentry.getEntryKind()) {
            case 1: {
                String displayText;
                JsGlobalScopeContainerInitializer cpinit = cpentry.getContainerInitializer();
                if (cpinit != null && (displayText = cpinit.getDescription(cpentry.getPath(), cpentry.getJavaProject())) != null) {
                    return displayText;
                }
                IResource resource = cpentry.getResource();
                if (resource instanceof IContainer) {
                    StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                    IPath linkTarget = cpentry.getLinkTarget();
                    if (linkTarget != null) {
                        buf.append(JavaScriptElementLabels.CONCAT_STRING);
                        buf.append(linkTarget.toOSString());
                    }
                    buf.append(' ');
                    buf.append(this.fClassLabel);
                    if (!resource.exists()) {
                        buf.append(' ');
                        if (cpentry.isMissing()) {
                            buf.append(this.fCreateLabel);
                        } else {
                            buf.append(this.fNewLabel);
                        }
                    }
                    return buf.toString();
                }
                if (ArchiveFileFilter.isArchivePath(path)) {
                    return this.getPathString(path, resource == null);
                }
                return path.makeRelative().toString();
            }
            case 4: {
                return this.getVariableString(path);
            }
            case 2: {
                return path.lastSegment();
            }
            case 5: {
                try {
                    IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer((IPath)path, (IJavaScriptProject)cpentry.getJavaProject());
                    if (container != null) {
                        return container.getDescription();
                    }
                    JsGlobalScopeContainerInitializer initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer((String)path.segment(0));
                    if (initializer != null) {
                        String description = initializer.getDescription(path, cpentry.getJavaProject());
                        return Messages.format(NewWizardMessages.CPListLabelProvider_unbound_library, description);
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
                return path.toString();
            }
            case 3: {
                IResource resource;
                StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                IPath linkTarget = cpentry.getLinkTarget();
                if (linkTarget != null) {
                    buf.append(JavaScriptElementLabels.CONCAT_STRING);
                    buf.append(linkTarget.toOSString());
                }
                if ((resource = cpentry.getResource()) != null && !resource.exists()) {
                    buf.append(' ');
                    if (cpentry.isMissing()) {
                        buf.append(this.fCreateLabel);
                    } else {
                        buf.append(this.fNewLabel);
                    }
                } else if (cpentry.getOrginalPath() == null) {
                    buf.append(' ');
                    buf.append(this.fNewLabel);
                }
                return buf.toString();
            }
        }
        return NewWizardMessages.CPListLabelProvider_unknown_element_label;
    }

    private String getPathString(IPath path, boolean isExternal) {
        if (ArchiveFileFilter.isArchivePath(path)) {
            IPath appendedPath = path.removeLastSegments(1);
            String appended = isExternal ? appendedPath.toOSString() : appendedPath.makeRelative().toString();
            return Messages.format(NewWizardMessages.CPListLabelProvider_twopart, new String[]{path.lastSegment(), appended});
        }
        return isExternal ? path.toOSString() : path.makeRelative().toString();
    }

    private String getVariableString(IPath path) {
        String name = path.makeRelative().toString();
        IPath entryPath = JavaScriptCore.getIncludepathVariable((String)path.segment(0));
        if (entryPath != null) {
            String appended = entryPath.append(path.removeFirstSegments(1)).toOSString();
            return Messages.format(NewWizardMessages.CPListLabelProvider_twopart, new String[]{name, appended});
        }
        return name;
    }

    private ImageDescriptor getCPListElementBaseImage(CPListElement cpentry) {
        IPath entPath;
        ImageDescriptor image;
        IJsGlobalScopeContainerInitializerExtension init = JSDScopeUiUtil.getContainerUiInitializer(cpentry.getPath());
        if (init != null && (image = init.getImage(entPath = cpentry.getPath(), cpentry.toString(), cpentry.getJavaProject())) != null) {
            return image;
        }
        switch (cpentry.getEntryKind()) {
            case 3: {
                if (cpentry.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.packagefolder_obj.gif");
            }
            case 1: {
                IResource res = cpentry.getResource();
                IPath path = (IPath)cpentry.getAttribute("sourcepath");
                if (res == null) {
                    if (path == null || path.isEmpty()) {
                        return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.jar_l_obj.gif");
                    }
                    return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.jar_lsrc_obj.gif");
                }
                if (res instanceof IFile) {
                    if (path == null || path.isEmpty()) {
                        return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.jar_obj.gif");
                    }
                    return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.jar_src_obj.gif");
                }
                return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.packagefolder_obj.gif");
            }
            case 2: {
                return this.fProjectImage;
            }
            case 4: {
                ImageDescriptor variableImage = this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.envvar_obj.gif");
                if (cpentry.isDeprecated()) {
                    return new JavaScriptElementImageDescriptor(variableImage, 1024, JavaElementImageProvider.SMALL_SIZE);
                }
                return variableImage;
            }
            case 5: {
                return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.library_obj.gif");
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof CPListElement) {
            CPListElement cpentry = (CPListElement)element;
            Object imageDescriptor = this.getCPListElementBaseImage(cpentry);
            if (imageDescriptor != null) {
                if (cpentry.isMissing()) {
                    imageDescriptor = new JavaScriptElementImageDescriptor((ImageDescriptor)imageDescriptor, 32, JavaElementImageProvider.SMALL_SIZE);
                }
                return this.fRegistry.get((ImageDescriptor)imageDescriptor);
            }
        } else {
            if (element instanceof CPListElementAttribute) {
                CPListElementAttribute attribute = (CPListElementAttribute)element;
                String key = attribute.getKey();
                if (key.equals("sourcepath")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_SOURCE_ATTACH_ATTRIB);
                }
                if (key.equals("output")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_OUTPUT_FOLDER_ATTRIB);
                }
                if (key.equals("exclusion")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_EXCLUSION_FILTER_ATTRIB);
                }
                if (key.equals("inclusion")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_INCLUSION_FILTER_ATTRIB);
                }
                if (key.equals("accessrules")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_ACCESSRULES_ATTRIB);
                }
                ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(key);
                if (config != null) {
                    return this.fRegistry.get(config.getImageDescriptor(attribute.getClasspathAttributeAccess()));
                }
                return this.fSharedImages.getImage("org.eclipse.wst.jsdt.ui.envvar_obj.gif");
            }
            if (element instanceof CPUserLibraryElement) {
                return this.fSharedImages.getImage("org.eclipse.wst.jsdt.ui.library_obj.gif");
            }
            if (element instanceof IAccessRule) {
                IAccessRule rule = (IAccessRule)element;
                return AccessRulesLabelProvider.getResolutionImage(rule.getKind());
            }
        }
        return null;
    }
}

