/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.internal.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Util {
    Util() {
    }

    static ISymbol call(String methodName, EList methodArguments, String symbolName, ITypeDescriptor typeDesc) {
        JDTBeanIntrospector introspector;
        IMethod callMethod;
        ISymbol result = typeDesc.calculateSyntheticCall(methodName, methodArguments, symbolName);
        IType type = typeDesc.resolveType(typeDesc.getTypeSignature());
        if (type != null && result == null && (callMethod = Util.matchMethod(methodName, (List)methodArguments, (introspector = new JDTBeanIntrospector(type)).getAllMethods(), (List)typeDesc.getTypeParameterSignatures())) != null) {
            try {
                String retTypeSignature = callMethod.getReturnType();
                if (Signature.getTypeSignatureKind((String)retTypeSignature) == 3) {
                    if ((retTypeSignature = TypeUtil.matchTypeParameterToArgument(type, retTypeSignature, (List<String>)typeDesc.getTypeParameterSignatures())) == null) {
                        retTypeSignature = "Ljava.lang.Object;";
                    }
                } else {
                    retTypeSignature = TypeUtil.resolveTypeSignature(type, callMethod.getReturnType(), false);
                }
                IPropertySymbol propSymbol = SymbolFactory.eINSTANCE.createIPropertySymbol();
                propSymbol.setName(symbolName);
                propSymbol.setReadable(true);
                IJavaTypeDescriptor2 newTypeDesc = null;
                newTypeDesc = retTypeSignature.equals("Ljava.lang.Object;") ? SymbolFactory.eINSTANCE.createIBoundedJavaTypeDescriptor() : SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
                newTypeDesc.setArrayCount(Signature.getArrayCount((String)retTypeSignature));
                newTypeDesc.setType(typeDesc.resolveType(retTypeSignature));
                newTypeDesc.setTypeSignatureDelegate(retTypeSignature);
                propSymbol.setTypeDescriptor(newTypeDesc);
                result = propSymbol;
            }
            catch (JavaModelException e) {
                JSFCommonPlugin.log(e);
            }
        }
        return result;
    }

    static IMethod matchMethod(String methodName, List methodArguments, IMethod[] allMethods, List typeParameterSignatures) {
        IMethod matchedMethod = null;
        int i = 0;
        while (i < allMethods.length) {
            IMethod method = allMethods[i];
            if (method.getParameterTypes().length == methodArguments.size() && method.getElementName().equals(methodName)) {
                List<String> methods = Util.resolveMethodParameters(method, typeParameterSignatures);
                boolean isMatched = true;
                int j = 0;
                while (j < methods.size()) {
                    ValueType valueType = (ValueType)methodArguments.get(j);
                    if (!(methods.get(j).equals(valueType.getSignature()) || methods.get(j).equals("Ljava.lang.Object;") && Signature.getTypeSignatureKind((String)valueType.getSignature()) == 1)) {
                        isMatched = false;
                        break;
                    }
                    ++j;
                }
                if (isMatched) {
                    return method;
                }
            }
            ++i;
        }
        return matchedMethod;
    }

    static List<String> resolveMethodParameters(IMethod method, List typeParametersSignatures) {
        String[] parameterTypes;
        ArrayList<String> resolved = new ArrayList<String>();
        String[] stringArray = parameterTypes = method.getParameterTypes();
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            parameter = TypeUtil.resolveTypeSignature(method.getDeclaringType(), parameter, false);
            if (Signature.getTypeSignatureKind((String)parameter) == 3) {
                parameter = TypeUtil.matchTypeParameterToArgument(method.getDeclaringType(), parameter, typeParametersSignatures);
            }
            if (parameter == null) {
                parameter = "Ljava.lang.Object;";
            }
            resolved.add(parameter);
            ++n2;
        }
        return resolved;
    }
}

