/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.server.core.internal.ServerPlugin;

public class ServerPreferences {
    private static final String PREF_AUTO_PUBLISH = "auto-publish";
    private static final String PREF_MODULE_START_TIMEOUT = "module-start-timeout";
    private Preferences preferences = ServerPlugin.getInstance().getPluginPreferences();
    protected static ServerPreferences instance;

    private ServerPreferences() {
    }

    public static ServerPreferences getInstance() {
        if (instance == null) {
            instance = new ServerPreferences();
        }
        return instance;
    }

    public boolean isAutoPublishing() {
        return this.preferences.getBoolean(PREF_AUTO_PUBLISH);
    }

    public boolean isDefaultAutoPublishing() {
        return true;
    }

    public void setAutoRestarting(boolean value) {
    }

    public void setAutoPublishing(boolean value) {
        this.preferences.setValue(PREF_AUTO_PUBLISH, value);
        ServerPlugin.getInstance().savePluginPreferences();
    }

    public int getModuleStartTimeout() {
        return this.preferences.getInt(PREF_MODULE_START_TIMEOUT);
    }

    public void setDefaults() {
        this.preferences.setDefault(PREF_AUTO_PUBLISH, this.isDefaultAutoPublishing());
        this.preferences.setDefault(PREF_MODULE_START_TIMEOUT, 300001);
        boolean save = false;
        if (this.preferences.isDefault(PREF_MODULE_START_TIMEOUT)) {
            this.preferences.setValue(PREF_MODULE_START_TIMEOUT, 300000);
            save = true;
        }
        if (save) {
            ServerPlugin.getInstance().savePluginPreferences();
        }
    }
}

