/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.events.internal;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.runtime.events.IRuntimeLifecycleEvent;
import org.eclipse.wst.common.project.facet.core.runtime.events.IRuntimeLifecycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeLifecycleListenerRegistry {
    private final Map<IRuntimeLifecycleEvent.Type, Set<IRuntimeLifecycleListener>> listeners = new EnumMap<IRuntimeLifecycleEvent.Type, Set<IRuntimeLifecycleListener>>(IRuntimeLifecycleEvent.Type.class);

    public RuntimeLifecycleListenerRegistry() {
        IRuntimeLifecycleEvent.Type[] typeArray = IRuntimeLifecycleEvent.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeLifecycleEvent.Type t = typeArray[n2];
            this.listeners.put(t, new CopyOnWriteArraySet());
            ++n2;
        }
    }

    public void addListener(IRuntimeLifecycleListener listener, IRuntimeLifecycleEvent.Type ... types) {
        if (listener == null || types == null) {
            throw new IllegalArgumentException();
        }
        IRuntimeLifecycleEvent.Type[] typeArray = types.length > 0 ? types : IRuntimeLifecycleEvent.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeLifecycleEvent.Type type = typeArray[n2];
            this.listeners.get((Object)type).add(listener);
            ++n2;
        }
    }

    public void removeListener(IRuntimeLifecycleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        for (Set<IRuntimeLifecycleListener> listeners : this.listeners.values()) {
            listeners.remove(listener);
        }
    }

    public void notifyListeners(IRuntimeLifecycleEvent event) {
        for (IRuntimeLifecycleListener listener : this.listeners.get((Object)event.getType())) {
            try {
                listener.handleEvent(event);
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
            }
        }
    }

    public Set<IRuntimeLifecycleListener> getListeners(IRuntimeLifecycleEvent.Type eventType) {
        return this.listeners.get((Object)eventType);
    }
}

