/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindImplementorsAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class FindImplementorsInWorkingSetAction
extends FindImplementorsAction {
    private IWorkingSet[] fWorkingSets;

    public FindImplementorsInWorkingSetAction(IWorkbenchSite site) {
        super(site);
    }

    public FindImplementorsInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        this(site);
        this.fWorkingSets = workingSets;
    }

    public FindImplementorsInWorkingSetAction(JavaEditor editor) {
        super(editor);
    }

    public FindImplementorsInWorkingSetAction(JavaEditor editor, IWorkingSet[] workingSets) {
        this(editor);
        this.fWorkingSets = workingSets;
    }

    void init() {
        this.setText(SearchMessages.Search_FindImplementorsInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindImplementorsInWorkingSetAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_DECL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_implementors_in_working_set_action");
    }

    QuerySpecification createQuery(IJavaScriptElement element) throws JavaScriptModelException, InterruptedException {
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        IWorkingSet[] workingSets = this.fWorkingSets;
        if (this.fWorkingSets == null && (workingSets = factory.queryWorkingSets()) == null) {
            return super.createQuery(element);
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        IJavaScriptSearchScope scope = factory.createJavaSearchScope(workingSets, true);
        String description = factory.getWorkingSetScopeDescription(workingSets, true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

