/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.operations.CreateJavaEEArtifactTemplateModel;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.WTPJETEmitter;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.osgi.framework.Bundle;

public abstract class NewJavaEEArtifactClassOperation
extends AbstractDataModelOperation {
    protected static final String DOT_JAVA = ".java";
    protected static final String GENERATE_METHOD = "generate";

    public NewJavaEEArtifactClassOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.doExecute(monitor, info);
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.createJavaSourceFolder();
        IPackageFragment pack = this.createJavaPackage();
        try {
            this.generateUsingTemplates(monitor, pack);
        }
        catch (Exception e) {
            return J2EEPlugin.createStatus(4, e.getMessage(), e);
        }
        return OK_STATUS;
    }

    protected abstract void generateUsingTemplates(IProgressMonitor var1, IPackageFragment var2) throws WFTWrappedException, CoreException;

    protected final IPackageFragment createJavaPackage() {
        String packageName = this.model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        IPackageFragmentRoot packRoot = (IPackageFragmentRoot)this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        IPackageFragment pack = packRoot.getPackageFragment(packageName);
        if (pack == null) {
            pack = packRoot.getPackageFragment("");
        }
        if (!pack.exists()) {
            String packName = pack.getElementName();
            try {
                pack = packRoot.createPackageFragment(packName, true, null);
            }
            catch (JavaModelException e) {
                J2EEPlugin.logError((CoreException)((Object)e));
            }
        }
        return pack;
    }

    protected String generateTemplateSource(WTPPlugin plugin, CreateJavaEEArtifactTemplateModel templateModel, String templateFile, Object templateImpl, IProgressMonitor monitor) throws JETException {
        Preferences preferences = J2EEPlugin.getDefault().getPluginPreferences();
        boolean dynamicTranslation = preferences.getBoolean("dynamicTranslationOfJetTemplates");
        if (dynamicTranslation) {
            return this.generateTemplateSource(plugin, templateModel, templateFile, monitor);
        }
        return this.generateTemplateSource(templateModel, templateImpl);
    }

    protected String generateTemplateSource(CreateJavaEEArtifactTemplateModel templateModel, Object templateImpl) throws JETException {
        try {
            Method method = templateImpl.getClass().getMethod(GENERATE_METHOD, Object.class);
            return (String)method.invoke(templateImpl, templateModel);
        }
        catch (SecurityException e) {
            throw new JETException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new JETException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new JETException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JETException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JETException((Throwable)e);
        }
    }

    protected String generateTemplateSource(WTPPlugin plugin, CreateJavaEEArtifactTemplateModel templateModel, String templateFile, IProgressMonitor monitor) throws JETException {
        URL templateURL = FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path(templateFile), null);
        this.cleanUpOldEmitterProject();
        WTPJETEmitter emitter = new WTPJETEmitter(templateURL.toString(), ((Object)((Object)this)).getClass().getClassLoader());
        emitter.setIntelligentLinkingEnabled(true);
        emitter.addVariable(J2EEPlugin.getPlugin().getPluginID(), J2EEPlugin.getPlugin().getPluginID());
        emitter.addVariable(plugin.getPluginID(), plugin.getPluginID());
        return emitter.generate(monitor, new Object[]{templateModel});
    }

    protected void cleanUpOldEmitterProject() {
        IProject project = ProjectUtilities.getProject((String)".JETEmitters");
        if (project == null || !project.exists()) {
            return;
        }
        try {
            IMarker[] markers = project.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
            int i = 0;
            int l = markers.length;
            while (i < l) {
                if ((Integer)markers[i].getAttribute("severity") == 2) {
                    project.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            J2EEPlugin.logError(e);
        }
    }

    protected final IFolder createJavaSourceFolder() {
        IFolder folder = this.getSourceFolder();
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                J2EEPlugin.logError(e);
            }
        }
        return folder;
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }

    protected IFolder getSourceFolder() {
        String folderFullPath = this.model.getStringProperty("NewJavaClassDataModel.SOURCE_FOLDER");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getFolder((IPath)new Path(folderFullPath));
    }
}

