/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.JSPType;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFUtils11
extends JSFUtils {
    public static WebArtifactEdit getWebArtifactEditForWrite(IProject project) {
        return WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
    }

    public static WebArtifactEdit getWebArtifactEditForRead(IProject project) {
        return WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Servlet findJSFServlet(Object webApp) {
        Iterator it = null;
        if (webApp == null) {
            return null;
        }
        if (webApp instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            it = ((org.eclipse.jst.j2ee.webapplication.WebApp)webApp).getServlets().iterator();
        } else {
            if (!(webApp instanceof WebApp)) {
                return null;
            }
            it = ((WebApp)webApp).getServlets().iterator();
        }
        while (it.hasNext()) {
            Servlet servlet = (Servlet)it.next();
            if (servlet == null || servlet.getWebType() == null || !(servlet.getWebType().isServletType() ? ((ServletType)servlet.getWebType()).getClassName() != null && ((ServletType)servlet.getWebType()).getClassName().trim().equals("javax.faces.webapp.FacesServlet") : servlet.getWebType().isJspType() && ((JSPType)servlet.getWebType()).getJspFile() != null && ((JSPType)servlet.getWebType()).getJspFile().trim().equals("javax.faces.webapp.FacesServlet"))) continue;
            return servlet;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createConfigFile(String jsfVersion, IPath configPath) {
        FileOutputStream os = null;
        PrintWriter pw = null;
        String QUOTE = new String(new char[]{'\"'});
        try {
            try {
                IPath dirPath = configPath.removeLastSegments(1);
                dirPath.toFile().mkdirs();
                File file = configPath.toFile();
                file.createNewFile();
                os = new FileOutputStream(file);
                pw = new PrintWriter(os);
                pw.write("<?xml version=" + QUOTE + "1.0" + QUOTE + " encoding=" + QUOTE + "UTF-8" + QUOTE + "?>\n\n");
                if (jsfVersion.equals("1.1")) {
                    pw.write("<!DOCTYPE faces-config PUBLIC\n");
                    pw.write("    " + QUOTE + "-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.1//EN" + QUOTE + "\n");
                    pw.write("    " + QUOTE + "http://java.sun.com/dtd/web-facesconfig_1_1.dtd" + QUOTE + ">\n\n");
                    pw.write("<faces-config>\n\n");
                    pw.write("</faces-config>\n");
                }
                pw.close();
                pw = null;
                return;
            }
            catch (FileNotFoundException e) {
                JSFCorePlugin.log(4, Messages.JSFUtils_ErrorCreatingConfigFile, e);
                if (pw != null) {
                    pw.close();
                }
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e2) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e2);
                }
                return;
            }
            catch (IOException e) {
                JSFCorePlugin.log(4, Messages.JSFUtils_ErrorCreatingConfigFile, e);
                if (pw != null) {
                    pw.close();
                }
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e3) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e3);
                }
                return;
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e);
                }
            }
        }
    }

    public static Servlet createOrUpdateServletRef(org.eclipse.jst.j2ee.webapplication.WebApp webApp, IDataModel config, Servlet servlet) {
        String displayName = JSFUtils11.getDisplayName(config);
        String className = JSFUtils11.getServletClassname(config);
        if (servlet == null) {
            servlet = WebapplicationFactory.eINSTANCE.createServlet();
            servlet.setServletName(displayName);
            ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
            servletType.setClassName(className);
            servlet.setWebType((WebType)servletType);
            servlet.setLoadOnStartup(Integer.valueOf(1));
            webApp.getServlets().add((Object)servlet);
        } else {
            JSFUtils11.updateServletMappings(webApp, servlet, servlet.getServletName().trim(), displayName);
            servlet.setServletName(displayName);
            servlet.setLoadOnStartup(Integer.valueOf(1));
        }
        return servlet;
    }

    private static void updateServletMappings(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet, String servletName, String newServletName) {
        List<ServletMapping> mappings = JSFUtils11.findServletMappings(webApp, servlet, servletName);
        for (ServletMapping map : mappings) {
            map.setName(newServletName);
        }
    }

    private static List<ServletMapping> findServletMappings(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet, String servletName) {
        ArrayList<ServletMapping> mappings = new ArrayList<ServletMapping>();
        EList allMappings = webApp.getServletMappings();
        int i = allMappings.size() - 1;
        while (i >= 0) {
            ServletMapping mapping = (ServletMapping)allMappings.get(i);
            if (mapping != null && mapping.getServlet() != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName)) {
                mappings.add(mapping);
            }
            --i;
        }
        return mappings;
    }

    public static boolean isWebApp25(Object webApp) {
        return webApp instanceof WebApp;
    }

    public static void setUpURLMappings(org.eclipse.jst.j2ee.webapplication.WebApp webApp, List urlMappingList, Servlet servlet) {
        for (String pattern : urlMappingList) {
            if (JSFUtils11.doesServletMappingExist(webApp, servlet, pattern)) continue;
            ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
            mapping.setServlet(servlet);
            mapping.setName(servlet.getServletName());
            mapping.setUrlPattern(pattern);
            webApp.getServletMappings().add((Object)mapping);
        }
    }

    private static boolean doesServletMappingExist(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet, String pattern) {
        EList mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServlet() != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName) && mapping.getUrlPattern() != null && mapping.getUrlPattern().trim().equals(pattern)) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    public static void removeURLMappings(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet) {
        EList mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServlet() != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName)) {
                    mappings.remove(mapping);
                }
                --i;
            }
        }
    }

    public static void setupConfigFileContextParamForV2_3(org.eclipse.jst.j2ee.webapplication.WebApp webApp, IDataModel config) {
        ContextParam cp2 = null;
        ContextParam foundCP = null;
        boolean found = false;
        if (!config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH").equals("/WEB-INF/faces-config.xml")) {
            for (ContextParam cp2 : webApp.getContexts()) {
                if (cp2 == null || cp2.getParamName() == null || !cp2.getParamName().equals("javax.faces.CONFIG_FILES")) continue;
                foundCP = cp2;
                found = true;
            }
            if (!found) {
                cp2 = WebapplicationFactory.eINSTANCE.createContextParam();
                cp2.setParamName("javax.faces.CONFIG_FILES");
                cp2.setParamValue(config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
                webApp.getContexts().add((Object)cp2);
            } else {
                cp2 = foundCP;
                if (cp2.getParamValue().indexOf(config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) < 0) {
                    String curVal = cp2.getParamValue();
                    String val = config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
                    if (curVal != null && !"".equals(curVal.trim())) {
                        val = String.valueOf(curVal) + ",\n" + val;
                    }
                    cp2.setParamValue(val);
                }
            }
        }
    }

    public static void setupConfigFileContextParamForV2_4(org.eclipse.jst.j2ee.webapplication.WebApp webApp, IDataModel config) {
        ParamValue foundCP = null;
        ParamValue cp2 = null;
        boolean found = false;
        if (!config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH").equals("/WEB-INF/faces-config.xml")) {
            for (ParamValue cp2 : webApp.getContextParams()) {
                if (cp2 == null || cp2.getName() == null || !cp2.getName().trim().equals("javax.faces.CONFIG_FILES")) continue;
                foundCP = cp2;
                found = true;
            }
            if (!found) {
                ParamValue pv = CommonFactory.eINSTANCE.createParamValue();
                pv.setName("javax.faces.CONFIG_FILES");
                pv.setValue(config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
                webApp.getContextParams().add((Object)pv);
            } else {
                cp2 = foundCP;
                if (cp2.getValue().indexOf(config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) < 0) {
                    String curVal = cp2.getValue();
                    String val = config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
                    if (curVal != null && !"".equals(curVal.trim())) {
                        val = String.valueOf(curVal) + ",\n" + val;
                    }
                    cp2.setValue(val);
                }
            }
        }
    }

    public static boolean isWebApp24(Object webAppObj) {
        return webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp && ((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj).getVersionID() == 24;
    }

    public static boolean isWebApp23(Object webAppObj) {
        return webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp && ((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj).getVersionID() == 23;
    }

    public static String getDefaultSuffix(org.eclipse.jst.j2ee.webapplication.WebApp webApp) {
        String defaultSuffix = "jsp";
        for (ContextParam cp : webApp.getContexts()) {
            if (cp == null || cp.getParamName() == null || !cp.getParamName().trim().equals("javax.faces.DEFAULT_SUFFIX")) continue;
            String defSuffix = cp.getParamValue();
            if (defSuffix.startsWith(".")) {
                defSuffix = defSuffix.substring(1);
            }
            return defSuffix;
        }
        return defaultSuffix;
    }

    public static String getPrefixMapping(ServletMapping map) {
        String ext;
        Path extPath = new Path(map.getUrlPattern());
        if (extPath != null && (ext = extPath.getFileExtension()) == null) {
            String lastSeg = extPath.lastSegment();
            if (lastSeg != null && lastSeg.equals("*")) {
                return extPath.removeLastSegments(1).toString();
            }
            return extPath.toString();
        }
        return null;
    }

    public static String getFileExtensionFromMap(ServletMapping map) {
        String ext;
        Path extPath = new Path(map.getUrlPattern());
        if (extPath != null && (ext = extPath.getFileExtension()) != null && !ext.equals("")) {
            return ext;
        }
        return null;
    }
}

