/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.jface;

import org.eclipse.jpt.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemLabelProvider
implements ItemLabelProvider {
    private DelegatingContentAndLabelProvider labelProvider;
    private Model model;
    private PropertyValueModel<String> textModel;
    private PropertyValueModel<Image> imageModel;
    private PropertyChangeListener labelChangeListener;

    protected AbstractItemLabelProvider(Model model, DelegatingContentAndLabelProvider labelProvider) {
        this.model = model;
        this.labelProvider = labelProvider;
        this.labelChangeListener = this.buildLabelChangeListener();
    }

    protected PropertyChangeListener buildLabelChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                AbstractItemLabelProvider.this.labelProvider().updateLabel(AbstractItemLabelProvider.this.model());
            }
        };
    }

    protected PropertyValueModel<String> textModel() {
        if (this.textModel == null) {
            this.textModel = this.buildTextModel();
            this.engageTextModel();
        }
        return this.textModel;
    }

    protected abstract PropertyValueModel<String> buildTextModel();

    protected void engageTextModel() {
        this.textModel.addPropertyChangeListener("value", this.labelChangeListener);
    }

    protected void disengageTextModel() {
        if (this.textModel != null) {
            this.textModel.removePropertyChangeListener("value", this.labelChangeListener);
        }
    }

    protected PropertyValueModel<Image> imageModel() {
        if (this.imageModel == null) {
            this.imageModel = this.buildImageModel();
            this.engageImageModel();
        }
        return this.imageModel;
    }

    protected abstract PropertyValueModel<Image> buildImageModel();

    protected void engageImageModel() {
        this.imageModel.addPropertyChangeListener("value", this.labelChangeListener);
    }

    protected void disengageImageModel() {
        if (this.imageModel != null) {
            this.imageModel.removePropertyChangeListener("value", this.labelChangeListener);
        }
    }

    public Model model() {
        return this.model;
    }

    public DelegatingContentAndLabelProvider labelProvider() {
        return this.labelProvider;
    }

    @Override
    public String getText() {
        return (String)this.textModel().getValue();
    }

    @Override
    public Image getImage() {
        return (Image)this.imageModel().getValue();
    }

    @Override
    public void dispose() {
        this.disengageTextModel();
        this.disengageImageModel();
    }
}

