/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.infer.IInferenceFile;
import org.eclipse.wst.jsdt.core.infer.InferrenceManager;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.core.infer.RefactoringSupport;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RefactoringActions;

public final class RefactoringAvailabilityTester {
    public static IType getDeclaringType(IJavaScriptElement element) {
        if (element == null) {
            return null;
        }
        if (!(element instanceof IType)) {
            element = element.getAncestor(7);
        }
        return (IType)element;
    }

    public static IJavaScriptElement[] getJavaElements(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        int index = 0;
        while (index < elements.length) {
            if (elements[index] instanceof IJavaScriptElement) {
                result.add(elements[index]);
            }
            ++index;
        }
        return result.toArray(new IJavaScriptElement[result.size()]);
    }

    public static IMember[] getPullUpMembers(IType type) throws JavaScriptModelException {
        ArrayList<IField> list = new ArrayList<IField>(3);
        if (type.exists()) {
            IField[] members = type.getFields();
            int index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
            members = type.getFunctions();
            index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
            members = type.getTypes();
            index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
        }
        return list.toArray(new IMember[list.size()]);
    }

    public static IMember[] getPushDownMembers(IType type) throws JavaScriptModelException {
        ArrayList<IField> list = new ArrayList<IField>(3);
        if (type.exists()) {
            IField[] members = type.getFields();
            int index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPushDownAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
            members = type.getFunctions();
            index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPushDownAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
        }
        return list.toArray(new IMember[list.size()]);
    }

    public static IResource[] getResources(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        int index = 0;
        while (index < elements.length) {
            if (elements[index] instanceof IResource) {
                result.add(elements[index]);
            }
            ++index;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static IType getSingleSelectedType(IStructuredSelection selection) throws JavaScriptModelException {
        IJavaScriptUnit unit;
        Object first = selection.getFirstElement();
        if (first instanceof IType) {
            return (IType)first;
        }
        if (first instanceof IJavaScriptUnit && (unit = (IJavaScriptUnit)first).exists()) {
            return JavaElementUtil.getMainType(unit);
        }
        return null;
    }

    public static IType getTopLevelType(IMember[] members) {
        if (members != null && members.length == 1 && Checks.isTopLevelType(members[0])) {
            return (IType)members[0];
        }
        return null;
    }

    public static boolean isChangeSignatureAvailable(IFunction method) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)method) && (method.getDeclaringType() == null || !Flags.isAnnotation((int)method.getDeclaringType().getFlags()));
    }

    public static boolean isChangeSignatureAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IFunction) {
            IFunction method = (IFunction)selection.getFirstElement();
            return RefactoringAvailabilityTester.isChangeSignatureAvailable(method);
        }
        return false;
    }

    public static boolean isChangeSignatureAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = selection.resolveElementAtOffset();
        if (elements.length == 1 && elements[0] instanceof IFunction) {
            return RefactoringAvailabilityTester.isChangeSignatureAvailable((IFunction)elements[0]);
        }
        IJavaScriptElement element = selection.resolveEnclosingElement();
        return element instanceof IFunction && RefactoringAvailabilityTester.isChangeSignatureAvailable((IFunction)element);
    }

    public static boolean isCommonDeclaringType(IMember[] members) {
        if (members.length == 0) {
            return false;
        }
        IType type = members[0].getDeclaringType();
        if (type == null) {
            return false;
        }
        int index = 0;
        while (index < members.length) {
            if (!type.equals(members[index].getDeclaringType())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isConvertAnonymousAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            return RefactoringAvailabilityTester.isConvertAnonymousAvailable((IType)selection.getFirstElement());
        }
        return false;
    }

    public static boolean isConvertAnonymousAvailable(IType type) throws JavaScriptModelException {
        if (Checks.isAvailable((IJavaScriptElement)type)) {
            IJavaScriptElement element = type.getParent();
            if (element instanceof IField && JdtFlags.isEnum((IMember)element)) {
                return false;
            }
            return type.isAnonymous();
        }
        return false;
    }

    public static boolean isConvertAnonymousAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IType type = RefactoringActions.getEnclosingType(selection);
        if (type != null) {
            return RefactoringAvailabilityTester.isConvertAnonymousAvailable(type);
        }
        return false;
    }

    public static boolean isCopyAvailable(IResource[] resources, IJavaScriptElement[] elements) throws JavaScriptModelException {
        return ReorgPolicyFactory.createCopyPolicy(resources, elements).canEnable();
    }

    public static boolean isDelegateCreationAvailable(IField field) throws JavaScriptModelException {
        return field.exists() && Flags.isStatic((int)field.getFlags()) && Flags.isFinal((int)field.getFlags());
    }

    public static boolean isDeleteAvailable(IJavaScriptElement element) throws JavaScriptModelException {
        IPackageFragmentRoot root;
        if (!element.exists()) {
            return false;
        }
        if (element instanceof IJavaScriptModel || element instanceof IJavaScriptProject) {
            return false;
        }
        if (element.getParent() != null && element.getParent().isReadOnly()) {
            return false;
        }
        if (element instanceof IPackageFragmentRoot && ((root = (IPackageFragmentRoot)element).isExternal() || Checks.isClasspathDelete(root))) {
            return false;
        }
        if (element.getResource() == null && !RefactoringAvailabilityTester.isWorkingCopyElement(element)) {
            return false;
        }
        return !(element instanceof IMember) || !((IMember)element).isBinary();
    }

    public static boolean isDeleteAvailable(IResource resource) {
        if (!resource.exists() || resource.isPhantom()) {
            return false;
        }
        return resource.getType() != 8 && resource.getType() != 4;
    }

    public static boolean isDeleteAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (!selection.isEmpty()) {
            return RefactoringAvailabilityTester.isDeleteAvailable(selection.toArray());
        }
        return false;
    }

    public static boolean isDeleteAvailable(Object[] objects) throws JavaScriptModelException {
        if (objects.length != 0) {
            IJavaScriptElement[] elements;
            IResource[] resources = RefactoringAvailabilityTester.getResources(objects);
            if (objects.length != resources.length + (elements = RefactoringAvailabilityTester.getJavaElements(objects)).length) {
                return false;
            }
            int index = 0;
            while (index < resources.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(resources[index])) {
                    return false;
                }
                ++index;
            }
            index = 0;
            while (index < elements.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(elements[index])) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    public static boolean isExternalizeStringsAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IType type;
            IJavaScriptUnit cu;
            IJavaScriptUnit cu2;
            IJavaScriptElement javaElement;
            Object element = iter.next();
            if (!(element instanceof IJavaScriptElement) || !(javaElement = (IJavaScriptElement)element).exists() || javaElement.isReadOnly()) continue;
            int elementType = javaElement.getElementType();
            if (elementType == 4) {
                return true;
            }
            if (elementType == 3) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
                if (root.isExternal() || ReorgUtils.isClassFolder((IJavaScriptElement)root)) continue;
                return true;
            }
            if (elementType == 2) {
                return true;
            }
            if (!(elementType == 5 ? (cu2 = (IJavaScriptUnit)javaElement).exists() : elementType == 7 && (cu = (type = (IType)element).getJavaScriptUnit()) != null && cu.exists())) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtractConstantAvailable(JavaTextSelection selection) {
        return (selection.resolveInClassInitializer() || selection.resolveInMethodBody() || selection.resolveInVariableInitializer()) && Checks.isExtractableExpression(selection.resolveSelectedNodes(), selection.resolveCoveringNode());
    }

    public static boolean isExtractInterfaceAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() == 1) {
            Object first = selection.getFirstElement();
            if (first instanceof IType) {
                return RefactoringAvailabilityTester.isExtractInterfaceAvailable((IType)first);
            }
            if (first instanceof IJavaScriptUnit) {
                IJavaScriptUnit unit = (IJavaScriptUnit)first;
                return unit.exists() && !unit.isReadOnly();
            }
        }
        return false;
    }

    public static boolean isExtractInterfaceAvailable(IType type) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)type) && !type.isBinary() && !type.isReadOnly() && !type.isAnnotation() && !type.isAnonymous();
    }

    public static boolean isExtractInterfaceAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        return RefactoringAvailabilityTester.isExtractInterfaceAvailable(RefactoringActions.getEnclosingOrPrimaryType(selection));
    }

    public static boolean isExtractMethodAvailable(ASTNode[] nodes) {
        if (nodes != null && nodes.length != 0) {
            if (nodes.length == 1) {
                return nodes[0] instanceof Statement || Checks.isExtractableExpression(nodes[0]);
            }
            int index = 0;
            while (index < nodes.length) {
                if (!(nodes[index] instanceof Statement)) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    public static boolean isExtractMethodAvailable(JavaTextSelection selection) {
        return (selection.resolveInMethodBody() || selection.resolveInClassInitializer()) && RefactoringAvailabilityTester.isExtractMethodAvailable(selection.resolveSelectedNodes());
    }

    public static boolean isExtractSupertypeAvailable(IMember member) throws JavaScriptModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum(member) && type != 7) {
            return false;
        }
        if (!Checks.isAvailable((IJavaScriptElement)member)) {
            return false;
        }
        if (member instanceof IType && !JdtFlags.isStatic(member) && !JdtFlags.isEnum(member) && !JdtFlags.isAnnotation(member)) {
            return false;
        }
        if (member instanceof IFunction) {
            IFunction method = (IFunction)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            IType declaring = method.getDeclaringType();
            if (declaring != null && declaring.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isExtractSupertypeAvailable(IMember[] members) throws JavaScriptModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            if (type != null && !type.isInterface()) {
                return true;
            }
            int index = 0;
            while (index < members.length) {
                if (!RefactoringAvailabilityTester.isExtractSupertypeAvailable(members[index])) {
                    return false;
                }
                ++index;
            }
            return RefactoringAvailabilityTester.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isExtractSupertypeAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (!selection.isEmpty()) {
            if (selection.size() == 1) {
                if (selection.getFirstElement() instanceof IJavaScriptUnit) {
                    return true;
                }
                IType type = RefactoringAvailabilityTester.getSingleSelectedType(selection);
                if (type != null) {
                    return Checks.isAvailable((IJavaScriptElement)type) && RefactoringAvailabilityTester.isExtractSupertypeAvailable((IMember[])new IType[]{type});
                }
            }
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof IMember) continue;
                return false;
            }
            HashSet<Object> members = new HashSet<Object>();
            members.addAll(Arrays.asList(selection.toArray()));
            return RefactoringAvailabilityTester.isExtractSupertypeAvailable(members.toArray(new IMember[members.size()]));
        }
        return false;
    }

    public static boolean isExtractSupertypeAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement element = selection.resolveEnclosingElement();
        if (!(element instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isExtractSupertypeAvailable(new IMember[]{(IMember)element});
    }

    public static boolean isExtractTempAvailable(JavaTextSelection selection) {
        ASTNode[] nodes = selection.resolveSelectedNodes();
        return (selection.resolveInMethodBody() || selection.resolveInClassInitializer()) && (Checks.isExtractableExpression(nodes, selection.resolveCoveringNode()) || nodes != null && nodes.length == 1 && nodes[0] instanceof ExpressionStatement);
    }

    public static boolean isGeneralizeTypeAvailable(IJavaScriptElement element) throws JavaScriptModelException {
        if (element != null && element.exists()) {
            String type = null;
            if (element instanceof IFunction) {
                type = ((IFunction)element).getReturnType();
            } else if (element instanceof IField) {
                IField field = (IField)element;
                if (JdtFlags.isEnum((IMember)field)) {
                    return false;
                }
                type = field.getTypeSignature();
            } else {
                if (element instanceof ILocalVariable) {
                    return true;
                }
                if (element instanceof IType) {
                    IType clazz = (IType)element;
                    return !JdtFlags.isEnum((IMember)clazz);
                }
            }
            return type != null && PrimitiveType.toCode((String)Signature.toString((String)type)) == null;
        }
        return false;
    }

    public static boolean isGeneralizeTypeAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof IFunction) {
                IFunction method = (IFunction)element;
                if (!method.exists()) {
                    return false;
                }
                String type = method.getReturnType();
                if (PrimitiveType.toCode((String)Signature.toString((String)type)) == null) {
                    return Checks.isAvailable((IJavaScriptElement)method);
                }
            } else if (element instanceof IField) {
                IField field = (IField)element;
                if (!field.exists()) {
                    return false;
                }
                if (!JdtFlags.isEnum((IMember)field)) {
                    return Checks.isAvailable((IJavaScriptElement)field);
                }
            }
        }
        return false;
    }

    public static boolean isGeneralizeTypeAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return RefactoringAvailabilityTester.isGeneralizeTypeAvailable(elements[0]);
    }

    public static boolean isInferTypeArgumentsAvailable(IJavaScriptElement element) throws JavaScriptModelException {
        if (!Checks.isAvailable(element)) {
            return false;
        }
        if (element instanceof IJavaScriptProject) {
            IJavaScriptProject project = (IJavaScriptProject)element;
            IIncludePathEntry[] classpathEntries = project.getRawIncludepath();
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getKind() == 1;
        }
        if (element instanceof IPackageFragment) {
            return ((IPackageFragment)element).getKind() == 1;
        }
        if (element instanceof IJavaScriptUnit) {
            return true;
        }
        return element.getAncestor(5) != null;
    }

    public static boolean isInferTypeArgumentsAvailable(IJavaScriptElement[] elements) throws JavaScriptModelException {
        if (elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (!RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(elements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInferTypeArgumentsAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IJavaScriptElement)) {
                return false;
            }
            if (element instanceof IJavaScriptUnit) {
                IJavaScriptUnit unit = (IJavaScriptUnit)element;
                return unit.exists() && !unit.isReadOnly();
            }
            if (RefactoringAvailabilityTester.isInferTypeArgumentsAvailable((IJavaScriptElement)element)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInlineConstantAvailable(IField field) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)field) && JdtFlags.isStatic((IMember)field) && JdtFlags.isFinal((IMember)field) && !JdtFlags.isEnum((IMember)field);
    }

    public static boolean isInlineConstantAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IField && RefactoringAvailabilityTester.isInlineConstantAvailable((IField)first);
    }

    public static boolean isInlineConstantAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return elements[0] instanceof IField && RefactoringAvailabilityTester.isInlineConstantAvailable((IField)elements[0]);
    }

    public static boolean isInlineMethodAvailable(IFunction method) throws JavaScriptModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        if (!method.isStructureKnown()) {
            return false;
        }
        if (!method.isBinary()) {
            return true;
        }
        if (method.isConstructor()) {
            return false;
        }
        return SourceRange.isAvailable(method.getNameRange());
    }

    public static boolean isInlineMethodAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IFunction && RefactoringAvailabilityTester.isInlineMethodAvailable((IFunction)first);
    }

    public static boolean isInlineMethodAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        IJavaScriptElement element = elements[0];
        if (!(element instanceof IFunction)) {
            return false;
        }
        IFunction method = (IFunction)element;
        if (!RefactoringAvailabilityTester.isInlineMethodAvailable(method)) {
            return false;
        }
        IJavaScriptElement enclosingElement = selection.resolveEnclosingElement();
        if (enclosingElement == null || enclosingElement.getAncestor(6) == null) {
            return true;
        }
        if (!(enclosingElement instanceof IFunction)) {
            return false;
        }
        IFunction enclosingMethod = (IFunction)enclosingElement;
        if (enclosingMethod.isConstructor()) {
            return false;
        }
        int nameOffset = enclosingMethod.getNameRange().getOffset();
        int nameLength = enclosingMethod.getNameRange().getLength();
        return nameOffset <= selection.getOffset() && selection.getOffset() + selection.getLength() <= nameOffset + nameLength;
    }

    public static boolean isInlineTempAvailable(ILocalVariable variable) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)variable);
    }

    public static boolean isInlineTempAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return elements[0] instanceof ILocalVariable && RefactoringAvailabilityTester.isInlineTempAvailable((ILocalVariable)elements[0]);
    }

    public static boolean isIntroduceFactoryAvailable(IFunction method) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)method) && method.isConstructor();
    }

    public static boolean isIntroduceFactoryAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IFunction) {
            return RefactoringAvailabilityTester.isIntroduceFactoryAvailable((IFunction)selection.getFirstElement());
        }
        return false;
    }

    public static boolean isIntroduceFactoryAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = selection.resolveElementAtOffset();
        if (elements.length == 1 && elements[0] instanceof IFunction) {
            return RefactoringAvailabilityTester.isIntroduceFactoryAvailable((IFunction)elements[0]);
        }
        if (!Checks.isAvailable(selection.resolveEnclosingElement())) {
            return false;
        }
        ASTNode node = selection.resolveCoveringNode();
        if (node == null) {
            ASTNode[] selectedNodes = selection.resolveSelectedNodes();
            if (selectedNodes != null && selectedNodes.length == 1) {
                node = selectedNodes[0];
                if (node == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (node.getNodeType() == 14) {
            return true;
        }
        return (node = ASTNodes.getNormalizedNode(node)).getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY;
    }

    public static boolean isIntroduceIndirectionAvailable(IFunction method) throws JavaScriptModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        if (!method.isStructureKnown()) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        return method.getDeclaringType() == null || !method.getDeclaringType().isAnnotation();
    }

    public static boolean isIntroduceIndirectionAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IFunction && RefactoringAvailabilityTester.isIntroduceIndirectionAvailable((IFunction)first);
    }

    public static boolean isIntroduceIndirectionAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = selection.resolveElementAtOffset();
        if (elements.length == 1) {
            return elements[0] instanceof IFunction && RefactoringAvailabilityTester.isIntroduceIndirectionAvailable((IFunction)elements[0]);
        }
        ASTNode[] selectedNodes = selection.resolveSelectedNodes();
        if (selectedNodes == null || selectedNodes.length != 1) {
            return false;
        }
        switch (selectedNodes[0].getNodeType()) {
            case 31: 
            case 32: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntroduceParameterAvailable(ASTNode[] selectedNodes, ASTNode coveringNode) {
        return Checks.isExtractableExpression(selectedNodes, coveringNode);
    }

    public static boolean isIntroduceParameterAvailable(JavaTextSelection selection) {
        return selection.resolveInMethodBody() && RefactoringAvailabilityTester.isIntroduceParameterAvailable(selection.resolveSelectedNodes(), selection.resolveCoveringNode());
    }

    public static boolean isMoveAvailable(IResource[] resources, IJavaScriptElement[] elements) throws JavaScriptModelException {
        if (elements != null) {
            int index = 0;
            while (index < elements.length) {
                IJavaScriptElement element = elements[index];
                if (element == null || !element.exists()) {
                    return false;
                }
                if (element instanceof IType && ((IType)element).isLocal()) {
                    return false;
                }
                if (element instanceof IPackageDeclaration) {
                    return false;
                }
                if (element instanceof IField && JdtFlags.isEnum((IMember)element)) {
                    return false;
                }
                ++index;
            }
        }
        return ReorgPolicyFactory.createMovePolicy(resources, elements).canEnable();
    }

    public static boolean isMoveAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement element = selection.resolveEnclosingElement();
        if (element == null) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveAvailable(new IResource[0], new IJavaScriptElement[]{element});
    }

    public static boolean isMoveInnerAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        Object first;
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IType) {
            return RefactoringAvailabilityTester.isMoveInnerAvailable((IType)first);
        }
        return false;
    }

    public static boolean isMoveInnerAvailable(IType type) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)type) && !Checks.isAnonymous(type) && !Checks.isTopLevel(type) && !Checks.isInsideLocalType(type);
    }

    public static boolean isMoveInnerAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IType type = RefactoringAvailabilityTester.getDeclaringType(selection.resolveEnclosingElement());
        if (type == null) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveInnerAvailable(type);
    }

    public static boolean isMoveMethodAvailable(IFunction method) throws JavaScriptModelException {
        return method.exists() && !method.isConstructor() && !method.isBinary() && (method.getDeclaringType() == null || !method.getDeclaringType().isAnnotation()) && !method.isReadOnly() && !JdtFlags.isStatic((IMember)method);
    }

    public static boolean isMoveMethodAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() == 1) {
            Object first = selection.getFirstElement();
            return first instanceof IFunction && RefactoringAvailabilityTester.isMoveMethodAvailable((IFunction)first);
        }
        return false;
    }

    public static boolean isMoveMethodAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement method = selection.resolveEnclosingElement();
        if (!(method instanceof IFunction)) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveMethodAvailable((IFunction)method);
    }

    public static boolean isMoveStaticAvailable(IMember member) throws JavaScriptModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum(member) && type != 7) {
            return false;
        }
        IType declaring = member.getDeclaringType();
        if (declaring == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaScriptElement)member)) {
            return false;
        }
        if (type == 9 && declaring.isInterface()) {
            return false;
        }
        if (type == 9 && !JdtFlags.isStatic(member)) {
            return false;
        }
        if (type == 9 && ((IFunction)member).isConstructor()) {
            return false;
        }
        if (type == 7 && !JdtFlags.isStatic(member)) {
            return false;
        }
        return declaring.isInterface() || JdtFlags.isStatic(member);
    }

    public static boolean isMoveStaticAvailable(IMember[] members) throws JavaScriptModelException {
        int index = 0;
        while (index < members.length) {
            if (!RefactoringAvailabilityTester.isMoveStaticAvailable(members[index])) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isMoveStaticAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement element = selection.resolveEnclosingElement();
        if (!(element instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveStaticMembersAvailable(new IMember[]{(IMember)element});
    }

    public static boolean isMoveStaticMembersAvailable(IMember[] members) throws JavaScriptModelException {
        if (members == null) {
            return false;
        }
        if (members.length == 0) {
            return false;
        }
        if (!RefactoringAvailabilityTester.isMoveStaticAvailable(members)) {
            return false;
        }
        return RefactoringAvailabilityTester.isCommonDeclaringType(members);
    }

    public static boolean isPromoteTempAvailable(ILocalVariable variable) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)variable);
    }

    public static boolean isPromoteTempAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return elements[0] instanceof ILocalVariable && RefactoringAvailabilityTester.isPromoteTempAvailable((ILocalVariable)elements[0]);
    }

    public static boolean isPullUpAvailable(IMember member) throws JavaScriptModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum(member) && type != 7) {
            return false;
        }
        if (!Checks.isAvailable((IJavaScriptElement)member)) {
            return false;
        }
        if (member instanceof IType && !JdtFlags.isStatic(member) && !JdtFlags.isEnum(member) && !JdtFlags.isAnnotation(member)) {
            return false;
        }
        if (member instanceof IFunction) {
            IFunction method = (IFunction)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            IType declaring = method.getDeclaringType();
            if (declaring != null && declaring.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPullUpAvailable(IMember[] members) throws JavaScriptModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            if (type != null && RefactoringAvailabilityTester.getPullUpMembers(type).length != 0) {
                return true;
            }
            int index = 0;
            while (index < members.length) {
                if (!RefactoringAvailabilityTester.isPullUpAvailable(members[index])) {
                    return false;
                }
                ++index;
            }
            return RefactoringAvailabilityTester.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isPullUpAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (!selection.isEmpty()) {
            if (selection.size() == 1) {
                if (selection.getFirstElement() instanceof IJavaScriptUnit) {
                    return true;
                }
                IType type = RefactoringAvailabilityTester.getSingleSelectedType(selection);
                if (type != null) {
                    return Checks.isAvailable((IJavaScriptElement)type) && RefactoringAvailabilityTester.isPullUpAvailable((IMember[])new IType[]{type});
                }
            }
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof IMember) continue;
                return false;
            }
            HashSet<Object> members = new HashSet<Object>();
            members.addAll(Arrays.asList(selection.toArray()));
            return RefactoringAvailabilityTester.isPullUpAvailable(members.toArray(new IMember[members.size()]));
        }
        return false;
    }

    public static boolean isPullUpAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement element = selection.resolveEnclosingElement();
        if (!(element instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isPullUpAvailable(new IMember[]{(IMember)element});
    }

    public static boolean isPushDownAvailable(IMember member) throws JavaScriptModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8) {
            return false;
        }
        if (JdtFlags.isEnum(member)) {
            return false;
        }
        if (!Checks.isAvailable((IJavaScriptElement)member)) {
            return false;
        }
        if (JdtFlags.isStatic(member)) {
            return false;
        }
        if (type == 9) {
            IFunction method = (IFunction)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            IType declaring = method.getDeclaringType();
            if (declaring != null && declaring.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPushDownAvailable(IMember[] members) throws JavaScriptModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            if (type != null && RefactoringAvailabilityTester.getPushDownMembers(type).length != 0) {
                return true;
            }
            if (type != null && JdtFlags.isEnum((IMember)type)) {
                return false;
            }
            int index = 0;
            while (index < members.length) {
                if (!RefactoringAvailabilityTester.isPushDownAvailable(members[index])) {
                    return false;
                }
                ++index;
            }
            return RefactoringAvailabilityTester.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isPushDownAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (!selection.isEmpty()) {
            if (selection.size() == 1) {
                if (selection.getFirstElement() instanceof IJavaScriptUnit) {
                    return true;
                }
                IType type = RefactoringAvailabilityTester.getSingleSelectedType(selection);
                if (type != null) {
                    return RefactoringAvailabilityTester.isPushDownAvailable((IMember[])new IType[]{type});
                }
            }
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof IMember) continue;
                return false;
            }
            HashSet<Object> members = new HashSet<Object>();
            members.addAll(Arrays.asList(selection.toArray()));
            return RefactoringAvailabilityTester.isPushDownAvailable(members.toArray(new IMember[members.size()]));
        }
        return false;
    }

    public static boolean isPushDownAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement element = selection.resolveEnclosingElement();
        if (!(element instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isPullUpAvailable(new IMember[]{(IMember)element});
    }

    public static boolean isRenameAvailable(IJavaScriptUnit unit) {
        if (unit == null) {
            return false;
        }
        if (!unit.exists()) {
            return false;
        }
        if (!JavaModelUtil.isPrimary(unit)) {
            return false;
        }
        return !unit.isReadOnly();
    }

    public static boolean isRenameAvailable(IJavaScriptProject project) throws JavaScriptModelException {
        if (project == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaScriptElement)project)) {
            return false;
        }
        return project.isConsistent();
    }

    public static boolean isRenameAvailable(ILocalVariable variable) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)variable);
    }

    public static boolean isRenameAvailable(IFunction method) throws CoreException {
        if (method == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaScriptElement)method)) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        return !RefactoringAvailabilityTester.isRenameProhibited(method);
    }

    public static boolean isRenameAvailable(IPackageFragment fragment) throws JavaScriptModelException {
        if (fragment == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaScriptElement)fragment)) {
            return false;
        }
        return !fragment.isDefaultPackage();
    }

    public static boolean isRenameAvailable(IPackageFragmentRoot root) throws JavaScriptModelException {
        if (root == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaScriptElement)root)) {
            return false;
        }
        if (root.isArchive()) {
            return false;
        }
        if (root.isExternal()) {
            return false;
        }
        if (!root.isConsistent()) {
            return false;
        }
        return !(root.getResource() instanceof IProject);
    }

    public static boolean isRenameAvailable(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (!resource.exists()) {
            return false;
        }
        return resource.isAccessible();
    }

    public static boolean isRenameAvailable(IType type) throws JavaScriptModelException {
        RefactoringSupport refactoringSupport;
        if (type == null) {
            return false;
        }
        if (type.isAnonymous()) {
            return false;
        }
        if (!Checks.isAvailable((IJavaScriptElement)type)) {
            return false;
        }
        if (RefactoringAvailabilityTester.isRenameProhibited(type)) {
            return false;
        }
        InferrenceProvider[] inferenceProviders = InferrenceManager.getInstance().getInferenceProviders((IInferenceFile)type.getJavaScriptUnit());
        if (inferenceProviders.length > 0 && inferenceProviders[0].getRefactoringSupport() != null && (refactoringSupport = inferenceProviders[0].getRefactoringSupport()) != null) {
            return refactoringSupport.supportsClassRename();
        }
        return false;
    }

    public static boolean isRenameAvailable(ITypeParameter parameter) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)parameter);
    }

    public static boolean isRenameEnumConstAvailable(IField field) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)field) && field.getDeclaringType().isEnum();
    }

    public static boolean isRenameFieldAvailable(IField field) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)field) && !JdtFlags.isEnum((IMember)field);
    }

    public static boolean isRenameNonVirtualMethodAvailable(IFunction method) throws JavaScriptModelException, CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(method) && !MethodChecks.isVirtual(method);
    }

    public static boolean isRenameProhibited(IFunction method) throws CoreException {
        return method.getElementName().equals("toString") && method.getNumberOfParameters() == 0 && (method.getReturnType().equals("Ljava.lang.String;") || method.getReturnType().equals("QString;") || method.getReturnType().equals("Qjava.lang.String;"));
    }

    public static boolean isRenameProhibited(IType type) {
        return type.getPackageFragment().getElementName().equals("java.lang");
    }

    public static boolean isRenameVirtualMethodAvailable(IFunction method) throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(method) && MethodChecks.isVirtual(method);
    }

    public static boolean isReplaceInvocationsAvailable(IFunction method) throws JavaScriptModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        return !method.isConstructor();
    }

    public static boolean isReplaceInvocationsAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IFunction && RefactoringAvailabilityTester.isReplaceInvocationsAvailable((IFunction)first);
    }

    public static boolean isReplaceInvocationsAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        IJavaScriptElement element = elements[0];
        return element instanceof IFunction && RefactoringAvailabilityTester.isReplaceInvocationsAvailable((IFunction)element);
    }

    public static boolean isSelfEncapsulateAvailable(IField field) throws JavaScriptModelException {
        return Checks.isAvailable((IJavaScriptElement)field) && !JdtFlags.isEnum((IMember)field) && !field.getDeclaringType().isAnnotation();
    }

    public static boolean isSelfEncapsulateAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IField) {
            IField field = (IField)selection.getFirstElement();
            return Checks.isAvailable((IJavaScriptElement)field) && !JdtFlags.isEnum((IMember)field);
        }
        return false;
    }

    public static boolean isSelfEncapsulateAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return elements[0] instanceof IField && RefactoringAvailabilityTester.isSelfEncapsulateAvailable((IField)elements[0]);
    }

    public static boolean isUseSuperTypeAvailable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() == 1) {
            Object first = selection.getFirstElement();
            if (first instanceof IType) {
                return RefactoringAvailabilityTester.isUseSuperTypeAvailable((IType)first);
            }
            if (first instanceof IJavaScriptUnit) {
                IJavaScriptUnit unit = (IJavaScriptUnit)first;
                return unit.exists() && !unit.isReadOnly();
            }
        }
        return false;
    }

    public static boolean isUseSuperTypeAvailable(IType type) throws JavaScriptModelException {
        return type != null && type.exists() && !type.isAnnotation() && !type.isAnonymous();
    }

    public static boolean isUseSuperTypeAvailable(JavaTextSelection selection) throws JavaScriptModelException {
        return RefactoringAvailabilityTester.isUseSuperTypeAvailable(RefactoringActions.getEnclosingOrPrimaryType(selection));
    }

    public static boolean isWorkingCopyElement(IJavaScriptElement element) {
        if (element instanceof IJavaScriptUnit) {
            return ((IJavaScriptUnit)element).isWorkingCopy();
        }
        if (ReorgUtils.isInsideCompilationUnit(element)) {
            return ReorgUtils.getCompilationUnit(element).isWorkingCopy();
        }
        return false;
    }

    private RefactoringAvailabilityTester() {
    }
}

