/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.CommentFormatFix;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CommentFormatCleanUp
extends AbstractCleanUp {
    public CommentFormatCleanUp(Map options) {
        super(options);
    }

    public CommentFormatCleanUp() {
    }

    public IFix createFix(IJavaScriptUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        if (!this.isEnabled("cleanup.format_source_code")) {
            return null;
        }
        HashMap preferences = new HashMap(compilationUnit.getJavaScriptProject().getOptions(true));
        boolean singleLineComment = "true".equals(preferences.get("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments"));
        boolean blockComment = "true".equals(preferences.get("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments"));
        boolean javaDoc = "true".equals(preferences.get("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments"));
        return CommentFormatFix.createCleanUp(compilationUnit, singleLineComment, blockComment, javaDoc, preferences);
    }

    public IFix createFix(JavaScriptUnit compilationUnit) throws CoreException {
        return null;
    }

    public boolean requireAST(IJavaScriptUnit unit) throws CoreException {
        return false;
    }

    public IFix createFix(JavaScriptUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        return null;
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("/**\n");
        buf.append(" *A Jsdoc comment\n");
        buf.append("* \n");
        buf.append(" */\n");
        return buf.toString();
    }

    public int maximalNumberOfFixes(JavaScriptUnit compilationUnit) {
        return -1;
    }

    public boolean canFix(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }
}

