/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.actions;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.ui.internal.Messages;

public class OptionsMessageDialog
extends MessageDialog {
    protected int radio;
    protected boolean remember;
    protected String[] options;

    public OptionsMessageDialog(Shell parentShell, String title, String dialogMessage, String[] options) {
        super(parentShell, title, null, dialogMessage, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.options = options;
        if (options == null) {
            throw new IllegalArgumentException("Must have at least one option");
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        this.createCustomArea(parent);
        return parent;
    }

    protected Control createCustomArea(Composite parent) {
        int size = this.options.length;
        int i = 0;
        while (i < size) {
            new Label(parent, 0);
            Button radioB = new Button(parent, 16);
            radioB.setText(this.options[i]);
            final int x = i;
            radioB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OptionsMessageDialog.this.radio = x;
                }
            });
            if (i == 0) {
                radioB.setSelection(true);
                this.radio = 0;
            }
            ++i;
        }
        new Label(parent, 0);
        new Label(parent, 0);
        final Button rememberB = new Button(parent, 32);
        rememberB.setText(Messages.dialogRemember);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        rememberB.setLayoutData((Object)data);
        rememberB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsMessageDialog.this.remember = rememberB.getSelection();
            }
        });
        return rememberB;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.setReturnCode(this.radio);
        } else {
            this.setReturnCode(9);
        }
        this.close();
    }

    public boolean isRemember() {
        return this.remember;
    }
}

