/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.TagRegistryFactoryInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TagLibraryRegistryLoader {
    private static final String EXTENSION_ID = "tagregistry";
    private static final String ELEMENT_NAME = "tagRegistry";
    private static Set<TagRegistryFactoryInfo> _extensions;

    TagLibraryRegistryLoader() {
    }

    public static synchronized Set<TagRegistryFactoryInfo> getAllHandlers() {
        if (_extensions == null) {
            _extensions = TagLibraryRegistryLoader.readAllHandlers();
        }
        return Collections.unmodifiableSet(_extensions);
    }

    private static Set<TagRegistryFactoryInfo> readAllHandlers() {
        HashSet<TagRegistryFactoryInfo> result = new HashSet<TagRegistryFactoryInfo>();
        IExtensionPoint extensionPoint = JSFCorePlugin.getDefault().getExtension(EXTENSION_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement element = configElements[j];
                if (ELEMENT_NAME.equals(element.getName())) {
                    try {
                        TagRegistryFactoryInfo extension = new TagRegistryFactoryInfo(element);
                        result.add(extension);
                    }
                    catch (CoreException e) {
                        JSFCorePlugin.log((Exception)((Object)e), "Error loading tag registry extension: " + element.getContributor().getName() + "." + element.getAttribute("id"));
                    }
                }
                ++j;
            }
            ++i;
        }
        return result;
    }
}

