/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.SignatureBasedType;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.designtime.resolver.IStructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.el.ASTSemanticValidator;
import org.eclipse.jst.jsf.validation.internal.el.IExpressionSemanticValidator;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.jst.jsp.core.internal.java.jspel.TokenMgrError;

public class ELExpressionValidator {
    private final IStructuredDocumentContext _context;
    private final String _elText;
    private final DiagnosticFactory _diagnosticFactory;
    private ASTSemanticValidator _semanticValidator;
    private final IStructuredDocumentSymbolResolverFactory _symbolResolverFactory;
    private final IJSFViewValidator.IValidationReporter _reporter;

    public ELExpressionValidator(IStructuredDocumentContext context, String elText, IStructuredDocumentSymbolResolverFactory symbolResolverFactory, IJSFViewValidator.IValidationReporter reporter) {
        this._context = context;
        this._elText = elText;
        this._diagnosticFactory = new DiagnosticFactory();
        this._symbolResolverFactory = symbolResolverFactory;
        this._reporter = reporter;
    }

    public ASTExpression validateXMLNode() {
        JSPELParser elParser = JSPELParser.createParser((String)this._elText);
        try {
            ASTExpression expr = elParser.Expression();
            this.validateSemantics(expr, this._context);
            if (expr.getLastToken().endColumn < this._elText.trim().length() - 1) {
                int offset = this._context.getDocumentPosition() + expr.getLastToken().endColumn;
                int length = this._elText.trim().length() - expr.getLastToken().endColumn;
                Diagnostic diagnostic = this._diagnosticFactory.create_GENERAL_SYNTAX_ERROR();
                this._reporter.report(diagnostic, offset, length);
            }
            return expr;
        }
        catch (ParseException e) {
            Token curTok = e.currentToken;
            int offset = this._context.getDocumentPosition() + curTok.beginColumn;
            int length = curTok.endColumn - curTok.beginColumn + 1;
            Diagnostic diagnostic = this._diagnosticFactory.create_GENERAL_SYNTAX_ERROR();
            this._reporter.report(diagnostic, offset, length);
            return null;
        }
        catch (TokenMgrError tokenMgrError) {
            int offset = this._context.getDocumentPosition();
            int length = this._elText.length();
            Diagnostic diagnostic = this._diagnosticFactory.create_GENERAL_SYNTAX_ERROR();
            this._reporter.report(diagnostic, offset, length);
            return null;
        }
    }

    public CompositeType getExpressionType() {
        SignatureBasedType type;
        if (this._semanticValidator != null && (type = this._semanticValidator.getExpressionType()) != null) {
            return type.toCompositeType();
        }
        return null;
    }

    public IExpressionSemanticValidator getSemanticValidator() {
        return this._semanticValidator;
    }

    private void validateSemantics(ASTExpression expr, IStructuredDocumentContext context) {
        this._semanticValidator = new ASTSemanticValidator(expr, context, this._symbolResolverFactory, this._reporter);
        this._semanticValidator.validate();
    }
}

