/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedByComposite
extends AbstractFormPane<NonOwningMapping> {
    private CCombo combo;

    public MappedByComposite(AbstractFormPane<? extends NonOwningMapping> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public MappedByComposite(PropertyValueModel<? extends NonOwningMapping> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("resolvedTargetEntityProperty");
        propertyNames.add("mappedByProperty");
    }

    private ModifyListener buildComboModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CCombo combo;
                if (!MappedByComposite.this.isPopulating() && (combo = (CCombo)e.widget).getData("populating") != Boolean.TRUE) {
                    MappedByComposite.this.valueChanged(combo.getText());
                }
            }
        };
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.populateCombo();
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.combo = this.buildLabeledEditableCCombo(container, JptUiMappingsMessages.NonOwningMapping_mappedByLabel, this.buildComboModifyListener(), "org.eclipse.jpt.ui.mapping_mappedBy");
        SWTUtil.attachDefaultValueHandler(this.combo);
    }

    private void populateCombo() {
        this.combo.removeAll();
        this.combo.add(JptUiMappingsMessages.NoneSelected);
        NonOwningMapping subject = (NonOwningMapping)this.subject();
        if (subject != null) {
            Iterator iter = subject.candidateMappedByAttributeNames();
            iter = CollectionTools.sort((Iterator)iter);
            while (iter.hasNext()) {
                this.combo.add((String)iter.next());
            }
        }
        this.updateSelectedItem();
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "mappedByProperty" || propertyName == "resolvedTargetEntityProperty") {
            this.populateCombo();
        }
    }

    private void updateSelectedItem() {
        String value;
        NonOwningMapping subject = (NonOwningMapping)this.subject();
        String string = value = subject != null ? subject.getMappedBy() : null;
        if (value != null) {
            this.combo.setText(value);
        } else {
            this.combo.select(0);
        }
        this.combo.setSelection(new Point(0, 0));
    }

    private void valueChanged(String value) {
        String oldValue;
        NonOwningMapping subject = (NonOwningMapping)this.subject();
        String string = oldValue = subject != null ? subject.getMappedBy() : null;
        if (StringTools.stringIsEmpty((String)value)) {
            value = null;
            if (StringTools.stringIsEmpty((String)oldValue)) {
                return;
            }
        }
        if (JptUiMappingsMessages.NoneSelected.equals(value)) {
            value = null;
        }
        if (oldValue == value && value == null) {
            return;
        }
        if (value != null && oldValue == null || oldValue != null && !oldValue.equals(value)) {
            this.setPopulating(true);
            try {
                subject.setMappedBy(value);
            }
            finally {
                this.setPopulating(false);
            }
        }
    }
}

