/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentmodel.annotation.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.contentmodel.annotation.ICMAnnotationSourceFileInfo;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationMap;

public final class CMAnnotationFileRegistry {
    private Map annotationFilesMap = new HashMap(1);
    private Map parsedFilesMap = new HashMap(1);
    private static CMAnnotationFileRegistry reg;
    private static final boolean DISABLED = true;

    public static CMAnnotationFileRegistry getInstance() {
        if (reg == null) {
            reg = new CMAnnotationFileRegistry();
        }
        return reg;
    }

    private CMAnnotationFileRegistry() {
    }

    private synchronized List getAnnotationFilesInfos(String uri) {
        List theList = (List)this.annotationFilesMap.get(uri);
        return theList != null ? theList : new ArrayList();
    }

    public synchronized void addAnnotationFileInfo(String uri, ICMAnnotationSourceFileInfo fileInfo) {
        ArrayList<ICMAnnotationSourceFileInfo> fileInfos = (ArrayList<ICMAnnotationSourceFileInfo>)this.annotationFilesMap.get(uri);
        if (fileInfos == null) {
            fileInfos = new ArrayList<ICMAnnotationSourceFileInfo>();
            this.annotationFilesMap.put(uri, fileInfos);
        }
        fileInfos.add(fileInfo);
    }

    private synchronized void addParsedFileToMap(String uri, CMAnnotationMap map) {
        ArrayList<CMAnnotationMap> maps = (ArrayList<CMAnnotationMap>)this.parsedFilesMap.get(uri);
        if (maps == null) {
            maps = new ArrayList<CMAnnotationMap>();
            this.parsedFilesMap.put(uri, maps);
        }
        maps.add(map);
    }

    public synchronized List getAnnotationMaps(String uri) {
        JSFCommonPlugin.log(4, "Attempted metadata access using CMAnnotationFiles for uri: " + uri + ".   Use org.eclipse.jst.jsf.common.metadata, instead.");
        return Collections.EMPTY_LIST;
    }

    public boolean hasAnnotations(String bundleId, String uri) {
        List maps = (List)this.annotationFilesMap.get(uri);
        if (maps == null || maps.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < maps.size()) {
            if (((ICMAnnotationSourceFileInfo)maps.get(i)).getBundleId().equals(bundleId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasAnnotations(String uri) {
        JSFCommonPlugin.log(4, "Attempted metadata access using CMAnnotationFiles for uri: " + uri + ".   Use org.eclipse.jst.jsf.common.metadata, instead.");
        return false;
    }

    private boolean areAnnotationsParsed(String uri) {
        return this.hasAnnotations(uri) && this.parsedFilesMap.get(uri) != null;
    }

    private void loadAnnotationsForGrammar(String uri) {
        if (this.areAnnotationsParsed(uri)) {
            return;
        }
    }
}

