/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.orm.details;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.orm.JptUiOrmMessages;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmJavaClassChooser
extends AbstractFormPane<OrmTypeMapping> {
    public OrmJavaClassChooser(AbstractFormPane<?> parentPane, PropertyValueModel<? extends OrmTypeMapping> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    public OrmJavaClassChooser(PropertyValueModel<? extends OrmTypeMapping> subjectHolder, Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(subjectHolder, parent, (FormToolkit)widgetFactory);
    }

    private ClassChooserPane<OrmTypeMapping> initializeClassChooser(Composite container) {
        return new ClassChooserPane<OrmTypeMapping>((AbstractPane)this, container){

            @Override
            protected WritablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<OrmTypeMapping, String>(this.getSubjectHolder(), new String[]{"classProperty"}){

                    protected String buildValue_() {
                        return ((OrmTypeMapping)this.subject).getClass_();
                    }

                    protected void setValue_(String value) {
                        ((OrmTypeMapping)this.subject).setClass(value);
                    }
                };
            }

            @Override
            protected String className() {
                return ((OrmTypeMapping)this.subject()).getClass_();
            }

            @Override
            protected String labelText() {
                return JptUiOrmMessages.OrmJavaClassChooser_javaClass;
            }

            @Override
            protected IPackageFragmentRoot packageFragmentRoot() {
                IProject project = ((OrmTypeMapping)this.subject()).getJpaProject().getProject();
                IJavaProject root = JavaCore.create((IProject)project);
                try {
                    return root.getAllPackageFragmentRoots()[0];
                }
                catch (JavaModelException e) {
                    JptUiPlugin.log(e);
                    return null;
                }
            }

            @Override
            protected void promptType() {
                IType type = this.chooseType();
                if (type != null) {
                    String className = type.getFullyQualifiedName('.');
                    ((OrmTypeMapping)this.subject()).setClass(className);
                }
            }
        };
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.initializeClassChooser(container);
    }
}

