/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jst.j2ee.model.IModelProviderFactory;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class J2EEModelProviderRegistry
extends RegistryReader {
    static final String EXTENSION_NAME = "J2EEModelProvider";
    static final String ELEMENT_providers = "provider";
    static final String MODEL_PROVIDER = "modelProvider";
    static final String PROVIDER_FACTORY_CLASS = "factoryClass";
    static final String PROVIDER_PRIORITY = "priority";
    static final String PROVIDER_FACET = "facet";
    static final String PROVIDER_FACET_ID = "id";
    static final String PROVIDER_FACET_VERSION = "versions";
    private static J2EEModelProviderRegistry INSTANCE = null;

    public J2EEModelProviderRegistry() {
        super("org.eclipse.jst.j2ee", EXTENSION_NAME);
    }

    public static J2EEModelProviderRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new J2EEModelProviderRegistry();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public boolean readElement(IConfigurationElement element) {
        String priority = null;
        if (!element.getName().equals(ELEMENT_providers)) {
            return false;
        }
        IModelProviderFactory factory = null;
        IConfigurationElement[] mp = element.getChildren(MODEL_PROVIDER);
        try {
            factory = (IModelProviderFactory)mp[0].createExecutableExtension(PROVIDER_FACTORY_CLASS);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (factory != null) {
            priority = mp[0].getAttribute(PROVIDER_PRIORITY);
        }
        if (factory != null) {
            IConfigurationElement[] facet = element.getChildren(PROVIDER_FACET);
            String facetId = facet[0].getAttribute(PROVIDER_FACET_ID);
            IProjectFacet pv = ProjectFacetsManager.getProjectFacet((String)facetId);
            if (pv == null) {
                System.out.println("Unrecognized facet: " + facetId);
                return true;
            }
            String facetVersions = facet[0].getAttribute(PROVIDER_FACET_VERSION);
            StringTokenizer tokens = new StringTokenizer(facetVersions, ",");
            while (tokens.hasMoreElements()) {
                String facetversion = (String)tokens.nextElement();
                IProjectFacetVersion fv = pv.getVersion(facetversion);
                if (fv == null) continue;
                J2EEModelProviderRegistry.addModelProvider(factory, fv, priority);
            }
        }
        return true;
    }

    private static void addModelProvider(IModelProviderFactory provider, IProjectFacetVersion version, String priority) {
        ModelProviderManager.registerProvider(provider, version, priority);
    }
}

