/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OpenSuperImplementationAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenSuperImplementationAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenSuperImplementationAction_label);
        this.setDescription(ActionMessages.OpenSuperImplementationAction_description);
        this.setToolTipText(ActionMessages.OpenSuperImplementationAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.open_super_implementation_action");
    }

    public OpenSuperImplementationAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        IFunction method = this.getMethod(selection);
        this.setEnabled(method != null && this.checkMethod(method));
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.fEditor)) {
            return;
        }
        IJavaScriptElement element = this.elementAtOffset();
        if (element == null || !(element instanceof IFunction)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)OpenSuperImplementationAction.getDialogTitle(), (String)ActionMessages.OpenSuperImplementationAction_not_applicable);
            return;
        }
        this.run((IFunction)element);
    }

    public void run(IStructuredSelection selection) {
        this.run(this.getMethod(selection));
    }

    public void run(IFunction method) {
        if (method == null) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), (IJavaScriptElement)method)) {
            return;
        }
        if (!this.checkMethod(method)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)OpenSuperImplementationAction.getDialogTitle(), (String)Messages.format(ActionMessages.OpenSuperImplementationAction_no_super_implementation, method.getElementName()));
            return;
        }
        try {
            IFunction impl = this.findSuperImplementation(method);
            if (impl != null) {
                JavaScriptUI.openInEditor((IJavaScriptElement)impl, true, true);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, OpenSuperImplementationAction.getDialogTitle(), ActionMessages.OpenSuperImplementationAction_error_message);
        }
    }

    private IFunction findSuperImplementation(IFunction method) throws JavaScriptModelException {
        MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(method.getDeclaringType());
        return tester.findOverriddenMethod(method, false);
    }

    private IFunction getMethod(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IFunction) {
            return (IFunction)element;
        }
        return null;
    }

    private boolean checkMethod(IFunction method) {
        block3: {
            IType declaringType;
            block4: {
                int flags = method.getFlags();
                if (Flags.isStatic((int)flags) || Flags.isPrivate((int)flags)) break block3;
                declaringType = method.getDeclaringType();
                if (declaringType != null) break block4;
                return false;
            }
            try {
                return !SuperTypeHierarchyCache.hasInCache(declaringType) || this.findSuperImplementation(method) != null;
            }
            catch (JavaScriptModelException e) {
                if (e.isDoesNotExist()) break block3;
                JavaScriptPlugin.log(e);
            }
        }
        return false;
    }

    private IJavaScriptElement elementAtOffset() {
        try {
            return SelectionConverter.getElementAtOffset(this.fEditor);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    private static String getDialogTitle() {
        return ActionMessages.OpenSuperImplementationAction_error_title;
    }
}

