/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.wizard.ClassesImportWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class WizardClassesImportMainPage
extends WizardPage {
    Composite composite;
    protected Button importFromDir;
    protected Button importFromZip;
    private List dragAndDropFileNames = null;

    public WizardClassesImportMainPage(String pageName) {
        super(pageName);
        this.setTitle(J2EEUIMessages.getResourceString("DataTransfer.fileSystemTitle"));
        this.setDescription(J2EEUIMessages.getResourceString("FileImport.importFileSystem"));
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("import_class_file_wiz_ban"));
    }

    public WizardClassesImportMainPage(String pageName, List fileNames) {
        super(pageName);
        this.setTitle(J2EEUIMessages.getResourceString("DataTransfer.fileSystemTitle"));
        this.setDescription(J2EEUIMessages.getResourceString("FileImport.importFileSystem"));
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("import_class_file_wiz_ban"));
        this.dragAndDropFileNames = fileNames;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jst.j2ee.ui.IMPORT_CLASS_WIZARD_PAGE1");
        this.initializeDialogUnits((Control)parent);
        Composite aComposite = new Composite(parent, 0);
        aComposite.setLayout((Layout)new GridLayout());
        aComposite.setLayoutData((Object)new GridData(272));
        aComposite.setSize(aComposite.computeSize(-1, -1));
        aComposite.setFont(parent.getFont());
        this.createImportTypeGroup(aComposite);
        this.setControl((Control)aComposite);
    }

    protected void createImportTypeGroup(Composite parent) {
        Composite importTypeGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        importTypeGroup.setLayout((Layout)layout);
        importTypeGroup.setLayoutData((Object)new GridData(768));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWizard wiz = WizardClassesImportMainPage.this.getWizard();
                if (((ClassesImportWizard)wiz).page1 != null) {
                    ((ClassesImportWizard)wiz).page1.blankPage();
                }
            }
        };
        this.importFromDir = new Button(importTypeGroup, 16);
        this.importFromDir.setText(J2EEUIMessages.getResourceString("ClassesImport.fromDir"));
        this.importFromDir.addSelectionListener((SelectionListener)selectionListener);
        this.importFromZip = new Button(importTypeGroup, 16);
        this.importFromZip.setText(J2EEUIMessages.getResourceString("ClassesImport.fromZip"));
        this.importFromZip.addSelectionListener((SelectionListener)selectionListener);
        IWizard wiz = this.getWizard();
        String fileName = null;
        if (((ClassesImportWizard)wiz).fileNames != null) {
            fileName = ((ClassesImportWizard)wiz).fileNames.get(0).toString();
        }
        if (fileName != null && (fileName.endsWith(".zip") || fileName.endsWith(".jar"))) {
            this.importFromDir.setSelection(false);
            this.importFromZip.setSelection(true);
        } else {
            this.importFromDir.setSelection(true);
            this.importFromZip.setSelection(false);
        }
    }

    protected boolean isSetImportFromDir() {
        if (this.importFromDir != null) {
            return this.importFromDir.getSelection();
        }
        String fileName = this.dragAndDropFileNames.get(0).toString();
        return fileName == null || !fileName.endsWith(".zip") && !fileName.endsWith(".jar");
    }
}

