/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.SnippetsMessages;
import org.eclipse.wst.common.snippets.internal.SnippetsPlugin;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawerFactory;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsView;
import org.eclipse.wst.common.snippets.internal.util.CComboSelectionDialog;

public class UserDrawerSelector {
    private String fInputPrompt;
    private String fSelectionPrompt;
    private Shell fShell;

    public UserDrawerSelector(Shell shell) {
        this.fShell = shell;
    }

    public String getInputPrompt() {
        return this.fInputPrompt;
    }

    public String getSelectionPrompt() {
        return this.fSelectionPrompt;
    }

    public PaletteDrawer getUserDrawer() {
        List categories = SnippetsPlugin.getSnippetManager().getDefinitions().getCategories();
        ArrayList<PaletteDrawer> modifiableCategories = new ArrayList<PaletteDrawer>();
        int i = 0;
        while (i < categories.size()) {
            PaletteDrawer drawer = (PaletteDrawer)categories.get(i);
            if (drawer.getUserModificationPermission() == 15) {
                modifiableCategories.add(drawer);
            }
            ++i;
        }
        PaletteDrawer drawer = null;
        if (modifiableCategories.size() >= 1) {
            String[] userDrawers = new String[modifiableCategories.size()];
            int i2 = 0;
            while (i2 < modifiableCategories.size()) {
                userDrawers[i2] = ((PaletteDrawer)modifiableCategories.get(i2)).getLabel();
                ++i2;
            }
            CComboSelectionDialog dlg = new CComboSelectionDialog(this.fShell, SnippetsMessages.New_Category_Title, this.fSelectionPrompt != null ? this.fSelectionPrompt : SnippetsMessages.choose_or_create, userDrawers, 0, new CategoryNameValidator()){

                protected Control createDialogArea(Composite parent) {
                    Control mainHook = super.createDialogArea(parent);
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(mainHook, "org.eclipse.wst.common.snippets.snip0080");
                    return mainHook;
                }
            };
            dlg.open();
            if (dlg.getReturnCode() == 0) {
                String drawerName = dlg.getStringValue();
                int selectedDrawer = dlg.getSelectionIndex();
                PaletteEntry anchor = null;
                if (selectedDrawer >= 0) {
                    drawer = (PaletteDrawer)modifiableCategories.get(selectedDrawer);
                } else {
                    if (categories.size() > 0) {
                        anchor = (PaletteEntry)categories.get(categories.size() - 1);
                    }
                    drawer = (PaletteDrawer)new SnippetPaletteDrawerFactory().createNewEntry(this.fShell, anchor);
                    drawer.setLabel(drawerName);
                }
            }
        } else {
            Object anchor = null;
            if (categories.size() > 0) {
                anchor = (PaletteEntry)categories.get(categories.size() - 1);
            } else {
                try {
                    SnippetsView view = (SnippetsView)SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
                    if (view == null) {
                        view = (SnippetsView)SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
                    }
                    if (view != null) {
                        anchor = view.getRoot();
                    }
                }
                catch (PartInitException e) {
                    Logger.logException(e);
                }
            }
            if (anchor != null) {
                String defaultNewDrawerName = null;
                IEditorPart currentEditor = SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (currentEditor != null && currentEditor.getEditorInput() != null) {
                    defaultNewDrawerName = currentEditor.getEditorInput().getName();
                }
                if (defaultNewDrawerName == null) {
                    defaultNewDrawerName = SnippetsMessages.new_category_name;
                }
                InputDialog d = new InputDialog(this.fShell, SnippetsMessages.New_Category_Title, this.fInputPrompt != null ? this.fInputPrompt : SnippetsMessages.force_create, defaultNewDrawerName, new CategoryNameValidator()){

                    protected Control createContents(Composite parent) {
                        Control mainHook = super.createContents(parent);
                        PlatformUI.getWorkbench().getHelpSystem().setHelp(mainHook, "org.eclipse.wst.common.snippets.snip0080");
                        return mainHook;
                    }
                };
                d.open();
                if (d.getReturnCode() == 0) {
                    drawer = (PaletteDrawer)new SnippetPaletteDrawerFactory().createNewEntry(this.fShell, (PaletteEntry)anchor);
                    drawer.setLabel(d.getValue());
                }
            }
        }
        return drawer;
    }

    public void setInputPrompt(String string) {
        this.fInputPrompt = string;
    }

    public void setSelectionPrompt(String string) {
        this.fSelectionPrompt = string;
    }

    protected static class CategoryNameValidator
    implements IInputValidator {
        protected CategoryNameValidator() {
        }

        public String isValid(String name) {
            if (name == null || name.length() < 1) {
                return SnippetsMessages.A_name_must_be_specified_1;
            }
            return null;
        }
    }
}

