/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.eclipse.wst.ws.internal.explorer.platform.actions.LinkAction;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIImportWSDLToFileSystemAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.util.Uddi4jHelper;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.OpenWSDLAction;
import org.uddi4j.datatype.service.BusinessService;

public class UDDIAddToWSDLPerspectiveAction
extends LinkAction {
    public UDDIAddToWSDLPerspectiveAction(Controller controller) {
        super(controller);
    }

    public static final String getActionLink(int nodeId, int toolId, int viewId, int viewToolId) {
        StringBuffer actionLink = new StringBuffer("uddi/actions/UDDIAddToWSDLPerspectiveActionJSP.jsp?");
        actionLink.append("nodeId");
        actionLink.append('=');
        actionLink.append(nodeId);
        actionLink.append('&');
        actionLink.append("toolId");
        actionLink.append('=');
        actionLink.append(toolId);
        actionLink.append('&');
        actionLink.append("viewId");
        actionLink.append('=');
        actionLink.append(viewId);
        actionLink.append('&');
        actionLink.append("viewToolId");
        actionLink.append('=');
        actionLink.append(viewToolId);
        return actionLink.toString();
    }

    protected boolean processLinkParameters(HttpServletRequest request) {
        String nodeIdString = request.getParameter("nodeId");
        try {
            Integer.parseInt(nodeIdString);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        this.propertyTable_.put("nodeId", nodeIdString);
        return true;
    }

    public boolean run() {
        int nodeId = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        NodeManager nodeManager = uddiPerspective.getNavigatorManager();
        Node node = nodeManager.getNode(nodeId);
        TreeElement element = node.getTreeElement();
        if (element instanceof ServiceElement) {
            Uddi4jHelper uddi4jHelper = new Uddi4jHelper();
            ServiceElement serviceElement = (ServiceElement)element;
            BusinessService bs = serviceElement.getBusinessService();
            String wsdlURL = uddi4jHelper.getWSDL(bs, serviceElement.getRegistryElement().getProxy());
            if (wsdlURL == null) {
                try {
                    Definition def = uddi4jHelper.getWSDLDefinition(wsdlURL);
                    File tempFile = File.createTempFile("temp", ".wsdl");
                    UDDIImportWSDLToFileSystemAction action = new UDDIImportWSDLToFileSystemAction(this.controller_);
                    action.writeWSDLDefinition(new FileOutputStream(tempFile), def);
                    wsdlURL = tempFile.toURL().toString();
                }
                catch (WSDLException wSDLException) {
                    wsdlURL = null;
                }
                catch (MalformedURLException malformedURLException) {
                    wsdlURL = null;
                }
                catch (IOException iOException) {
                    wsdlURL = null;
                }
            }
            if (wsdlURL != null) {
                OpenWSDLAction openWSDLAction = new OpenWSDLAction(this.controller_);
                Hashtable propertyTable = openWSDLAction.getPropertyTable();
                propertyTable.put("wsdlURL", wsdlURL);
                boolean actionResult = openWSDLAction.run();
                if (actionResult) {
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_WSDL_ADDED_TO_WSDL_PERSPECTIVE", wsdlURL));
                    return true;
                }
            }
        }
        messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_WSDL_NOT_ADDED_TO_WSDL_PERSPECTIVE"));
        return false;
    }
}

