/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal.cactus;

import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;

public class WebTestableResource
extends ModuleArtifactDelegate {
    private boolean fServletIsConfigured;
    private String fClassName;
    private String fTestName;
    private String fProjectName;

    public WebTestableResource(IModule module, boolean servletIsConfigured, String projectName, String className, String testName) {
        super(module);
        this.fServletIsConfigured = servletIsConfigured;
        this.fClassName = className;
        this.fTestName = testName;
        this.fProjectName = projectName;
    }

    public WebTestableResource() {
    }

    public String getProjectName() {
        return this.fProjectName;
    }

    public boolean isServletConfigured() {
        return this.fServletIsConfigured;
    }

    public String getClassName() {
        return this.fClassName;
    }

    public String getTestName() {
        return this.fTestName;
    }

    public String getName() {
        return NLS.bind((String)Messages.artifactCactusTest, (Object)this.fTestName);
    }

    public void deserialize(String s) {
        int ind = s.indexOf("//");
        super.deserialize(s.substring(0, ind));
        s = s.substring(ind + 2);
        ind = s.indexOf("//");
        this.fProjectName = s.substring(0, ind);
        s = s.substring(ind + 2);
        ind = s.indexOf("//");
        this.fClassName = s.substring(0, ind);
        this.fServletIsConfigured = 'T' == s.charAt(ind + 2);
        this.fTestName = s.substring(ind + 3);
    }

    public String serialize() {
        StringBuffer sb = new StringBuffer(super.serialize());
        sb.append("//");
        sb.append(this.fProjectName);
        sb.append("//");
        sb.append(this.fClassName);
        sb.append("//");
        if (this.fServletIsConfigured) {
            sb.append("T");
        } else {
            sb.append("F");
        }
        sb.append(this.fTestName);
        return sb.toString();
    }
}

