/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSImportRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSMediaRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSimpleSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.internal.util.AbstractCssTraverser;

public class CSSClassTraverser
extends AbstractCssTraverser {
    ArrayList fClassNames;

    private void addClassNames(ICSSStyleRule rule) {
        ICSSSelectorList selectorList = rule.getSelectors();
        Iterator iSelector = selectorList.getIterator();
        while (iSelector.hasNext()) {
            ICSSSelector selector = (ICSSSelector)iSelector.next();
            Iterator iItem = selector.getIterator();
            while (iItem.hasNext()) {
                ICSSSelectorItem item = (ICSSSelectorItem)iItem.next();
                if (item.getItemType() != 1) continue;
                ICSSSimpleSelector sel = (ICSSSimpleSelector)item;
                int nClasses = sel.getNumOfClasses();
                int iClass = 0;
                while (iClass < nClasses) {
                    String className = sel.getClass(iClass);
                    if (!this.fClassNames.contains(className)) {
                        this.fClassNames.add(className);
                    }
                    ++iClass;
                }
            }
        }
    }

    protected void begin(ICSSNode node) {
        if (this.fClassNames == null) {
            this.fClassNames = new ArrayList();
        }
    }

    protected void end(ICSSNode node) {
    }

    public Collection getClassNames() {
        return this.fClassNames != null ? this.fClassNames : Collections.EMPTY_LIST;
    }

    protected short postNode(ICSSNode node) {
        return TRAV_CONT;
    }

    protected short preNode(ICSSNode node) {
        short ret;
        if (node instanceof ICSSStyleRule) {
            this.addClassNames((ICSSStyleRule)node);
            ret = TRAV_PRUNE;
        } else {
            ret = node instanceof ICSSStyleSheet || node instanceof ICSSMediaRule || node instanceof ICSSImportRule ? TRAV_CONT : TRAV_PRUNE;
        }
        return ret;
    }
}

