/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import com.ibm.icu.text.BreakIterator;
import java.text.CharacterIterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class JavadocDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private DocumentCharacterIterator fDocIter = new DocumentCharacterIterator();

    public void doubleClicked(ITextViewer text) {
        int position = text.getSelectedRange().x;
        if (position < 0) {
            return;
        }
        IRegion word = this.getWordRegion(text.getDocument(), position);
        if (word != null) {
            text.setSelectedRange(word.getOffset(), word.getLength());
        }
    }

    private IRegion getWordRegion(IDocument document, int position) {
        int end;
        int start;
        block13: {
            IRegion line;
            block12: {
                try {
                    line = document.getLineInformationOfOffset(position);
                    if (position != line.getOffset() + line.getLength()) break block12;
                    return null;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            this.fDocIter.setDocument(document, line);
            BreakIterator breakIter = BreakIterator.getWordInstance();
            breakIter.setText((CharacterIterator)this.fDocIter);
            start = breakIter.preceding(position);
            if (start == -1) {
                start = line.getOffset();
            }
            if ((end = breakIter.following(position)) == -1) {
                end = line.getOffset() + line.getLength();
            }
            if (breakIter.isBoundary(position)) {
                if (end - position > position - start) {
                    start = position;
                } else {
                    end = position;
                }
            }
            if (start > 0 && document.getChar(start - 1) == '@' && Character.isJavaIdentifierPart(document.getChar(start)) && (start == 1 || Character.isWhitespace(document.getChar(start - 2)) || document.getChar(start - 2) == '{')) {
                --start;
            } else if (end == position && end == start + 1 && end < line.getOffset() + line.getLength() && document.getChar(end) == '@') {
                return this.getWordRegion(document, position + 1);
            }
            if (start != end) break block13;
            return null;
        }
        return new Region(start, end - start);
    }

    static class DocumentCharacterIterator
    implements CharacterIterator {
        private IDocument fDocument;
        private int fOffset = -1;
        private int fEndOffset = -1;
        private int fIndex = -1;

        public void setDocument(IDocument document, IRegion iteratorRange) {
            this.fDocument = document;
            this.fOffset = iteratorRange.getOffset();
            this.fEndOffset = this.fOffset + iteratorRange.getLength();
        }

        public char first() {
            this.fIndex = this.fOffset;
            return this.current();
        }

        public char last() {
            this.fIndex = this.fOffset < this.fEndOffset ? this.fEndOffset - 1 : this.fEndOffset;
            return this.current();
        }

        public char current() {
            if (this.fOffset <= this.fIndex && this.fIndex < this.fEndOffset) {
                try {
                    return this.fDocument.getChar(this.fIndex);
                }
                catch (BadLocationException badLocationException) {}
            }
            return '\uffff';
        }

        public char next() {
            ++this.fIndex;
            int end = this.getEndIndex();
            if (this.fIndex >= end) {
                this.fIndex = end;
                return '\uffff';
            }
            return this.current();
        }

        public char previous() {
            if (this.fIndex == this.fOffset) {
                return '\uffff';
            }
            if (this.fIndex > this.fOffset) {
                --this.fIndex;
            }
            return this.current();
        }

        public char setIndex(int index) {
            this.fIndex = index;
            return this.current();
        }

        public int getBeginIndex() {
            return this.fOffset;
        }

        public int getEndIndex() {
            return this.fEndOffset;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public Object clone() {
            DocumentCharacterIterator i = new DocumentCharacterIterator();
            i.fDocument = this.fDocument;
            i.fIndex = this.fIndex;
            i.fOffset = this.fOffset;
            i.fEndOffset = this.fEndOffset;
            return i;
        }
    }
}

