/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class AvailableJ2EEComponentsForEARContentProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    static final String PATH_SEPARATOR = String.valueOf('/');
    private static final int COMPONENT_NUM_OF_SEGMENTS = 1;
    private int j2eeVersion;
    private IVirtualComponent earComponent;
    private boolean isEE5 = false;
    private String libDir = null;

    public AvailableJ2EEComponentsForEARContentProvider(IVirtualComponent aEarComponent, int j2eeVersion) {
        this.j2eeVersion = j2eeVersion;
        this.earComponent = aEarComponent;
    }

    /*
     * Unable to fully structure code
     */
    public Object[] getElements(Object inputElement) {
        if (this.earComponent != null) {
            this.isEE5 = J2EEProjectUtilities.isJEEProject((IProject)this.earComponent.getProject());
        }
        empty = new Object[]{};
        if (!(inputElement instanceof IWorkspaceRoot)) {
            return empty;
        }
        projects = ((IWorkspaceRoot)inputElement).getProjects();
        if (projects == null || projects.length == 0) {
            return empty;
        }
        validCompList = new ArrayList<Object>();
        pathToComp = new HashMap<K, V>();
        i = 0;
        while (i < projects.length) {
            project = projects[i];
            if (ModuleCoreNature.isFlexibleProject((IProject)project)) {
                component = ComponentCore.createComponent((IProject)project);
                if (J2EEProjectUtilities.isApplicationClientProject((IProject)project) || J2EEProjectUtilities.isEJBProject((IProject)project) || J2EEProjectUtilities.isDynamicWebProject((IProject)project) || J2EEProjectUtilities.isJCAProject((IProject)project) || J2EEProjectUtilities.isUtilityProject((IProject)project)) {
                    compJ2EEVersion = J2EEVersionUtil.convertVersionStringToInt((IVirtualComponent)component);
                    if (compJ2EEVersion <= this.j2eeVersion) {
                        validCompList.add(component);
                    } else if (this.isEE5) {
                        validCompList.add(component);
                    }
                } else if (this.earComponent != null && J2EEProjectUtilities.isEARProject((IProject)project) && component.equals(this.earComponent)) {
                    if (this.isEE5) {
                        earDDVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
                        v0 = isDDVersion5 = earDDVersion.equals("5.0") != false;
                        if (isDDVersion5) {
                            app = (Application)ModelProviderManager.getModelProvider((IProject)project).getModelObject();
                            if (this.libDir == null) {
                                this.libDir = app.getLibraryDirectory();
                            }
                            if (this.libDir == null) {
                                this.libDir = "/lib";
                            }
                        }
                    }
                    newrefs = component.getReferences();
                    k = 0;
                    while (k < newrefs.length) {
                        tmpref = newrefs[k];
                        referencedcomp = tmpref.getReferencedComponent();
                        isBinary = referencedcomp.isBinary();
                        if (isBinary) {
                            if (this.shouldShow(referencedcomp)) {
                                validCompList.add(referencedcomp);
                            }
                        } else {
                            AvailableJ2EEComponentsForEARContentProvider.addClasspathComponentDependencies(validCompList, pathToComp, referencedcomp);
                        }
                        ++k;
                    }
                }
            } else {
                try {
                    if (!project.exists() || !project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature") || project.getName().startsWith(".")) ** GOTO lbl61
                    validCompList.add(project);
                }
                catch (CoreException e) {
                    Logger.getLogger().log((Throwable)e);
                }
            }
lbl61:
            // 6 sources

            ++i;
        }
        return validCompList.toArray();
    }

    public void setCurrentLibDir(String libDir) {
        this.libDir = libDir;
    }

    private boolean shouldShow(IVirtualComponent component) {
        IPath resolvedPath;
        File file;
        Path bPath;
        File bFile;
        IPath p = null;
        if (!(component instanceof VirtualArchiveComponent)) {
            return true;
        }
        VirtualArchiveComponent comp = (VirtualArchiveComponent)component;
        if (!comp.getProject().getName().equals(this.earComponent.getName())) {
            return false;
        }
        if (this.getComponentWorkspaceRelativePath(comp) != null) {
            try {
                p = this.getComponentProjectRelativePath(comp);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        } else if (comp.getArchiveType().equals("lib") ? (bFile = (bPath = new Path(component.getName().substring(4))).toFile()).exists() : comp.getArchiveType().equals("var") && (file = new File((resolvedPath = JavaCore.getResolvedVariablePath((IPath)new Path(component.getName().substring(4)))).toOSString())).isFile() && file.exists()) {
            return true;
        }
        if (p == null) {
            return false;
        }
        IContainer contentDir = this.earComponent.getRootFolder().getUnderlyingFolder();
        int ContentDirSegmentCount = contentDir.getProjectRelativePath().segmentCount();
        int numOfSegmentsToCompare = ContentDirSegmentCount + 1;
        if (ContentDirSegmentCount > 0 && !this.startWithSameSegments(p, contentDir.getProjectRelativePath())) {
            return false;
        }
        if (!this.startWithSameSegments(p, Path.fromOSString((String)(String.valueOf(contentDir.getProjectRelativePath().toString()) + '/' + this.libDir)))) {
            return true;
        }
        if (p.segmentCount() == numOfSegmentsToCompare) {
            return true;
        }
        if (this.isEE5) {
            String strippedLibDir = this.stripSeparators(this.libDir);
            String[] libDirSegs = strippedLibDir.split(PATH_SEPARATOR);
            if (p.segmentCount() - numOfSegmentsToCompare != libDirSegs.length) {
                return false;
            }
            int i = 0;
            while (i < libDirSegs.length) {
                if (!libDirSegs[i].equals(p.segment(i + ContentDirSegmentCount))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private IPath getComponentWorkspaceRelativePath(VirtualArchiveComponent component) {
        if (component.getWorkspaceRelativePath() != null) {
            return component.getWorkspaceRelativePath();
        }
        IFile aFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(component.getProject().getName()) + '/' + component.getName().substring(4)));
        if (aFile == null || aFile != null && !aFile.exists()) {
            return null;
        }
        return aFile.getFullPath();
    }

    private IPath getComponentProjectRelativePath(VirtualArchiveComponent component) {
        IFile aFile;
        IPath CompWorkspaceRelPath = this.getComponentWorkspaceRelativePath(component);
        if (CompWorkspaceRelPath != null && (aFile = ResourcesPlugin.getWorkspace().getRoot().getFile(CompWorkspaceRelPath)).exists()) {
            return aFile.getProjectRelativePath();
        }
        return null;
    }

    private boolean startWithSameSegments(IPath iPath1, IPath iPath2) {
        if (iPath1 == null || iPath2 == null) {
            return false;
        }
        int minor = iPath1.segmentCount() > iPath2.segmentCount() ? iPath2.segmentCount() : iPath1.segmentCount();
        int i = 0;
        while (i < minor) {
            if (!iPath1.segment(i).equals(iPath2.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String stripSeparators(String dir) {
        if (dir.startsWith(PATH_SEPARATOR)) {
            dir = dir.substring(1);
        }
        if (dir.endsWith(PATH_SEPARATOR)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        return dir;
    }

    public static void addClasspathComponentDependencies(List componentList, Map pathToComp, IVirtualComponent referencedComponent) {
        if (referencedComponent instanceof J2EEModuleVirtualComponent) {
            J2EEModuleVirtualComponent j2eeComp = (J2EEModuleVirtualComponent)referencedComponent;
            IVirtualReference[] cpRefs = j2eeComp.getJavaClasspathReferences();
            int j = 0;
            while (j < cpRefs.length) {
                if (cpRefs[j].getRuntimePath().equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH)) {
                    IPath path = ClasspathDependencyUtil.getClasspathVirtualReferenceLocation((IVirtualReference)cpRefs[j]);
                    IVirtualComponent comp = (IVirtualComponent)pathToComp.get(path);
                    if (comp != null) {
                        if (comp instanceof VirtualArchiveComponent) {
                            VirtualArchiveComponent oldComp = (VirtualArchiveComponent)comp;
                            componentList.remove(comp);
                            VirtualArchiveComponent newComponent = ClassPathSelection.updateDisplayVirtualArchiveComponent((VirtualArchiveComponent)oldComp, (IVirtualReference)cpRefs[j]);
                            pathToComp.put(path, newComponent);
                            componentList.add(newComponent);
                        }
                    } else {
                        pathToComp.put(path, cpRefs[j].getReferencedComponent());
                        componentList.add(cpRefs[j].getReferencedComponent());
                    }
                }
                ++j;
            }
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IVirtualComponent) {
            IVirtualComponent comp = (IVirtualComponent)element;
            String name = "";
            if (columnIndex == 0) {
                if (ClasspathDependencyUtil.isClasspathComponentDependency((IVirtualComponent)comp)) {
                    return ClasspathDependencyUtil.getClasspathComponentDependencyDisplayString((IVirtualComponent)comp);
                }
                IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.earComponent.getProject());
                if (provider instanceof IEARModelProvider && (name = ((IEARModelProvider)provider).getModuleURI(comp)) == null && this.earComponent.getProject().equals((Object)comp.getProject()) && (name = comp.getName()) != null) {
                    Path path = new Path(name);
                    name = path.lastSegment();
                }
                if (name == null || name == "") {
                    name = comp.getName();
                }
                return name;
            }
            if (columnIndex == 1) {
                return comp.getProject().getName();
            }
            if (columnIndex == 2) {
                return "";
            }
        } else if (element instanceof IProject) {
            if (columnIndex != 2) {
                return ((IProject)element).getName();
            }
            return "";
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

