/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.internal.ui.text.html.HTMLPrinter;
import org.eclipse.wst.jsdt.internal.ui.text.html.SubstitutionTextReader;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDocMessages;

public class JavaDoc2HTMLTextReader
extends SubstitutionTextReader {
    private List fParameters;
    private String fReturn;
    private List fExceptions;
    private List fAuthors;
    private List fSees;
    private List fSince;
    private List fRest;

    public JavaDoc2HTMLTextReader(Reader reader) {
        super(reader);
        this.setSkipWhitespace(false);
    }

    private int getTag(StringBuffer buffer) throws IOException {
        int c = this.nextChar();
        while (c == 46 || c != -1 && Character.isLetter((char)c)) {
            buffer.append((char)c);
            c = this.nextChar();
        }
        return c;
    }

    private int getContent(StringBuffer buffer, char stopChar) throws IOException {
        int c = this.nextChar();
        while (c != -1 && c != stopChar) {
            buffer.append((char)c);
            c = this.nextChar();
        }
        return c;
    }

    private int getContentUntilNextTag(StringBuffer buffer) throws IOException {
        int c = this.nextChar();
        boolean blockStartRead = false;
        while (c != -1) {
            if (c == 64) {
                int index = buffer.length();
                while (--index >= 0 && Character.isWhitespace(buffer.charAt(index))) {
                    switch (buffer.charAt(index)) {
                        case '\n': 
                        case '\r': {
                            return c;
                        }
                    }
                    if (index > 0) continue;
                    return c;
                }
            }
            if (blockStartRead) {
                buffer.append(this.processBlockTag());
                blockStartRead = false;
            } else {
                buffer.append((char)c);
            }
            c = this.nextChar();
            boolean bl = blockStartRead = c == 123;
        }
        return c;
    }

    private String substituteQualification(String qualification) {
        String result = qualification.replace('#', '.');
        if (result.startsWith(".")) {
            result = result.substring(1);
        }
        return result;
    }

    private void printDefinitions(StringBuffer buffer, List list, boolean firstword) {
        Iterator e = list.iterator();
        while (e.hasNext()) {
            String s = (String)e.next();
            buffer.append("<dd>");
            if (!firstword) {
                buffer.append(s);
            } else {
                buffer.append("<b>");
                int i = this.getParamEndOffset(s);
                if (i <= s.length()) {
                    buffer.append(HTMLPrinter.convertToHTMLContent(s.substring(0, i)));
                    buffer.append("</b>");
                    buffer.append(s.substring(i));
                } else {
                    buffer.append("</b>");
                }
            }
            buffer.append("</dd>");
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getParamEndOffset(String s) {
        block5: {
            i = 0;
            length = s.length();
            while (i < length && Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            if (i >= length || s.charAt(i) != '<') ** GOTO lbl18
            while (i < length && Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            while (i < length && Character.isJavaIdentifierPart(s.charAt(i))) {
                ++i;
            }
            while (i < length && s.charAt(i) != '>') {
                ++i;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl18:
                // 2 sources

                ** while (i < length && Character.isJavaIdentifierPart((char)s.charAt((int)i)))
            }
        }
        return i;
    }

    private void print(StringBuffer buffer, String tag, List elements, boolean firstword) {
        if (!elements.isEmpty()) {
            buffer.append("<dt>");
            buffer.append(tag);
            buffer.append("</dt>");
            this.printDefinitions(buffer, elements, firstword);
        }
    }

    private void print(StringBuffer buffer, String tag, String content) {
        if (content != null) {
            buffer.append("<dt>");
            buffer.append(tag);
            buffer.append("</dt>");
            buffer.append("<dd>");
            buffer.append(content);
            buffer.append("</dd>");
        }
    }

    private void printRest(StringBuffer buffer) {
        if (!this.fRest.isEmpty()) {
            Iterator e = this.fRest.iterator();
            while (e.hasNext()) {
                Pair p = (Pair)e.next();
                buffer.append("<dt>");
                if (p.fTag != null) {
                    buffer.append(p.fTag);
                }
                buffer.append("</dt>");
                buffer.append("<dd>");
                if (p.fContent != null) {
                    buffer.append(p.fContent);
                }
                buffer.append("</dd>");
            }
        }
    }

    private String printSimpleTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<dl>");
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_see_section, this.fSees, false);
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_parameters_section, this.fParameters, true);
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_returns_section, this.fReturn);
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_throws_section, this.fExceptions, false);
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_author_section, this.fAuthors, false);
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_since_section, this.fSince, false);
        this.printRest(buffer);
        buffer.append("</dl>");
        return buffer.toString();
    }

    private void handleTag(String tag, String tagContent) {
        tagContent = tagContent.trim();
        if ("@param".equals(tag)) {
            this.fParameters.add(tagContent);
        } else if ("@return".equals(tag)) {
            this.fReturn = tagContent;
        } else if ("@exception".equals(tag)) {
            this.fExceptions.add(tagContent);
        } else if ("@throws".equals(tag)) {
            this.fExceptions.add(tagContent);
        } else if ("@author".equals(tag)) {
            this.fAuthors.add(this.substituteQualification(tagContent));
        } else if ("@see".equals(tag)) {
            this.fSees.add(this.substituteQualification(tagContent));
        } else if (" ".equals(tag)) {
            this.fSince.add(this.substituteQualification(tagContent));
        } else if (tagContent != null) {
            this.fRest.add(new Pair(tag, tagContent));
        }
    }

    private String processSimpleTag() throws IOException {
        this.fParameters = new ArrayList();
        this.fExceptions = new ArrayList();
        this.fAuthors = new ArrayList();
        this.fSees = new ArrayList();
        this.fSince = new ArrayList();
        this.fRest = new ArrayList();
        StringBuffer buffer = new StringBuffer();
        int c = 64;
        while (c != -1) {
            buffer.setLength(0);
            buffer.append((char)c);
            c = this.getTag(buffer);
            String tag = buffer.toString();
            buffer.setLength(0);
            if (c != -1) {
                c = this.getContentUntilNextTag(buffer);
            }
            this.handleTag(tag, buffer.toString());
        }
        return this.printSimpleTag();
    }

    private String printBlockTag(String tag, String tagContent) {
        if ("@link".equals(tag) || "@linkplain".equals(tag)) {
            char[] contentChars = tagContent.toCharArray();
            boolean inParentheses = false;
            int labelStart = 0;
            int i = 0;
            while (i < contentChars.length) {
                char nextChar = contentChars[i];
                if (i == 0 && Character.isWhitespace(nextChar)) {
                    labelStart = 1;
                } else if (nextChar == '(') {
                    inParentheses = true;
                } else if (nextChar == ')') {
                    inParentheses = false;
                } else if (!inParentheses && Character.isWhitespace(nextChar)) {
                    labelStart = i + 1;
                    break;
                }
                ++i;
            }
            if ("@link".equals(tag)) {
                return "<code>" + this.substituteQualification(tagContent.substring(labelStart)) + "</code>";
            }
            return this.substituteQualification(tagContent.substring(labelStart));
        }
        if ("@literal".equals(tag)) {
            return this.printLiteral(tagContent);
        }
        if ("@code".equals(tag)) {
            return "<code>" + this.printLiteral(tagContent) + "</code>";
        }
        return this.substituteQualification(tagContent);
    }

    private String printLiteral(String tagContent) {
        int contentStart = 0;
        int i = 0;
        while (i < tagContent.length()) {
            if (!Character.isWhitespace(tagContent.charAt(i))) {
                contentStart = i;
                break;
            }
            ++i;
        }
        return HTMLPrinter.convertToHTMLContent(tagContent.substring(contentStart));
    }

    private String processBlockTag() throws IOException {
        int c = this.nextChar();
        if (c != 64) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('{');
            buffer.append((char)c);
            return buffer.toString();
        }
        StringBuffer buffer = new StringBuffer();
        if (c != -1) {
            buffer.setLength(0);
            buffer.append((char)c);
            c = this.getTag(buffer);
            String tag = buffer.toString();
            buffer.setLength(0);
            if (c != -1 && c != 125) {
                buffer.append((char)c);
                c = this.getContent(buffer, '}');
            }
            return this.printBlockTag(tag, buffer.toString());
        }
        return null;
    }

    protected String computeSubstitution(int c) throws IOException {
        if (c == 64 && this.fWasWhiteSpace) {
            return this.processSimpleTag();
        }
        if (c == 123) {
            return this.processBlockTag();
        }
        return null;
    }

    private static class Pair {
        String fTag;
        String fContent;

        Pair(String tag, String content) {
            this.fTag = tag;
            this.fContent = content;
        }
    }
}

