/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class J2EEDependencyListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static J2EEDependencyListener INSTANCE = new J2EEDependencyListener();
    private List<IProject> cachedEARModuleDependencies = new ArrayList<IProject>();

    private J2EEDependencyListener() {
    }

    private void cacheModuleDependencies(IProject earProject) {
        if (EarUtilities.isEARProject(earProject)) {
            IVirtualReference[] refs = EarUtilities.getComponentReferences(ComponentCore.createComponent((IProject)earProject));
            IVirtualComponent comp = null;
            int j = 0;
            while (j < refs.length) {
                comp = refs[j].getReferencedComponent();
                if (!comp.isBinary()) {
                    this.cachedEARModuleDependencies.add(comp.getProject());
                }
                ++j;
            }
        }
    }

    private void updateModuleDependencies() {
        if (!this.cachedEARModuleDependencies.isEmpty()) {
            Iterator<IProject> iterator = this.cachedEARModuleDependencies.iterator();
            while (iterator.hasNext()) {
                IDependencyGraph.INSTANCE.update(iterator.next());
            }
            this.cachedEARModuleDependencies.clear();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            try {
                IDependencyGraph.INSTANCE.preUpdate();
                switch (event.getType()) {
                    case 2: 
                    case 4: {
                        IResource resource = event.getResource();
                        if (resource.getType() == 4) {
                            this.cacheModuleDependencies((IProject)resource);
                        }
                        break;
                    }
                    case 1: {
                        event.getDelta().accept((IResourceDeltaVisitor)this);
                    }
                }
            }
            catch (CoreException e) {
                J2EEPlugin.logError(e);
                IDependencyGraph.INSTANCE.postUpdate();
            }
        }
        finally {
            IDependencyGraph.INSTANCE.postUpdate();
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                int kind = delta.getKind();
                if ((1 & kind) != 0) {
                    if (EarUtilities.isEARProject((IProject)resource)) {
                        this.cacheModuleDependencies((IProject)resource);
                        this.updateModuleDependencies();
                    }
                    return false;
                }
                if ((2 & kind) != 0) {
                    this.updateModuleDependencies();
                    return false;
                }
                if ((4 & kind) != 0) {
                    int flags = delta.getFlags();
                    if ((0x4000 & flags) != 0) {
                        boolean isOpen = ((IProject)resource).isOpen();
                        if (isOpen) {
                            this.cacheModuleDependencies((IProject)resource);
                        }
                        this.updateModuleDependencies();
                    }
                    return true;
                }
                return false;
            }
            case 2: {
                return true;
            }
            case 1: {
                IVirtualReference[] refs;
                IVirtualComponent comp;
                String name = resource.getName();
                if (name.equals("MANIFEST.MF")) {
                    IFile manifestFile = J2EEProjectUtilities.getManifestFile(resource.getProject(), false);
                    if (manifestFile != null && !resource.equals((Object)manifestFile)) break;
                    IDependencyGraph.INSTANCE.update(resource.getProject(), 0);
                    break;
                }
                if (name.equals("org.eclipse.wst.common.component")) {
                    IProject[] allProjects;
                    if (!EarUtilities.isEARProject(resource.getProject())) break;
                    IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int n = allProjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject sourceProject = iProjectArray[n2];
                        IDependencyGraph.INSTANCE.update(sourceProject, 0);
                        ++n2;
                    }
                    break;
                }
                if (!J2EEDependencyListener.endsWithIgnoreCase(name, ".jar") && !J2EEDependencyListener.endsWithIgnoreCase(name, ".war") && !J2EEDependencyListener.endsWithIgnoreCase(name, ".rar") || !EarUtilities.isEARProject(resource.getProject()) || !J2EEDependencyListener.isInTree((IFile)resource, (comp = ComponentCore.createComponent((IProject)resource.getProject())).getRootFolder())) break;
                IVirtualReference[] iVirtualReferenceArray = refs = comp.getReferences();
                int n = refs.length;
                int n3 = 0;
                while (n3 < n) {
                    IVirtualReference ref = iVirtualReferenceArray[n3];
                    IDependencyGraph.INSTANCE.update(ref.getReferencedComponent().getProject(), 0);
                    ++n3;
                }
                IDependencyGraph.INSTANCE.update(resource.getProject(), 0);
            }
        }
        return false;
    }

    public static boolean isInTree(IFile file, IVirtualFolder folder) {
        if (J2EEDependencyListener.isFolder((IResource)file.getParent(), folder)) {
            return true;
        }
        IContainer[] underlying = folder.getUnderlyingFolders();
        int i = 0;
        while (i < underlying.length) {
            if (underlying[i].getFullPath().isPrefixOf(file.getFullPath())) {
                return true;
            }
            ++i;
        }
        boolean found = false;
        try {
            IVirtualResource[] children = folder.members();
            int i2 = 0;
            while (i2 < children.length && !found) {
                if (children[i2].getType() == 32) {
                    found |= J2EEDependencyListener.isInTree(file, (IVirtualFolder)children[i2]);
                }
                ++i2;
            }
        }
        catch (CoreException ce) {
            J2EEPlugin.logError(ce);
        }
        return found;
    }

    public static boolean endsWithIgnoreCase(String str, String sfx) {
        return J2EEComponentClasspathUpdater.endsWithIgnoreCase(str, sfx);
    }

    public static boolean isFolder(IResource resource, IVirtualFolder folder) {
        return J2EEComponentClasspathUpdater.isFolder(resource, folder);
    }
}

