/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.ltk.core.participant;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jst.j2ee.project.EJBUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ltk.core.change.DeleteEJBClientProjectChange;
import org.eclipse.jst.javaee.ltk.core.change.EARReferenceRemoveChange;
import org.eclipse.jst.javaee.ltk.core.change.NonEARModuleReferenceRemoveChange;
import org.eclipse.jst.javaee.ltk.core.nls.RefactoringResourceHandler;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JavaEERefactoringParticipant
extends DeleteParticipant {
    private IProject projectToDelete = null;
    private IProject ejbClientProject = null;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange result = null;
        result = this.createChangeObjects(result, this.projectToDelete);
        if (this.ejbClientProject != null) {
            result = this.createChangeObjects(result, this.ejbClientProject);
            DeleteEJBClientProjectChange dc = new DeleteEJBClientProjectChange(this.ejbClientProject, true, true);
            result.add((Change)dc);
        }
        return result;
    }

    private CompositeChange createChangeObjects(CompositeChange compositeChange, IProject projectToBeDeleted) {
        Set referencingComponents = IDependencyGraph.INSTANCE.getReferencingComponents(projectToBeDeleted);
        IProject[] dependentProjectList = referencingComponents.toArray(new IProject[referencingComponents.size()]);
        if (dependentProjectList.length > 0) {
            if (compositeChange == null) {
                compositeChange = new CompositeChange(this.getName());
            }
            int i = 0;
            while (i < dependentProjectList.length) {
                IProject dependentProject = dependentProjectList[i];
                if (JavaEEProjectUtilities.isEARProject(dependentProjectList[i])) {
                    EARReferenceRemoveChange ec = new EARReferenceRemoveChange(dependentProject, projectToBeDeleted);
                    compositeChange.add((Change)ec);
                } else {
                    NonEARModuleReferenceRemoveChange nc = new NonEARModuleReferenceRemoveChange(dependentProject, projectToBeDeleted);
                    compositeChange.add((Change)nc);
                }
                ++i;
            }
        }
        return compositeChange;
    }

    private IProject getClientProject(IProject ejbProject) {
        IVirtualComponent clientComponent;
        if (ejbProject.exists() && ejbProject.isAccessible() && (clientComponent = EJBUtilities.getEJBClientJar(ejbProject)) != null) {
            return clientComponent.getProject();
        }
        return null;
    }

    public String getName() {
        String name = NLS.bind((String)RefactoringResourceHandler.JavaEE_Refactorings_Participant_title, (Object[])new Object[]{this.projectToDelete.getName()});
        return name;
    }

    protected boolean initialize(Object element) {
        if (!(element instanceof IProject)) {
            return false;
        }
        this.projectToDelete = (IProject)element;
        if (JavaEEProjectUtilities.isEJBProject(this.projectToDelete)) {
            this.ejbClientProject = this.getClientProject(this.projectToDelete);
        }
        return true;
    }
}

